/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.arelle.ArelleService;
import ru.cbr.xbrl.converter.arelle.data.XbrlParsedData;
import ru.cbr.xbrl.converter.exception.CancelledException;
import ru.cbr.xbrl.converter.exception.CommandExecutionException;
import ru.cbr.xbrl.converter.exception.SkipTlbException;
import ru.cbr.xbrl.converter.exception.XmlParsingContentException;
import ru.cbr.xbrl.converter.model.PresentationConcept;
import ru.cbr.xbrl.converter.model.PresentationLinkRole;
import ru.cbr.xbrl.converter.model.RoleType;
import ru.cbr.xbrl.converter.model.XbrlDimension;
import ru.cbr.xbrl.converter.model.XbrlFormula;
import ru.cbr.xbrl.converter.model.XbrlPresentation;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.XbrlRoleTypes;
import ru.cbr.xbrl.converter.model.tableLinkBase.DataCell;
import ru.cbr.xbrl.converter.model.tableLinkBase.DataCells;
import ru.cbr.xbrl.converter.model.tableLinkBase.DataCoordinates;
import ru.cbr.xbrl.converter.model.tableLinkBase.EnumerateItem;
import ru.cbr.xbrl.converter.model.tableLinkBase.Group;
import ru.cbr.xbrl.converter.model.tableLinkBase.Header;
import ru.cbr.xbrl.converter.model.tableLinkBase.HeaderCell;
import ru.cbr.xbrl.converter.model.tableLinkBase.NodeType;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBase;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.model.xbrl_content.PeriodType;
import ru.cbr.xbrl.converter.service.ConceptService;
import ru.cbr.xbrl.converter.service.TableLinkBaseStructureService;
import ru.cbr.xbrl.converter.service.XbrlParsedDataService;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;

@Service
public class XbrlParsedDataServiceImpl
implements XbrlParsedDataService {
    private static final Logger log = LoggerFactory.getLogger(XbrlParsedDataServiceImpl.class);
    private static final String LINK_ROLE = "linkRole";
    private static final String ROLE = "role";
    private static final String FACTS = "facts";
    private static final String CONCEPT = "concept";
    private static final String ABSTRACT = "abstract";
    private static final String LABEL = "label";
    private static final String DOCUMENTATION = "documentation";
    private static final String ROLE_ID = "roleId";
    private static final String ROLE_LABEL = "roleLabel";
    private static final String NAME = "name";
    private static final String ROLE_TYPE = "roleType";
    private static final String DEFINED_IN = "definedIn";
    private static final String ROLE_URI = "roleURI";
    private static final String ROLE_DEFINITION = "definition";
    private static final String ROLE_USED_ON = "usedOn";
    private static final String FORMULAE = "formulae";
    private static final String ID = "id";
    private static final String FORMULA_OBJECT = "formulaObject";
    private static final String TYPE = "type";
    private static final String MESSAGE = "message";
    private static final String EXPRESSION = "expression";
    private static final String VALUE_ASSERTION = "valueAssertion";
    private static final String EXISTENCE_ASSERTION = "existenceAssertion";
    private static final String ASSERTION_SET = "assertionSet";
    private static final String TABLE_SET = "tableSet";
    private static final String CELL = "cell";
    private static final String HEADERS = "headers";
    private static final String AXIS = "axis";
    private static final String GROUP = "group";
    private static final String PARENT_ID = "parentId";
    private static final String ASPECT = "aspect";
    private static final String VALUE = "value";
    private static final String PERIOD = "period";
    private static final String MULTIPLY_BY = "multiply by";
    private static final String DIMENSION = "dimension";
    private static final String CELLS = "CELLS";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String Z = "z";
    private static final String FACT_VALUE = "factValue";
    private static final String DATE = "date";
    private static final String GENERATED = "EMPTY_AXIS";
    private static final String LINKROLE = "linkrole";
    private static final String CONCEPT_PERIOD_TYPE = "conceptPeriodType";
    private static final String CONSTRAINT = "constraint";
    private static final String DIMENSIONS_DEFAULT = "dimensionsDefault";
    private static final String DIM = "dim";
    private static final String MEM = "mem";
    private static final String SEVERITY = "severity";
    private static final String ENUMERATE = "enumerate";
    private static final String ENUMERATE_ITEM = "enumerateItem";
    private static final String MEMBER = "member";
    private static final String MERGE = "merge";
    private static final String MEMBERS = "members";
    @Autowired
    private ArelleService arelleService;
    @Autowired
    private TableLinkBaseStructureService tableLinkBaseStructureService;
    @Autowired
    private ConceptService conceptService;

    public XbrlParsedData parse(XbrlReport xbrlReport, String[] packages) throws CommandExecutionException, CancelledException {
        String filePath = xbrlReport.getFilePath();
        return this.arelleService.read(filePath, packages);
    }

    public Map<String, String> saveArelleProcessFiles(String filePath, String[] packages) throws CommandExecutionException, CancelledException {
        String[] options = new String[]{"pre", DIM, FORMULAE, "exportDir", "parametersFile", "refFile", "labelRolesFile", "namespacesFile"};
        Map map = this.arelleService.saveOutputFiles(filePath, packages, options);
        return map;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public XbrlPresentation getXbrlPresentationInfo(String presentationReportPath) {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        try (FileInputStream fileInputStream = new FileInputStream(presentationReportPath);){
            XMLStreamReader reader = xmlInputFactory.createXMLStreamReader(new BufferedInputStream(fileInputStream));
            if (reader == null) {
                XbrlPresentation xbrlPresentation2 = null;
                return xbrlPresentation2;
            }
            XbrlPresentation xbrlPresentation3 = new XbrlPresentation();
            String currentRole = "";
            PresentationConcept currentPresentationConcept = null;
            while (reader.hasNext()) {
                int eventType = reader.next();
                switch (eventType) {
                    case 7: {
                        break;
                    }
                    case 1: {
                        QName attributeName;
                        int n;
                        String currentStartElement = reader.getName().toString();
                        if (StringUtils.equalsIgnoreCase((CharSequence)LINK_ROLE, (CharSequence)currentStartElement)) {
                            PresentationLinkRole presentationLinkRole = new PresentationLinkRole();
                            n = reader.getAttributeCount();
                            for (int i = 0; i < n; ++i) {
                                attributeName = reader.getAttributeName(i);
                                if (!StringUtils.equalsIgnoreCase((CharSequence)ROLE, (CharSequence)attributeName.toString())) continue;
                                currentRole = reader.getAttributeValue(i);
                                presentationLinkRole.setName(currentRole);
                            }
                            if (!StringUtils.isNotBlank((CharSequence)currentRole)) break;
                            xbrlPresentation3.getRoleMap().put(currentRole, presentationLinkRole);
                            break;
                        }
                        if (!StringUtils.equalsIgnoreCase((CharSequence)CONCEPT, (CharSequence)currentStartElement)) break;
                        PresentationConcept roleConcept = new PresentationConcept();
                        n = reader.getAttributeCount();
                        for (int i = 0; i < n; ++i) {
                            attributeName = reader.getAttributeName(i);
                            if (StringUtils.equalsIgnoreCase((CharSequence)LABEL, (CharSequence)attributeName.toString())) {
                                roleConcept.setLabel(reader.getAttributeValue(i));
                            }
                            if (!StringUtils.equalsIgnoreCase((CharSequence)NAME, (CharSequence)attributeName.toString())) continue;
                            roleConcept.setName(reader.getAttributeValue(i));
                        }
                        if (currentPresentationConcept != null) {
                            roleConcept.setParentConcept(currentPresentationConcept);
                        }
                        currentPresentationConcept = roleConcept;
                        break;
                    }
                    case 2: {
                        String currentEndElement = reader.getName().toString();
                        if (StringUtils.equalsIgnoreCase((CharSequence)LINK_ROLE, (CharSequence)currentEndElement)) {
                            currentRole = "";
                            break;
                        }
                        if (!StringUtils.equalsIgnoreCase((CharSequence)CONCEPT, (CharSequence)currentEndElement) || currentPresentationConcept == null) break;
                        PresentationConcept parentConcept = currentPresentationConcept.getParentConcept();
                        PresentationLinkRole presentationLinkRole = (PresentationLinkRole)xbrlPresentation3.getRoleMap().get(currentRole);
                        if (presentationLinkRole != null) {
                            presentationLinkRole.getPresentationConceptMap().put(currentPresentationConcept.getName(), currentPresentationConcept);
                        }
                        currentPresentationConcept = parentConcept;
                        break;
                    }
                }
            }
            XbrlPresentation xbrlPresentation = xbrlPresentation3;
            return xbrlPresentation;
        }
        catch (XMLStreamException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (FileNotFoundException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<XbrlFormula> getXbrlReportFormulaObjectList(String formulaeFilePath) {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        ArrayList<XbrlFormula> xbrlFormulaObjectList = new ArrayList<XbrlFormula>();
        try (FileInputStream fileInputStream = new FileInputStream(formulaeFilePath);){
            XMLStreamReader reader = xmlInputFactory.createXMLStreamReader(new BufferedInputStream(fileInputStream));
            if (reader == null) {
                List<XbrlFormula> list = Collections.emptyList();
                return list;
            }
            block20: while (reader.hasNext()) {
                int eventType = reader.next();
                block7 : switch (eventType) {
                    case 7: {
                        break;
                    }
                    case 1: {
                        String currentStartElement = reader.getName().toString();
                        if (!StringUtils.equalsIgnoreCase((CharSequence)FORMULA_OBJECT, (CharSequence)currentStartElement)) break;
                        int n = reader.getAttributeCount();
                        for (int i = 0; i < n; ++i) {
                            QName attributeName = reader.getAttributeName(i);
                            if (!StringUtils.equalsIgnoreCase((CharSequence)ID, (CharSequence)attributeName.toString())) continue;
                            XbrlFormula currentFormulaObject = this.parseFormula(reader);
                            if (currentFormulaObject == null) continue block20;
                            xbrlFormulaObjectList.add(currentFormulaObject);
                            break block7;
                        }
                        continue block20;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return xbrlFormulaObjectList;
    }

    private XbrlFormula parseFormula(XMLStreamReader reader) throws XMLStreamException {
        XbrlFormula currentFormulaObject = new XbrlFormula();
        int n = reader.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            QName attributeName = reader.getAttributeName(i);
            String attributeValue = reader.getAttributeValue(i);
            if (StringUtils.equalsIgnoreCase((CharSequence)ID, (CharSequence)attributeName.toString())) {
                currentFormulaObject.setName(attributeValue);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)SEVERITY, (CharSequence)attributeName.toString())) {
                currentFormulaObject.setSeverity(attributeValue);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)ROLE_ID, (CharSequence)attributeName.toString())) {
                currentFormulaObject.setRoleId(attributeValue);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)ROLE_LABEL, (CharSequence)attributeName.toString())) {
                currentFormulaObject.setRoleLabel(attributeValue);
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)TYPE, (CharSequence)attributeName.toString())) continue;
            currentFormulaObject.setType(attributeValue);
            if (StringUtils.equalsIgnoreCase((CharSequence)VALUE_ASSERTION, (CharSequence)attributeValue) || StringUtils.equalsIgnoreCase((CharSequence)EXISTENCE_ASSERTION, (CharSequence)attributeValue)) continue;
            currentFormulaObject.clear();
        }
        int formulaObjectLevelCounter = 0;
        block6: while (reader.hasNext()) {
            int eventType = reader.next();
            switch (eventType) {
                case 7: {
                    break;
                }
                case 1: {
                    String currentStartElement = reader.getName().toString();
                    if (!StringUtils.equalsIgnoreCase((CharSequence)FORMULA_OBJECT, (CharSequence)currentStartElement) || ++formulaObjectLevelCounter != 1) break;
                    int n2 = reader.getAttributeCount();
                    for (int i = 0; i < n2; ++i) {
                        QName attributeName = reader.getAttributeName(i);
                        if (!StringUtils.equalsIgnoreCase((CharSequence)TYPE, (CharSequence)attributeName.toString()) || !StringUtils.equalsIgnoreCase((CharSequence)MESSAGE, (CharSequence)reader.getAttributeValue(i))) continue;
                        currentFormulaObject.setLabel(this.parseFormulaMessage(reader));
                    }
                    continue block6;
                }
                case 2: {
                    String currentEndElement = reader.getName().toString();
                    if (!StringUtils.equalsIgnoreCase((CharSequence)FORMULA_OBJECT, (CharSequence)currentEndElement) || --formulaObjectLevelCounter == 0 || formulaObjectLevelCounter != -1) break;
                    return currentFormulaObject;
                }
            }
        }
        return null;
    }

    private String parseFormulaMessage(XMLStreamReader reader) throws XMLStreamException {
        String currentStartElement = reader.getName().toString();
        if (!StringUtils.equalsIgnoreCase((CharSequence)FORMULA_OBJECT, (CharSequence)currentStartElement)) {
            log.warn("\u041f\u0430\u0440\u0441\u0438\u043d\u0433 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u0444\u043e\u0440\u043c\u0443\u043b\u044b. \u041e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0439 \u0442\u0435\u0433 \u0434\u043b\u044f \u043f\u0430\u0440\u0441\u0438\u043d\u0433\u0430. \u041e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f {}, \u043f\u043e\u043b\u0443\u0447\u0435\u043d {}", (Object)FORMULA_OBJECT, (Object)currentStartElement);
            return "";
        }
        while (reader.hasNext()) {
            int eventType = reader.next();
            switch (eventType) {
                case 1: {
                    currentStartElement = reader.getName().toString();
                    if (!StringUtils.equalsIgnoreCase((CharSequence)EXPRESSION, (CharSequence)currentStartElement)) break;
                    return reader.getElementText();
                }
                case 2: {
                    String currentEndElement = reader.getName().toString();
                    if (!StringUtils.equalsIgnoreCase((CharSequence)FORMULA_OBJECT, (CharSequence)currentEndElement)) break;
                    log.warn("\u041f\u0430\u0440\u0441\u0438\u043d\u0433 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u0444\u043e\u0440\u043c\u0443\u043b\u044b. \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0432\u043d\u0443\u0442\u0440\u0438 \u0442\u0435\u0433\u0430 expression.");
                    return "";
                }
            }
        }
        return "";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public XbrlRoleTypes getXbrlRoleTypes(String roleTypesReportPath) {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        try (FileInputStream fileInputStream = new FileInputStream(roleTypesReportPath);){
            XMLStreamReader reader = xmlInputFactory.createXMLStreamReader(new BufferedInputStream(fileInputStream));
            if (reader == null) {
                XbrlRoleTypes xbrlRoleTypes2 = null;
                return xbrlRoleTypes2;
            }
            XbrlRoleTypes xbrlRoleTypes3 = new XbrlRoleTypes();
            RoleType currentRoleType = null;
            block21: while (reader.hasNext()) {
                int eventType = reader.next();
                switch (eventType) {
                    case 7: {
                        break;
                    }
                    case 1: {
                        String currentStartElement = reader.getName().toString();
                        if (StringUtils.equalsIgnoreCase((CharSequence)ROLE_TYPE, (CharSequence)currentStartElement)) {
                            currentRoleType = new RoleType();
                            int n = reader.getAttributeCount();
                            for (int i = 0; i < n; ++i) {
                                QName attributeName = reader.getAttributeName(i);
                                if (!StringUtils.equalsIgnoreCase((CharSequence)DEFINED_IN, (CharSequence)attributeName.toString())) continue;
                                String definedIn = reader.getAttributeValue(i);
                                currentRoleType.setDefinedIn(definedIn);
                            }
                            continue block21;
                        }
                        if (currentRoleType == null) break;
                        if (StringUtils.equalsIgnoreCase((CharSequence)ROLE_URI, (CharSequence)currentStartElement)) {
                            currentRoleType.setRoleURI(reader.getElementText());
                            break;
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)ROLE_DEFINITION, (CharSequence)currentStartElement)) {
                            currentRoleType.setDefinition(reader.getElementText());
                            break;
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)ROLE_USED_ON, (CharSequence)currentStartElement)) {
                            currentRoleType.setUsedOn(reader.getElementText());
                            break;
                        }
                    }
                    case 2: {
                        String roleURI;
                        String currentEndElement = reader.getName().toString();
                        if (!StringUtils.equalsIgnoreCase((CharSequence)ROLE_TYPE, (CharSequence)currentEndElement) || currentRoleType == null || StringUtils.isBlank((CharSequence)(roleURI = currentRoleType.getRoleURI()))) break;
                        xbrlRoleTypes3.getRoleTypeMap().put(roleURI, currentRoleType);
                        currentRoleType = null;
                        break;
                    }
                }
            }
            XbrlRoleTypes xbrlRoleTypes = xbrlRoleTypes3;
            return xbrlRoleTypes;
        }
        catch (XMLStreamException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (FileNotFoundException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return null;
    }

    public TableLinkBaseStructure getTableLinkBaseStructureByRole(String roleFilePath) {
        TableLinkBase tableLinkBase = null;
        try {
            tableLinkBase = this.getTableLinkBaseByRole(roleFilePath);
        }
        catch (SkipTlbException e) {
            log.debug(ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (tableLinkBase == null) {
            return null;
        }
        try {
            TableLinkBaseStructure structure = this.tableLinkBaseStructureService.createSafetyStructure(tableLinkBase);
            return structure;
        }
        catch (SkipTlbException e) {
            log.debug(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TableLinkBase getTableLinkBaseByRole(String roleFilePath) throws SkipTlbException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        try (FileInputStream fileInputStream = new FileInputStream(roleFilePath);){
            XMLStreamReader reader = xmlInputFactory.createXMLStreamReader(new BufferedInputStream(fileInputStream));
            if (reader == null) {
                TableLinkBase tableLinkBase = null;
                return tableLinkBase;
            }
            TableLinkBase tableLinkBase = new TableLinkBase();
            block26: while (reader.hasNext()) {
                int eventType = reader.next();
                switch (eventType) {
                    case 7: {
                        break;
                    }
                    case 1: {
                        String currentStartElement = reader.getName().getLocalPart();
                        if (StringUtils.equalsIgnoreCase((CharSequence)DIMENSIONS_DEFAULT, (CharSequence)currentStartElement)) {
                            Map dimensionsDefault = this.parseDimensionsDefault(reader);
                            tableLinkBase.setDimensionsDefault(dimensionsDefault);
                            break;
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)HEADERS, (CharSequence)currentStartElement)) {
                            Header currentHeader;
                            try {
                                currentHeader = this.parseTLBHeader(reader, (key, enumerateItems) -> tableLinkBase.getEnumerations().computeIfAbsent(key, s -> {
                                    enumerateItems.sort(Comparator.comparing(EnumerateItem::getLabel));
                                    return enumerateItems;
                                }), xbrlDimensionList -> {
                                    if (org.springframework.util.CollectionUtils.isEmpty((Collection)xbrlDimensionList)) {
                                        return;
                                    }
                                    XbrlDimension xbrlDimension = (XbrlDimension)xbrlDimensionList.get(0);
                                    if (xbrlDimension == null) {
                                        return;
                                    }
                                    String dimInt = xbrlDimension.getDimInt();
                                    List existingXbrlDimensionList = (List)tableLinkBase.getXbrlRoleDimensionMemberMap().get(dimInt);
                                    if (!org.springframework.util.CollectionUtils.isEmpty((Collection)existingXbrlDimensionList)) {
                                        log.warn("\u041f\u0430\u0440\u0441\u0438\u043d\u0433 \u0444\u0430\u0439\u043b\u0430 table link base {}. \u0414\u043b\u044f \u043e\u0434\u043d\u043e\u0433\u043e \u0438 \u0442\u043e\u0433\u043e \u0436\u0435 dimension {} \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0441\u043f\u0438\u0441\u043a\u043e\u0432 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0445 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u043f\u0435\u0440\u0432\u044b\u0439 \u0441\u043f\u0438\u0441\u043e\u043a.", (Object)roleFilePath, (Object)dimInt);
                                        return;
                                    }
                                    tableLinkBase.getXbrlRoleDimensionMemberMap().put(dimInt, xbrlDimensionList);
                                });
                            }
                            catch (XmlParsingContentException e) {
                                TableLinkBase tableLinkBase2 = new TableLinkBase();
                                if (fileInputStream == null) return tableLinkBase2;
                                if (var5_7 == null) {
                                    fileInputStream.close();
                                    return tableLinkBase2;
                                }
                                try {
                                    fileInputStream.close();
                                    return tableLinkBase2;
                                }
                                catch (Throwable throwable) {
                                    var5_7.addSuppressed(throwable);
                                    return tableLinkBase2;
                                }
                            }
                            if (currentHeader == null) {
                                log.debug("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430 Table linkbase. \u0412 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0435 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u043f\u0443\u0441\u0442\u043e\u0439 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a.");
                                break;
                            }
                            this.setAxisHeaderToTLB(tableLinkBase, currentHeader);
                            break;
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)LABEL, (CharSequence)currentStartElement)) {
                            String label = reader.getElementText();
                            if (label.contains("\u00a0")) {
                                label = label.replace("\u00a0", " ");
                            }
                            tableLinkBase.setLabel(label);
                            break;
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)DOCUMENTATION, (CharSequence)currentStartElement)) {
                            tableLinkBase.setDocumentation(reader.getElementText());
                            break;
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)ROLE_ID, (CharSequence)currentStartElement)) {
                            String roleId = reader.getElementText();
                            if ("table".equalsIgnoreCase(roleId)) {
                                log.warn("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0440\u043e\u043b\u0438: table");
                            }
                            tableLinkBase.setRoleId(roleId);
                            break;
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)LINKROLE, (CharSequence)currentStartElement)) {
                            tableLinkBase.setLinkrole(reader.getElementText());
                            break;
                        }
                        if (!StringUtils.equalsIgnoreCase((CharSequence)CELLS, (CharSequence)currentStartElement)) break;
                        String periodAxis = this.getPeriodAxis(tableLinkBase);
                        DataCells dataCells = this.parseDataCells(reader, periodAxis);
                        tableLinkBase.setData(dataCells);
                        break;
                    }
                    case 2: {
                        String string = reader.getName().getLocalPart();
                        continue block26;
                    }
                }
            }
            if (tableLinkBase.getHeaderZ() != null) {
                tableLinkBase.getHeaderZ().setGroupList((List)this.linearizeGroup(tableLinkBase.getHeaderZ()));
                tableLinkBase.getHeaderZ().rebuildHeaderMaps();
            }
            this.fixArelleOutputForAspectBreakdowns_v2(tableLinkBase.getHeaderZ());
            this.fixArelleOutputForAspectBreakdowns_v2(tableLinkBase.getHeaderY());
            this.fixArelleOutputForAspectBreakdowns_v2(tableLinkBase.getHeaderX());
            this.makeUpperGroupsAbstract(tableLinkBase.getHeaderZ());
            this.makeUpperGroupsAbstract(tableLinkBase.getHeaderY());
            this.makeUpperGroupsAbstract(tableLinkBase.getHeaderX());
            this.deleteMerged(tableLinkBase.getHeaderY());
            this.deleteMerged(tableLinkBase.getHeaderX());
            this.sortGroups(tableLinkBase.getHeaderZ());
            this.sortGroups(tableLinkBase.getHeaderY());
            this.sortGroups(tableLinkBase.getHeaderX());
            this.conceptService.store();
            TableLinkBase tableLinkBase3 = tableLinkBase;
            return tableLinkBase3;
        }
        catch (XMLStreamException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
        catch (FileNotFoundException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return null;
    }

    private void fixArelleOutputForAspectBreakdowns(Header header) {
        if (header == null || header.getGroupList().size() <= 1) {
            return;
        }
        boolean hasAspectNodes = header.getGroupList().stream().anyMatch(group -> group.getHeaderCellList().stream().anyMatch(headerCell -> headerCell.getNodeType() == NodeType.ASPECT));
        if (hasAspectNodes) {
            this.removeCellsWithDuplicateAspectDataList(header);
            if (header.getGroupList().size() > 1) {
                for (int i = 0; i < header.getGroupList().size() - 1; ++i) {
                    Group currentGroup = (Group)header.getGroupList().get(i);
                    HeaderCell currentGroupLeaf = (HeaderCell)currentGroup.getLeafs().get(0);
                    Group nextGroup = (Group)header.getGroupList().get(i + 1);
                    nextGroup.getRoots().forEach(nextGroupRoot -> nextGroupRoot.setParentId(currentGroupLeaf.getId()));
                }
            }
        }
    }

    private void fixArelleOutputForAspectBreakdowns_v2(Header header) {
        if (header == null || header.getGroupList().size() <= 1) {
            return;
        }
        HashSet bannedParents = new HashSet();
        header.getGroupList().forEach(group -> {
            Iterator it = group.getHeaderCellList().iterator();
            while (it.hasNext()) {
                HeaderCell cell = (HeaderCell)it.next();
                if (!bannedParents.contains(cell.getParentId())) continue;
                bannedParents.add(cell.getId());
                it.remove();
            }
            if (group.hasAspectNodes()) {
                List leafs = group.getLeafs();
                group.getHeaderCellList().stream().filter(headerCell -> leafs.stream().noneMatch(leaf -> leaf.getId().equals(headerCell.getId()))).forEach(headerCell -> bannedParents.add(headerCell.getId()));
            }
        });
    }

    private void removeCellsWithDuplicateAspectDataList(Header header) {
        for (int i = 0; i < header.getGroupList().size(); ++i) {
            ArrayList<List> used = new ArrayList<List>();
            Group group = (Group)header.getGroupList().get(i);
            Iterator cellIterator = group.getHeaderCellList().iterator();
            while (cellIterator.hasNext()) {
                HeaderCell headerCell = (HeaderCell)cellIterator.next();
                boolean exists = used.stream().anyMatch(usedAspectDataList -> CollectionUtils.isEqualCollection((Collection)usedAspectDataList, (Collection)headerCell.getAspectDataList()));
                if (exists) {
                    cellIterator.remove();
                    continue;
                }
                used.add(headerCell.getAspectDataList());
            }
        }
    }

    private void makeUpperGroupsAbstract(Header header) {
        if (header != null && header.getGroupList().size() > 1) {
            for (int i = 0; i < header.getGroupList().size() - 1; ++i) {
                Group group = (Group)header.getGroupList().get(i);
                group.getHeaderCellList().forEach(h -> h.setAbstractNode(true));
            }
        }
    }

    private ArrayList<Group> linearizeGroup(Header headerZ) {
        ArrayList<Group> groups = new ArrayList<Group>();
        List originalGroups = headerZ.getGroupList();
        for (Group originalGroup : originalGroups) {
            ArrayList<HeaderCell> leafHeaderCells = new ArrayList<HeaderCell>();
            List headerCellList = originalGroup.getHeaderCellList();
            for (HeaderCell cell : headerCellList) {
                List childList = (List)headerZ.getHeaderByParentMap().get(cell.getId());
                if (childList != null && !childList.isEmpty()) continue;
                HeaderCell leafHeaderCell = new HeaderCell();
                leafHeaderCell.setSortId(cell.getSortId());
                leafHeaderCell.setNodeType(cell.getNodeType());
                leafHeaderCell.setLabLabel(cell.getLabLabel());
                leafHeaderCell.setParentId(cell.getParentId());
                leafHeaderCell.setId(cell.getId());
                leafHeaderCell.setOrder(cell.getOrder());
                leafHeaderCell.setAspectDataList(cell.getAspectDataList());
                leafHeaderCell.setOrders(cell.getOrders());
                HeaderCell parent = (HeaderCell)headerZ.getHeaderMap().get(leafHeaderCell.getParentId());
                while (parent != null) {
                    leafHeaderCell.getAspectDataList().addAll(0, parent.getAspectDataList());
                    parent = (HeaderCell)headerZ.getHeaderMap().get(parent.getParentId());
                }
                leafHeaderCells.add(leafHeaderCell);
            }
            Group leafGroup = new Group();
            leafGroup.setHeaderCellList(leafHeaderCells);
            groups.add(leafGroup);
        }
        return groups;
    }

    private void sortGroups(Header header) {
        if (header == null) {
            return;
        }
        header.getGroupList().forEach(group -> {
            Comparator<HeaderCell> comparator = Comparator.comparing(HeaderCell::getOrders, (list1, list2) -> this.compareLists(list1, list2)).thenComparing(HeaderCell::getSortId);
            group.getHeaderCellList().sort(comparator);
        });
        header.rebuildHeaderMaps();
    }

    private int compareLists(List<Float> list1, List<Float> list2) {
        int maxSize = Math.max(list1.size(), list2.size());
        int result = 0;
        for (int i = 0; i < maxSize; ++i) {
            if (list1.size() < i + 1) {
                return -1;
            }
            if (list2.size() < i + 1) {
                return 1;
            }
            result = list1.get(i).compareTo(list2.get(i));
            if (result == 0) continue;
            return result;
        }
        return result;
    }

    private void deleteMerged(Header header) {
        if (header == null) {
            return;
        }
        AtomicBoolean changed = new AtomicBoolean(false);
        header.getGroupList().forEach(group -> {
            Iterator iterator = group.getHeaderCellList().iterator();
            while (iterator.hasNext()) {
                HeaderCell cell = (HeaderCell)iterator.next();
                if (!cell.isMerged()) continue;
                changed.set(true);
                List children = (List)header.getHeaderByParentMap().get(cell.getId());
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)children)) {
                    children.forEach(childCell -> {
                        childCell.setParentId(cell.getParentId());
                        childCell.getAspectDataList().addAll(0, cell.getAspectDataList());
                        childCell.getAspectDataList().stream().forEach(a -> a.setMerge(Boolean.valueOf(false)));
                        childCell.getOrders().addAll(0, cell.getOrders());
                    });
                }
                iterator.remove();
                header.rebuildHeaderMaps();
            }
        });
    }

    private Map<String, String> parseDimensionsDefault(XMLStreamReader reader) throws XMLStreamException {
        HashMap<String, String> map = new HashMap<String, String>();
        String dim = null;
        String mem = null;
        while (reader.hasNext()) {
            int eventType = reader.next();
            switch (eventType) {
                case 1: {
                    String currentStartElement = reader.getName().getLocalPart();
                    if (StringUtils.equalsIgnoreCase((CharSequence)ASPECT, (CharSequence)currentStartElement)) break;
                    if (StringUtils.equalsIgnoreCase((CharSequence)DIM, (CharSequence)currentStartElement)) {
                        dim = reader.getElementText();
                        break;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)MEM, (CharSequence)currentStartElement)) {
                        mem = reader.getElementText();
                        break;
                    }
                }
                case 2: {
                    String currentEndElement = reader.getName().getLocalPart();
                    if (StringUtils.equalsIgnoreCase((CharSequence)ASPECT, (CharSequence)currentEndElement)) {
                        map.put(dim, mem);
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)DIMENSIONS_DEFAULT, (CharSequence)currentEndElement)) break;
                    return map;
                }
            }
        }
        return null;
    }

    private String getPeriodAxis(TableLinkBase tableLinkBase) {
        if (tableLinkBase == null) {
            return "";
        }
        Header headerX = tableLinkBase.getHeaderX();
        if (headerX != null && StringUtils.equals((CharSequence)headerX.getAspect(), (CharSequence)PERIOD)) {
            return X;
        }
        Header headerY = tableLinkBase.getHeaderY();
        if (headerY != null && StringUtils.equals((CharSequence)headerY.getAspect(), (CharSequence)PERIOD)) {
            return Y;
        }
        Header headerZ = tableLinkBase.getHeaderZ();
        if (headerZ != null && StringUtils.equals((CharSequence)headerZ.getAspect(), (CharSequence)PERIOD)) {
            return Z;
        }
        return "";
    }

    private DataCells parseDataCells(XMLStreamReader reader, String periodAxis) throws XMLStreamException {
        DataCells dataCells = new DataCells();
        while (reader.hasNext()) {
            int eventType = reader.next();
            switch (eventType) {
                case 1: {
                    DataCell currentDataCell;
                    String currentStartElement = reader.getName().getLocalPart();
                    if (!StringUtils.equalsIgnoreCase((CharSequence)CELL, (CharSequence)currentStartElement) || (currentDataCell = this.parseDataCell(reader, periodAxis)) == null || currentDataCell.getFactValue() == null && currentDataCell.getConcept() == null) break;
                    DataCoordinates currentDataCoordinates = new DataCoordinates(currentDataCell.getPeriod(), currentDataCell.getZ(), currentDataCell.getY(), periodAxis);
                    Map rowFactMap = dataCells.getCoordinatesFactMap().computeIfAbsent(currentDataCoordinates, k -> new HashMap());
                    rowFactMap.put(currentDataCell.getX(), currentDataCell.getFactValue());
                    dataCells.getPeriodSet().add(currentDataCell.getPeriod());
                    break;
                }
            }
        }
        return dataCells;
    }

    private DataCell parseDataCell(XMLStreamReader reader, String periodAxis) throws XMLStreamException {
        Boolean isPeriodAxis = StringUtils.isNotBlank((CharSequence)periodAxis);
        DataCell dataCell = new DataCell();
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String currentStartElement = reader.getName().getLocalPart();
                    if (StringUtils.equalsIgnoreCase((CharSequence)FACT_VALUE, (CharSequence)currentStartElement)) {
                        dataCell.setFactValue(reader.getElementText());
                        break;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)DATE, (CharSequence)currentStartElement)) {
                        dataCell.setPeriod(reader.getElementText());
                        if (!isPeriodAxis.booleanValue()) break;
                        String period = dataCell.getPeriod();
                        switch (periodAxis) {
                            case "x": {
                                dataCell.setX(period);
                                break block0;
                            }
                            case "y": {
                                dataCell.setY(period);
                                break block0;
                            }
                            case "z": {
                                dataCell.setZ(period);
                            }
                        }
                        break;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)CONCEPT, (CharSequence)currentStartElement)) {
                        dataCell.setConcept(reader.getElementText());
                        break;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)X, (CharSequence)currentStartElement)) {
                        if (StringUtils.equals((CharSequence)X, (CharSequence)periodAxis) && StringUtils.equals((CharSequence)dataCell.getX(), (CharSequence)dataCell.getPeriod())) break;
                        dataCell.setX(reader.getElementText());
                        break;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)Y, (CharSequence)currentStartElement)) {
                        if (StringUtils.equals((CharSequence)Y, (CharSequence)periodAxis) && StringUtils.equals((CharSequence)dataCell.getY(), (CharSequence)dataCell.getPeriod())) break;
                        dataCell.setY(reader.getElementText());
                        break;
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)Z, (CharSequence)currentStartElement) || StringUtils.equals((CharSequence)Z, (CharSequence)periodAxis) && StringUtils.equals((CharSequence)dataCell.getZ(), (CharSequence)dataCell.getPeriod())) break;
                    dataCell.setZ(reader.getElementText());
                    break;
                }
                case 2: {
                    String currentEndElement = reader.getName().getLocalPart();
                    if (!StringUtils.equalsIgnoreCase((CharSequence)CELL, (CharSequence)currentEndElement)) break;
                    return dataCell;
                }
            }
        }
        return null;
    }

    private void setAxisHeaderToTLB(TableLinkBase tableLinkBase, Header currentHeader) {
        switch (currentHeader.getAxis()) {
            case "x": {
                tableLinkBase.setHeaderX(currentHeader);
                break;
            }
            case "y": {
                tableLinkBase.setHeaderY(currentHeader);
                break;
            }
            case "z": {
                tableLinkBase.setHeaderZ(currentHeader);
                break;
            }
            default: {
                log.debug("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430 Table linkbase. \u0414\u043b\u044f \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043e\u0441\u0438.");
            }
        }
    }

    private Header parseTLBHeader(XMLStreamReader reader, BiConsumer<String, List<EnumerateItem>> enumerationConsumer, Consumer<List<XbrlDimension>> xbrlRoleDimensionMemberConsumer) throws XmlParsingContentException, XMLStreamException, SkipTlbException {
        Header header = new Header();
        int n = reader.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            QName attributeName = reader.getAttributeName(i);
            if (StringUtils.equalsIgnoreCase((CharSequence)AXIS, (CharSequence)attributeName.toString())) {
                header.setAxis(reader.getAttributeValue(i));
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)ASPECT, (CharSequence)attributeName.toString())) continue;
            header.setAspect(reader.getAttributeValue(i));
        }
        if (StringUtils.isBlank((CharSequence)header.getAxis())) {
            log.debug("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430 Table linkbase. \u0414\u043b\u044f \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043e\u0441\u0438.");
            throw new XmlParsingContentException();
        }
        Integer level = 0;
        Group currentGroup = new Group();
        currentGroup.setAxis(header.getAxis());
        block5: while (reader.hasNext()) {
            int eventType = reader.next();
            switch (eventType) {
                case 1: {
                    Integer n2 = level;
                    Integer n3 = level = Integer.valueOf(level + 1);
                    Object currentStartElement = reader.getName().getLocalPart();
                    if (StringUtils.equalsIgnoreCase((CharSequence)CELL, (CharSequence)currentStartElement)) {
                        ArrayList<HeaderCell> headerCellChildList;
                        HeaderCell headerCell = this.parseTLBHeaderCell(reader, enumerationConsumer, xbrlRoleDimensionMemberConsumer, currentGroup);
                        if (headerCell == null) break;
                        header.getHeaderMap().put(headerCell.getId(), headerCell);
                        if (StringUtils.isNotBlank((CharSequence)headerCell.getRcCode())) {
                            header.setHasRcCode(true);
                        }
                        if (org.springframework.util.CollectionUtils.isEmpty((Collection)(headerCellChildList = (ArrayList<HeaderCell>)header.getHeaderByParentMap().get(headerCell.getParentId())))) {
                            headerCellChildList = new ArrayList<HeaderCell>();
                            header.getHeaderByParentMap().put(headerCell.getParentId(), headerCellChildList);
                        }
                        headerCellChildList.add(headerCell);
                        currentGroup.getHeaderCellList().add(headerCell);
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)GROUP, (CharSequence)currentStartElement)) break;
                    int n4 = reader.getAttributeCount();
                    for (int i = 0; i < n4; ++i) {
                        QName attributeName = reader.getAttributeName(i);
                        if (!StringUtils.equalsIgnoreCase((CharSequence)"definitionNodeId", (CharSequence)attributeName.toString())) continue;
                        currentGroup.setDefinitionNodeId(reader.getAttributeValue(i));
                    }
                    continue block5;
                }
                case 2: {
                    Object currentStartElement = level;
                    Integer n5 = level = Integer.valueOf(level - 1);
                    String currentEndElement = reader.getName().getLocalPart();
                    if (StringUtils.equalsIgnoreCase((CharSequence)GROUP, (CharSequence)currentEndElement)) {
                        header.getGroupList().add(currentGroup);
                        currentGroup = new Group();
                        break;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)HEADERS, (CharSequence)currentEndElement)) {
                        return header;
                    }
                    if (level >= 1) break;
                    log.debug("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430 Table linkbase. \u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 XML \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 headers. \u043e\u0441\u044c = {}", (Object)header.getAxis());
                    throw new XmlParsingContentException();
                }
            }
        }
        return null;
    }

    private HeaderCell parseTLBHeaderCell(XMLStreamReader reader, BiConsumer<String, List<EnumerateItem>> enumerationConsumer, Consumer<List<XbrlDimension>> roleDimensionMemberConsumer, Group currentGroup) throws XmlParsingContentException, XMLStreamException {
        HeaderCell headerCell = new HeaderCell();
        headerCell.setGroupDefinitionNodeId(currentGroup.getDefinitionNodeId());
        int n = reader.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            QName attributeName = reader.getAttributeName(i);
            if (StringUtils.equalsIgnoreCase((CharSequence)"uniqueNodeId", (CharSequence)attributeName.toString())) {
                headerCell.setUniqueNodeId(reader.getAttributeValue(i));
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"parentUniqueNodeId", (CharSequence)attributeName.toString())) {
                headerCell.setParentUniqueNodeId(reader.getAttributeValue(i));
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"definitionNodeId", (CharSequence)attributeName.toString())) {
                headerCell.setDefinitionNodeId(reader.getAttributeValue(i));
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"parentDefinitionNodeId", (CharSequence)attributeName.toString())) {
                headerCell.setParentDefinitionNodeId(reader.getAttributeValue(i));
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)ID, (CharSequence)attributeName.toString())) {
                headerCell.setSortId(reader.getAttributeValue(i));
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)AXIS, (CharSequence)attributeName.toString())) {
                headerCell.setAxis(reader.getAttributeValue(i));
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)AXIS, (CharSequence)attributeName.toString())) {
                headerCell.setAxis(reader.getAttributeValue(i));
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"nestId", (CharSequence)attributeName.toString())) {
                headerCell.setNestId(reader.getAttributeValue(i));
                headerCell.setId(reader.getAttributeValue(i));
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)"parentNestId", (CharSequence)attributeName.toString())) continue;
            headerCell.setParentNestId(reader.getAttributeValue(i));
            headerCell.setParentId(reader.getAttributeValue(i));
        }
        if (StringUtils.isBlank((CharSequence)headerCell.getId()) || StringUtils.isBlank((CharSequence)headerCell.getParentId())) {
            log.debug("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430 Table linkbase. \u0414\u043b\u044f \u044f\u0447\u0435\u0439\u043a\u0438 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 id \u0438\u043b\u0438 parentId.");
            return null;
        }
        Integer level = 0;
        AspectData aspectData = null;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String elementText;
                    Integer n2 = level;
                    Integer n3 = level = Integer.valueOf(level + 1);
                    Object currentStartElement = reader.getName().getLocalPart();
                    if (StringUtils.equalsIgnoreCase((CharSequence)LABEL, (CharSequence)currentStartElement)) {
                        reader.getElementText();
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"labLabel", (CharSequence)currentStartElement)) {
                        headerCell.setLabLabel(reader.getElementText());
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"rc-code", (CharSequence)currentStartElement)) {
                        headerCell.setRcCode(reader.getElementText());
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"node", (CharSequence)currentStartElement)) {
                        String node = reader.getElementText();
                        if ("aspectNode".equals(node)) {
                            headerCell.setNodeType(NodeType.ASPECT);
                        } else {
                            headerCell.setNodeType(NodeType.RULE);
                        }
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"abstractNode", (CharSequence)currentStartElement)) {
                        String isAbstract = reader.getElementText();
                        headerCell.setAbstractNode(BooleanUtils.toBoolean((String)isAbstract));
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"mergedNode", (CharSequence)currentStartElement)) {
                        String isMerged = reader.getElementText();
                        headerCell.setMergedNode(BooleanUtils.toBoolean((String)isMerged));
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"nodeTagSelector", (CharSequence)currentStartElement)) {
                        String nodeTagSelector = reader.getElementText();
                        headerCell.setNodeTagSelector(nodeTagSelector);
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"order", (CharSequence)currentStartElement)) {
                        String order = reader.getElementText();
                        float orderFloat = NumberUtils.toFloat((String)order, (float)1.0f);
                        headerCell.setOrder(Float.valueOf(orderFloat));
                        headerCell.getOrders().add(Float.valueOf(orderFloat));
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)CONSTRAINT, (CharSequence)currentStartElement)) {
                        aspectData = new AspectData();
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)ENUMERATE, (CharSequence)currentStartElement)) {
                        Object enumerateItems = this.processEnumerate(reader);
                        enumerationConsumer.accept(aspectData.getAspectValue(), (List<EnumerateItem>)enumerateItems);
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)ASPECT, (CharSequence)currentStartElement)) {
                        aspectData.setAspect(reader.getElementText());
                        switch (aspectData.getAspect()) {
                            case "concept": {
                                aspectData.setType(AspectType.forValue((String)CONCEPT));
                                break block0;
                            }
                            case "period": {
                                aspectData.setType(AspectType.forValue((String)PERIOD));
                                break block0;
                            }
                            case "period type": 
                            case "period instant": 
                            case "period start": 
                            case "period end": {
                                aspectData.setType(AspectType.PARAMS_PERIOD);
                                break block0;
                            }
                            case "multiply by": {
                                aspectData.setType(AspectType.MULTIPLY_BY);
                                break block0;
                            }
                        }
                        aspectData.setType(AspectType.forValue((String)DIMENSION));
                        break;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)CONCEPT_PERIOD_TYPE, (CharSequence)currentStartElement)) {
                        PeriodType conceptPeriodType = PeriodType.forValue((String)reader.getElementText());
                        aspectData.setConceptPeriodType(conceptPeriodType);
                        this.conceptService.saveConceptPeriodType(aspectData.getAspectValue(), conceptPeriodType);
                        break;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)VALUE, (CharSequence)currentStartElement)) {
                        aspectData.setAspectValue(reader.getElementText());
                    }
                    if (StringUtils.endsWithIgnoreCase((CharSequence)"dimensionType", (CharSequence)currentStartElement)) {
                        String value = reader.getElementText();
                        if (StringUtils.endsWithIgnoreCase((CharSequence)"explicit", (CharSequence)value)) {
                            aspectData.setDimensionType(DimensionType.EXPLICIT_MEMBER);
                        }
                        if (StringUtils.endsWithIgnoreCase((CharSequence)"typed", (CharSequence)value)) {
                            aspectData.setDimensionType(DimensionType.TYPED_MEMBER);
                        }
                    }
                    if (StringUtils.endsWithIgnoreCase((CharSequence)"domain", (CharSequence)currentStartElement)) {
                        elementText = reader.getElementText();
                        aspectData.setDomain(elementText);
                        this.conceptService.saveDomain(aspectData.getAspect(), elementText);
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"aspectLabel", (CharSequence)currentStartElement)) {
                        aspectData.setLabel(reader.getElementText());
                    }
                    if (StringUtils.endsWithIgnoreCase((CharSequence)ABSTRACT, (CharSequence)currentStartElement)) {
                        aspectData.setAbstractNode(StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)reader.getElementText()));
                    }
                    if (StringUtils.endsWithIgnoreCase((CharSequence)"xbrliType", (CharSequence)currentStartElement) && aspectData.getAspectValue() != null) {
                        this.conceptService.save(aspectData.getAspectValue(), reader.getElementText());
                        aspectData.setConceptDataType(this.conceptService.findTypeByConcept(aspectData.getAspectValue()));
                    }
                    if (StringUtils.endsWithIgnoreCase((CharSequence)"xsdType", (CharSequence)currentStartElement)) {
                        elementText = reader.getElementText();
                        aspectData.setXsdType(elementText);
                        this.conceptService.saveXsdType(aspectData.getAspectValue(), elementText);
                    }
                    if (StringUtils.endsWithIgnoreCase((CharSequence)"pattern", (CharSequence)currentStartElement)) {
                        elementText = reader.getElementText();
                        aspectData.setPattern(elementText);
                        this.conceptService.savePattern(aspectData.getAspectValue(), elementText);
                    }
                    if (StringUtils.endsWithIgnoreCase((CharSequence)DOCUMENTATION, (CharSequence)currentStartElement)) {
                        elementText = reader.getElementText();
                        this.conceptService.saveDocs(aspectData.getAspectValue(), elementText);
                    }
                    if (StringUtils.endsWithIgnoreCase((CharSequence)"tag", (CharSequence)currentStartElement)) {
                        aspectData.setTag(reader.getElementText());
                    }
                    if (StringUtils.endsWithIgnoreCase((CharSequence)"periodFormula", (CharSequence)currentStartElement)) {
                        aspectData.setPeriodFormula(reader.getElementText());
                    }
                    if (StringUtils.endsWithIgnoreCase((CharSequence)"tagSelector", (CharSequence)currentStartElement)) {
                        aspectData.setTagSelector(reader.getElementText());
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)MERGE, (CharSequence)currentStartElement)) {
                        aspectData.setMerge(Boolean.valueOf(Boolean.parseBoolean(reader.getElementText())));
                        break;
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)MEMBERS, (CharSequence)currentStartElement)) break;
                    XbrlDimension xbrlDimension = new XbrlDimension();
                    if (aspectData == null) break;
                    xbrlDimension.setDimInt(aspectData.getAspect());
                    xbrlDimension.setDimIntLabel(aspectData.getLabel());
                    xbrlDimension.setHeaderCellId(headerCell.getId());
                    roleDimensionMemberConsumer.accept(this.processMembers(reader, xbrlDimension));
                    break;
                }
                case 2: {
                    Object currentStartElement = level;
                    Integer n3 = level = Integer.valueOf(level - 1);
                    String currentEndElement = reader.getName().getLocalPart();
                    if (StringUtils.equalsIgnoreCase((CharSequence)CONSTRAINT, (CharSequence)currentEndElement)) {
                        if (aspectData.getType() != null && aspectData.getType().equals((Object)AspectType.MULTIPLY_BY)) {
                            headerCell.setUnitRole(aspectData.getAspectValue().replaceAll("[(),]", ""));
                        } else {
                            headerCell.getAspectDataList().add(aspectData);
                        }
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)CELL, (CharSequence)currentEndElement)) {
                        return headerCell;
                    }
                    if (level >= 1) break;
                    log.debug("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430 Table linkbase. \u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 XML \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 headerCell. Id = {}, parentId = {}", (Object)headerCell.getId(), (Object)headerCell.getParentId());
                    throw new XmlParsingContentException();
                }
            }
        }
        return null;
    }

    private List<EnumerateItem> processEnumerate(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<EnumerateItem> enumerateItems = new ArrayList<EnumerateItem>();
        EnumerateItem currentEnumerateItem = null;
        while (reader.hasNext()) {
            int eventType = reader.next();
            switch (eventType) {
                case 1: {
                    String currentStartElement = reader.getName().getLocalPart();
                    if (StringUtils.equalsIgnoreCase((CharSequence)ENUMERATE_ITEM, (CharSequence)currentStartElement)) {
                        currentEnumerateItem = new EnumerateItem();
                        break;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)LABEL, (CharSequence)currentStartElement)) {
                        currentEnumerateItem.setLabel(reader.getElementText());
                        break;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)MEMBER, (CharSequence)currentStartElement)) {
                        currentEnumerateItem.setMember(reader.getElementText());
                        break;
                    }
                }
                case 2: {
                    String currentEndElement = reader.getName().getLocalPart();
                    if (StringUtils.equalsIgnoreCase((CharSequence)ENUMERATE, (CharSequence)currentEndElement)) {
                        return enumerateItems;
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)ENUMERATE_ITEM, (CharSequence)currentEndElement)) break;
                    enumerateItems.add(currentEnumerateItem);
                    break;
                }
            }
        }
        return enumerateItems;
    }

    private List<XbrlDimension> processMembers(XMLStreamReader reader, XbrlDimension xbrlDimension) throws XMLStreamException {
        ArrayList<XbrlDimension> xbrlDimensionList = new ArrayList<XbrlDimension>();
        XbrlDimension currentXbrlDimension = new XbrlDimension(xbrlDimension);
        while (reader.hasNext()) {
            int eventType = reader.next();
            switch (eventType) {
                case 1: {
                    String currentStartElement = reader.getName().getLocalPart();
                    if (StringUtils.equalsIgnoreCase((CharSequence)MEMBER, (CharSequence)currentStartElement)) {
                        currentXbrlDimension = new XbrlDimension(xbrlDimension);
                        break;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)LABEL, (CharSequence)currentStartElement)) {
                        currentXbrlDimension.setMemIntLabel(reader.getElementText());
                        break;
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)MEM, (CharSequence)currentStartElement)) break;
                    currentXbrlDimension.setMemInt(reader.getElementText());
                    break;
                }
                case 2: {
                    String currentEndElement = reader.getName().getLocalPart();
                    if (StringUtils.equalsIgnoreCase((CharSequence)MEMBERS, (CharSequence)currentEndElement)) {
                        return xbrlDimensionList;
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)MEMBER, (CharSequence)currentEndElement)) break;
                    xbrlDimensionList.add(currentXbrlDimension);
                    break;
                }
            }
        }
        return xbrlDimensionList;
    }

    private void processFilterAxis(TableLinkBase tableLinkBase) {
        if (tableLinkBase == null) {
            return;
        }
        String linkrole = tableLinkBase.getLinkrole();
        Header headerX = tableLinkBase.getHeaderX();
        Map headerMap = headerX.getHeaderMap();
        if (org.springframework.util.CollectionUtils.isEmpty((Map)headerMap)) {
            return;
        }
        for (Map.Entry headerCellEntry : headerMap.entrySet()) {
            if (headerCellEntry == null) continue;
            HeaderCell headerCell = (HeaderCell)headerCellEntry.getValue();
            List aspectDataList = headerCell.getAspectDataList();
            Boolean isDimension = true;
            for (AspectData aspectData : aspectDataList) {
                if (aspectData == null || aspectData.getType().equals((Object)AspectType.DIMENSION)) continue;
                isDimension = false;
                break;
            }
            if (isDimension.booleanValue()) continue;
        }
    }
}

