/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.model.XbrlParameter;
import ru.cbr.xbrl.converter.repository.XbrlParameterRepository;
import ru.cbr.xbrl.converter.service.XbrlParameterService;

@Service
public class XbrlParameterServiceImpl
implements XbrlParameterService {
    private static final Logger log = LoggerFactory.getLogger(XbrlParameterServiceImpl.class);
    @Autowired
    private XbrlParameterRepository xbrlParameterRepository;

    public void update(XbrlParameter xbrlParameter) throws NotFoundException {
        XbrlParameter existing = (XbrlParameter)this.xbrlParameterRepository.findOne((Serializable)((Object)xbrlParameter.getQName()));
        if (existing != null) {
            throw new NotFoundException();
        }
        this.xbrlParameterRepository.save((Object)xbrlParameter);
    }

    public void createAll(List<XbrlParameter> xbrlParameters) {
        for (XbrlParameter xbrlParameter : xbrlParameters) {
            XbrlParameter existing = (XbrlParameter)this.xbrlParameterRepository.findOne((Serializable)((Object)xbrlParameter.getQName()));
            this.xbrlParameterRepository.save((Object)xbrlParameter);
        }
    }

    public void updateAll(List<XbrlParameter> xbrlParameters) {
        xbrlParameters.stream().forEach(xbrlParameter -> {
            try {
                this.update(xbrlParameter);
            }
            catch (NotFoundException e) {
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        });
    }

    public List<XbrlParameter> findAll() {
        return this.xbrlParameterRepository.findAll();
    }
}

