/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.cbr.xbrl.converter.exception.AccessDeniedDirectoryException;
import ru.cbr.xbrl.converter.exception.CancelledException;
import ru.cbr.xbrl.converter.exception.IncompatibleSchemaRefException;
import ru.cbr.xbrl.converter.exception.MoveFileException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.PackageAlreadyContainsXbrlReportException;
import ru.cbr.xbrl.converter.exception.RemoveFileException;
import ru.cbr.xbrl.converter.exception.SavePackageException;
import ru.cbr.xbrl.converter.exception.TaxonomyNotFoundException;
import ru.cbr.xbrl.converter.exception.UploadException;
import ru.cbr.xbrl.converter.exception.XbrlExportException;
import ru.cbr.xbrl.converter.exception.XbrlImportException;
import ru.cbr.xbrl.converter.exception.ZipExtractFileException;
import ru.cbr.xbrl.converter.model.XbrlPeriod;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.model.web.rest.RoleDTO;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValueId;

public interface XbrlPackageService {
    public List<XbrlPackage> list();

    public XbrlPackage find(Long var1) throws NotFoundException;

    public XbrlPackage findLastPackage();

    public XbrlPackage create(XbrlPackage var1) throws CancelledException, TaxonomyNotFoundException, NotFoundException, UploadException, RemoveFileException, MoveFileException, XbrlExportException;

    public XbrlPackage update(XbrlPackage var1) throws NotFoundException, MoveFileException, SavePackageException, UploadException, TaxonomyNotFoundException, CancelledException;

    public boolean updatePeriods(XbrlPackage var1, XbrlPackage var2);

    public void save(Long var1) throws NotFoundException, MoveFileException, SavePackageException, AccessDeniedDirectoryException;

    public XbrlPackage open(String var1) throws NotFoundException, RemoveFileException, UploadException, TaxonomyNotFoundException, CancelledException, MoveFileException, ZipExtractFileException, XbrlExportException, IOException, XbrlImportException, IncompatibleSchemaRefException;

    public void close(Long var1) throws NotFoundException, RemoveFileException;

    public XbrlReport addXbrlReportToPackage(XbrlPackage var1, String var2) throws NotFoundException, IOException, UploadException, TaxonomyNotFoundException, CancelledException;

    public void addFile(Long var1, String var2, String var3) throws NotFoundException, PackageAlreadyContainsXbrlReportException;

    public void deleteAll() throws NotFoundException, RemoveFileException;

    public void saveReportingPackage(Long var1, Date var2) throws NotFoundException, MoveFileException, SavePackageException, AccessDeniedDirectoryException;

    public List<XbrlPeriod> createPeriod(Long var1, Long var2, XbrlPeriod var3) throws NotFoundException;

    public RoleDTO deletePeriod(Long var1, Long var2, Long var3, boolean var4) throws NotFoundException;

    public List<XbrlPeriod> findPackagePeriodList(Long var1) throws NotFoundException;

    public List<XbrlPeriod> updatePeriod(Long var1, Long var2, XbrlPeriod var3) throws NotFoundException;

    public List<XbrlPeriod> togglePeriodList(Long var1, Boolean var2) throws NotFoundException;

    public void resetCancelPackageProcess();

    public void cancelProcessing();

    public Map<String, Date> preparePeriodParameterListForMovingContext(XbrlReport var1);

    public void preparePeriodParameterValueMap(Map<String, Date> var1, TableLinkBaseStructure var2);

    public void moveContextByValuePeriodParameter(Set<String> var1, XbrlReport var2, Map<String, String> var3, Map<String, Date> var4);

    public void moveContextForParameterByRole(Set<String> var1, XbrlReport var2, Map<String, String> var3, TableLinkBaseStructure var4, Map<String, Date> var5, Set<XbrlValueId> var6, Map<XbrlValueId, XbrlValueId> var7);

    public boolean isEmpty();

    public void processPeriodEnabled(XbrlReport var1);
}

