/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.model.tableLinkBase.NodeType;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.XYLevel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.YLevel;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;

class XYContext {
    private List<XYLevel> res = new ArrayList();
    private YLevel curItem = null;
    private int x = 0;
    private int y = 0;
    private int maxDepth = 0;
    private boolean hasRcCode = false;
    private Map<Integer, String> headerCaptions = new HashMap();

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public boolean hasRcCode() {
        return this.hasRcCode;
    }

    public List<XYLevel> getRes() {
        return this.res;
    }

    public YLevel getCurItem() {
        return this.curItem;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Map<Integer, String> getHeaderCaptions() {
        return this.headerCaptions;
    }

    public int moveX(int shift) {
        this.x += shift;
        return this.x;
    }

    public int moveY(int shift) {
        this.y += shift;
        return this.y;
    }

    public List<XYLevel> processLevel(YLevel level) {
        return this.processLevel(level, 0);
    }

    public List<XYLevel> processLevel(YLevel level, int depth) {
        this.x = depth;
        boolean bl = this.hasRcCode = this.hasRcCode || StringUtils.isNotBlank((CharSequence)level.getRcCode());
        if (depth + 1 > this.maxDepth) {
            this.maxDepth = depth + 1;
        }
        this.curItem = level;
        XYLevel xy = null;
        if (this.res.size() < this.y + 1) {
            while (this.res.size() < this.y + 1) {
                xy = new XYLevel();
                this.res.add(xy);
            }
            xy = (XYLevel)this.res.get(this.y);
        } else {
            xy = (XYLevel)this.res.get(this.y);
        }
        xy.setLevel(this.x, level);
        if (level.getNodeType() == NodeType.ASPECT) {
            Optional<AspectData> dim = level.getAspectDataList().stream().filter(it -> it.isDimension()).findFirst();
            if (dim.isPresent()) {
                level.setXTitle(dim.get().getAxisValueLabel());
            } else {
                level.setXTitle(level.getTitle());
            }
            if (!this.headerCaptions.keySet().contains(this.x)) {
                if (dim.isPresent()) {
                    this.headerCaptions.put(this.x, dim.get().getAxisLabel());
                } else {
                    this.headerCaptions.put(this.x, level.getTitle());
                }
            }
        } else {
            level.setXTitle(level.getTitle());
            if (!this.headerCaptions.keySet().contains(this.x)) {
                this.headerCaptions.put(this.x, "");
            }
        }
        if (!level.isAbstractNode() && level.getNodeType() != NodeType.ASPECT && level.isParentFirst() && !CollectionUtils.isEmpty((Collection)level.getYLevelList())) {
            this.moveY(1);
        }
        this.processNestLevels(level, depth + 1);
        if (!(level.isAbstractNode() || level.getNodeType() == NodeType.ASPECT || level.isParentFirst() || CollectionUtils.isEmpty((Collection)level.getYLevelList()))) {
            this.moveY(1);
        }
        return this.res;
    }

    private void processNestLevels(YLevel level, int depth) {
        if (!CollectionUtils.isEmpty((Collection)this.curItem.getYLevelList())) {
            this.x = depth;
            ArrayList list = new ArrayList(this.curItem.getYLevelList());
            int ySize = list.size();
            for (int yl = 0; yl < ySize; ++yl) {
                YLevel nextLevel = (YLevel)list.get(yl);
                this.processLevel(nextLevel, depth);
            }
        } else {
            this.moveY(1);
        }
    }
}

