/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.XbrlParameterCalculationError;
import ru.cbr.xbrl.converter.exception.XbrlParameterCalculationErrorRequiredValueIsNotProvided;
import ru.cbr.xbrl.converter.model.XbrlTaxonomyParameter;
import ru.cbr.xbrl.converter.model.XbrlTaxonomyParamsRend;
import ru.cbr.xbrl.converter.model_main.Taxonomy;
import ru.cbr.xbrl.converter.service.TaxonomyService;
import ru.cbr.xbrl.converter.service.tablelinkbase.XBRLTaxonomyParameterService;
import ru.cbr.xbrl.converter.utils.ZipUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class XBRLTaxonomyParameterServiceImpl
implements XBRLTaxonomyParameterService {
    private static final Logger log = LoggerFactory.getLogger(XBRLTaxonomyParameterServiceImpl.class);
    private final TaxonomyService taxonomyService;
    private String currTaxonomyVersion;
    private Map<XbrlTaxonomyParameter, XdmValue> paramValues = new HashMap();
    private static Map<String, String> pfx2nmsp = new HashMap();
    private static Map<String, String> localNameCache;
    private static Processor processor;

    private static XdmItem getContext(Processor processor) throws SaxonApiException {
        StreamSource xmlDocument = new StreamSource(new StringReader("<xbrl/>"));
        XdmNode node = processor.newDocumentBuilder().build((Source)xmlDocument);
        Iterable children = node.children();
        Iterator iterator = children.iterator();
        return (XdmItem)iterator.next();
    }

    public XBRLTaxonomyParameterServiceImpl(@Autowired TaxonomyService taxonomyService) {
        this.taxonomyService = taxonomyService;
    }

    public List<XbrlTaxonomyParameter> readParamsFromTaxonomy(String taxonomyVersion) throws NotFoundException {
        if (this.currTaxonomyVersion == null || !this.currTaxonomyVersion.equals(taxonomyVersion)) {
            this.paramValues.clear();
            Taxonomy t = this.taxonomyService.findByVersion(taxonomyVersion);
            String taxonomyPath = t.getFilePath();
            for (XbrlTaxonomyParameter p : this.readParamsFromFile(taxonomyPath)) {
                this.paramValues.put(p, null);
            }
            this.currTaxonomyVersion = taxonomyVersion;
        }
        return new ArrayList<XbrlTaxonomyParameter>(this.paramValues.keySet());
    }

    public List<XbrlTaxonomyParameter> calcParams(String taxonomyVersion, List<XbrlTaxonomyParameter> vals) throws NotFoundException, XbrlParameterCalculationError {
        List ps = this.readParamsFromTaxonomy(taxonomyVersion);
        for (XbrlTaxonomyParameter p : ps) {
            try {
                Optional<XbrlTaxonomyParameter> val = vals.stream().filter(it -> it.getName().equals(p.getName())).findFirst();
                if (val.isPresent()) {
                    try {
                        XdmValue xdmValue = val.get().getXdmValue();
                        this.paramValues.put(p, xdmValue);
                        p.setValue(val.get().getValue());
                        continue;
                    }
                    catch (SaxonApiException e) {
                        log.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 " + p.getName(), (Throwable)e);
                        throw new XbrlParameterCalculationError();
                    }
                }
                this.paramValues.put(p, null);
                p.setValue(null);
            }
            catch (Exception e) {
                this.paramValues.put(p, null);
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        for (XbrlTaxonomyParameter p : ps) {
            if (p.getValue() != null) continue;
            XdmValue xdmValue = this.calcParam(p);
        }
        return new ArrayList<XbrlTaxonomyParameter>(this.paramValues.keySet());
    }

    public static List<String> getVaribles(String expression) {
        ArrayList<String> allMatches = new ArrayList<String>();
        Pattern pattern = Pattern.compile("(?<=\\$)((\\w+\\:{1})*\\w+(\\-*\\w*)*)");
        Matcher m = pattern.matcher(expression);
        while (m.find()) {
            allMatches.add(m.group());
        }
        return allMatches.stream().distinct().collect(Collectors.toList());
    }

    public static String getLocalName(String valueQN) {
        String cachedValue = (String)localNameCache.get(valueQN);
        if (cachedValue == null) {
            String[] dimAttrQN = valueQN.split(":");
            cachedValue = dimAttrQN.length > 1 ? dimAttrQN[1].trim() : dimAttrQN[0].trim();
            localNameCache.put(valueQN, cachedValue);
        }
        return cachedValue;
    }

    public static String getPrefix(String qname) {
        String[] values = qname.split(":");
        if (values.length > 1) {
            return values[0];
        }
        return "";
    }

    private static XPathSelector getSelector(String expression, XPathCompiler compiler) throws XbrlParameterCalculationError {
        XPathSelector selector;
        try {
            selector = compiler.compile(XBRLTaxonomyParameterServiceImpl.insertXsdate((String)expression)).load();
        }
        catch (SaxonApiException ex) {
            try {
                if (!ex.getMessage().startsWith("Invalid date") || !ex.getMessage().endsWith("must be two digits)")) {
                    log.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 \u043f\u0440\u0438 \u0432\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430", (Throwable)ex);
                    throw new XbrlParameterCalculationError();
                }
                int f = ex.getMessage().indexOf(34);
                int s = ex.getMessage().indexOf(34, f + 1);
                String dt = ex.getMessage().substring(f + 1, s);
                String[] dtParts = dt.split("-");
                selector = compiler.compile(String.format("xs:date(\"%s-%s-%s\")", dtParts[0], StringUtils.leftPad((String)StringUtils.stripStart((String)dtParts[1], (String)"0"), (int)2, (char)'0'), StringUtils.leftPad((String)StringUtils.stripStart((String)dtParts[2], (String)"0"), (int)2, (char)'0'))).load();
            }
            catch (SaxonApiException sae) {
                log.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 \u043f\u0440\u0438 \u0432\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430", (Throwable)sae);
                throw new XbrlParameterCalculationError();
            }
        }
        return selector;
    }

    private XdmValue calcParam(XbrlTaxonomyParameter param) throws XbrlParameterCalculationError {
        XPathCompiler compiler = processor.newXPathCompiler();
        for (Object prefix : pfx2nmsp.keySet()) {
            if (prefix == null || "".equals(prefix)) continue;
            compiler.declareNamespace((String)prefix, (String)pfx2nmsp.get(prefix));
        }
        List vars = XBRLTaxonomyParameterServiceImpl.getVaribles((String)param.getSelect());
        if (!vars.isEmpty()) {
            for (Object v : vars) {
                String pfx = XBRLTaxonomyParameterServiceImpl.getPrefix((String)v);
                if (StringUtils.isBlank((CharSequence)pfx)) {
                    compiler.declareVariable(new QName((String)v));
                    continue;
                }
                QName vQname = new QName(pfx, (String)pfx2nmsp.get(pfx), XBRLTaxonomyParameterServiceImpl.getLocalName((String)v));
                compiler.declareVariable(vQname);
            }
        }
        XPathSelector selector = XBRLTaxonomyParameterServiceImpl.getSelector((String)param.getSelect(), (XPathCompiler)compiler);
        if (!vars.isEmpty()) {
            for (String v : vars) {
                Optional<XbrlTaxonomyParameter> pv = this.paramValues.keySet().stream().filter(it -> it.getName().getLocalPart().equals(XBRLTaxonomyParameterServiceImpl.getLocalName((String)v))).findFirst();
                if (pv.isPresent()) {
                    try {
                        String pfx;
                        XdmValue xdmValue;
                        if (pv.get().getValue() == null) {
                            xdmValue = this.calcParam(pv.get());
                            if (pv.get().isRequired() && xdmValue == null) {
                                log.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 \u043f\u0440\u0438 \u0432\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 " + param.getName().toString() + ": \u043d\u0435 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 :" + v);
                                throw new XbrlParameterCalculationErrorRequiredValueIsNotProvided();
                            }
                        } else {
                            xdmValue = pv.get().getXdmValue();
                        }
                        if (StringUtils.isBlank((CharSequence)(pfx = XBRLTaxonomyParameterServiceImpl.getPrefix((String)v)))) {
                            selector.setVariable(new QName(v), xdmValue);
                            continue;
                        }
                        QName vQname = new QName(pfx, (String)pfx2nmsp.get(pfx), XBRLTaxonomyParameterServiceImpl.getLocalName((String)v));
                        selector.setVariable(vQname, xdmValue);
                        continue;
                    }
                    catch (SaxonApiException sae) {
                        log.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 \u043f\u0440\u0438 \u0432\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430", (Throwable)sae);
                        throw new XbrlParameterCalculationError();
                    }
                }
                log.error("\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f " + v + " \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440, \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0432 \u0442\u0430\u0441\u043a\u0441\u043e\u043d\u043e\u043c\u0438\u0438");
                throw new XbrlParameterCalculationError();
            }
        }
        XdmItem result = null;
        try {
            selector.setContextItem(XBRLTaxonomyParameterServiceImpl.getContext((Processor)processor));
            result = selector.evaluateSingle();
            param.setValue(result.toString());
        }
        catch (SaxonApiException e) {
            try {
                if (!e.getMessage().startsWith("Invalid date") || !e.getMessage().endsWith("must be two digits)")) {
                    log.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 \u043f\u0440\u0438 \u0432\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430", (Throwable)e);
                    throw new XbrlParameterCalculationError();
                }
                int f = e.getMessage().indexOf(34);
                int s = e.getMessage().indexOf(34, f + 1);
                String dt = e.getMessage().substring(f + 1, s);
                String[] dtParts = dt.split("-");
                XPathSelector _selector = compiler.compile(String.format("xs:date(\"%s-%s-%s\")", dtParts[0], StringUtils.leftPad((String)StringUtils.stripStart((String)dtParts[1], (String)"0"), (int)2, (char)'0'), StringUtils.leftPad((String)StringUtils.stripStart((String)dtParts[2], (String)"0"), (int)2, (char)'0'))).load();
                _selector.setContextItem(XBRLTaxonomyParameterServiceImpl.getContext((Processor)processor));
                result = _selector.evaluateSingle();
                param.setValue(result.toString());
            }
            catch (SaxonApiException sae) {
                log.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 \u043f\u0440\u0438 \u0432\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430", (Throwable)sae);
                throw new XbrlParameterCalculationError();
            }
        }
        return result;
    }

    private List<XbrlTaxonomyParameter> readParamsFromFile(String taxonomyPath) {
        try {
            List<XbrlTaxonomyParameter> res;
            ZipFile zipFile = null;
            String entryFileName = ZipUtils.findEntry((String)taxonomyPath, (String)"params-rend.xml");
            zipFile = new ZipFile(taxonomyPath);
            ZipEntry zipEntry = zipFile.getEntry(entryFileName);
            try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{XbrlTaxonomyParamsRend.class});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                XbrlTaxonomyParamsRend params = (XbrlTaxonomyParamsRend)jaxbUnmarshaller.unmarshal(inputStream);
                params.AnyAttr.forEach((q, n) -> pfx2nmsp.put(q.getLocalPart(), n));
                res = Arrays.stream(params.link.parameter).map(it -> new XbrlTaxonomyParameter(it.name, it.select, it.required, it.as)).collect(Collectors.toList());
            }
            zipFile.close();
            return res;
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return new ArrayList<XbrlTaxonomyParameter>();
        }
    }

    public static String insertXsdate(String expression) {
        String op;
        String[] maxMinOperators = new String[]{"max", "min"};
        String[] dateTags = new String[]{"xbrli:instant", "xbrli:startDate", "xbrli:endDate"};
        boolean containsOperator = false;
        String[] stringArray = maxMinOperators;
        int n = stringArray.length;
        for (int i = 0; i < n && !(containsOperator = expression.contains(op = stringArray[i])); ++i) {
        }
        if (containsOperator) {
            int startIndex = 0;
            while (startIndex < expression.length()) {
                String lastSymbolsBeforeBracket;
                int indexOfAnyOperator = expression.indexOf(maxMinOperators[0], startIndex);
                String foundOperator = maxMinOperators[0];
                for (int i = 1; i < maxMinOperators.length; ++i) {
                    int foundIndex = expression.indexOf(maxMinOperators[i], startIndex);
                    if (foundIndex == -1 || foundIndex >= indexOfAnyOperator) continue;
                    indexOfAnyOperator = foundIndex;
                    foundOperator = maxMinOperators[i];
                }
                if (indexOfAnyOperator == -1) {
                    startIndex = expression.length();
                    continue;
                }
                int operatorClosedBracketIndex = startIndex = indexOfAnyOperator + foundOperator.length();
                int numOfOpenedBrackets = 0;
                for (int i = startIndex; i < expression.length(); ++i) {
                    if (expression.charAt(i) == '(') {
                        ++numOfOpenedBrackets;
                    } else if (expression.charAt(i) == ')') {
                        --numOfOpenedBrackets;
                    }
                    if (numOfOpenedBrackets != 0) continue;
                    operatorClosedBracketIndex = i;
                    break;
                }
                int indexOfLastNonEmptyChar = operatorClosedBracketIndex;
                for (int i = operatorClosedBracketIndex; i > startIndex && expression.charAt(i) == ' '; --i) {
                    --indexOfLastNonEmptyChar;
                }
                String xsdateStr = "/xs:date(.)";
                if (indexOfLastNonEmptyChar > 11 && (lastSymbolsBeforeBracket = expression.substring(indexOfLastNonEmptyChar - xsdateStr.length(), indexOfLastNonEmptyChar)).equals(xsdateStr)) {
                    startIndex = operatorClosedBracketIndex;
                    continue;
                }
                String expressionInsideOperator = expression.substring(startIndex + 1, operatorClosedBracketIndex);
                boolean expressionContainsAnyTag = false;
                for (String tag : dateTags) {
                    if (!expressionInsideOperator.contains(tag)) continue;
                    expressionContainsAnyTag = true;
                    break;
                }
                if (!expressionContainsAnyTag) continue;
                expression = expression.substring(0, operatorClosedBracketIndex) + xsdateStr + expression.substring(operatorClosedBracketIndex);
                startIndex = operatorClosedBracketIndex + xsdateStr.length();
            }
        }
        return expression;
    }

    static {
        pfx2nmsp.put("par", "http://parameters");
        pfx2nmsp.put("link", "http://www.xbrl.org/2003/linkbase");
        pfx2nmsp.put("gen", "http://xbrl.org/2008/generic");
        pfx2nmsp.put("variable", "http://xbrl.org/2008/variable");
        pfx2nmsp.put("table", "http://xbrl.org/2014/table");
        pfx2nmsp.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        pfx2nmsp.put("xbrli", "http://www.xbrl.org/2003/instance");
        pfx2nmsp.put("fn", "http://www.w3.org/2005/xpath-functions");
        pfx2nmsp.put("xsd", "http://www.w3.org/2001/XMLSchema");
        pfx2nmsp.put("xs", "http://www.w3.org/2001/XMLSchema");
        pfx2nmsp.put("xlink", "http://www.w3.org/1999/xlink");
        localNameCache = new HashMap();
        processor = new Processor(new Configuration());
    }
}

