/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model_main.Parameter;
import ru.cbr.xbrl.converter.model_main.ParameterName;
import ru.cbr.xbrl.converter.model_main.ParameterType;
import ru.cbr.xbrl.converter.service.UpdateService;
import ru.cbr.xbrl.converter.service.XbrlPackageService;
import ru.cbr.xbrl.converter.service.system.ParameterService;

@Service
public class UpdateServiceImpl
implements UpdateService {
    private static final Logger log = LoggerFactory.getLogger(UpdateServiceImpl.class);
    private final ParameterService parameterService;
    private final XbrlPackageService xbrlPackageService;

    public void saveCurrentVersion() {
        this.parameterService.saveParameter(ParameterName.SOFTWARE_VERSION, this.getCurrentVersion(), ParameterType.STRING);
    }

    public void saveCurrentPackagePath(XbrlPackage xbrlPackage) {
        if (xbrlPackage != null) {
            this.parameterService.saveParameter(ParameterName.PACKAGE_PATH, FilenameUtils.concat((String)xbrlPackage.getPathForPackage(), (String)(xbrlPackage.getName() + ".ank")), ParameterType.STRING);
        }
    }

    public void deletePackagePath() {
        this.parameterService.deleteParameter(ParameterName.PACKAGE_PATH);
    }

    public XbrlPackage recoveryPackage() {
        XbrlPackage xbrlPackage = null;
        String path = Optional.ofNullable(this.parameterService.getParameter(ParameterName.PACKAGE_PATH)).map(Parameter::getValue).orElse(null);
        if (path != null) {
            try {
                xbrlPackage = this.xbrlPackageService.open(path);
            }
            catch (Exception e) {
                log.error("error when opening package", (Throwable)e);
            }
        }
        return xbrlPackage;
    }

    public String getCurrentVersion() {
        String ver = "";
        Path path = Paths.get(System.getProperty("user.dir"), "resources", "app", "ver");
        if (Files.exists(path, new LinkOption[0])) {
            try (Stream<String> stream = Files.lines(path);){
                ver = stream.findFirst().orElse(null);
            }
            catch (IOException e) {
                log.error("error reading version file", (Throwable)e);
            }
        } else {
            path = Paths.get(System.getProperty("user.dir"), "electronapp", "electron", "ver");
            if (Files.exists(path, new LinkOption[0])) {
                try (Stream<String> stream = Files.lines(path);){
                    ver = stream.findFirst().orElse(null);
                }
                catch (IOException e) {
                    log.error("error reading version file", (Throwable)e);
                }
            }
        }
        return ver;
    }

    @ConstructorProperties(value={"parameterService", "xbrlPackageService"})
    public UpdateServiceImpl(ParameterService parameterService, XbrlPackageService xbrlPackageService) {
        this.parameterService = parameterService;
        this.xbrlPackageService = xbrlPackageService;
    }
}

