/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.UnitsConfigException;
import ru.cbr.xbrl.converter.exception.UnitsConfigRoleChangesException;
import ru.cbr.xbrl.converter.model.UnitsConfiguration;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.Fact;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.TLBUiModel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.YLevel;
import ru.cbr.xbrl.converter.model.web.rest.ColumnHeader;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValue;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValueId;
import ru.cbr.xbrl.converter.repository.UnitsConfigurationRepository;
import ru.cbr.xbrl.converter.service.TableLinkBaseDataService;
import ru.cbr.xbrl.converter.service.UnitService;
import ru.cbr.xbrl.converter.service.UnitsConfigurationService;
import ru.cbr.xbrl.converter.service.UnitsConfigurationServiceImpl;
import ru.cbr.xbrl.converter.service.XbrlPackageService;
import ru.cbr.xbrl.converter.service.XbrlReportService;
import ru.cbr.xbrl.converter.service.import_export.EditXbrlService;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlValueCrudService;
import ru.cbr.xbrl.converter.utils.LruCache;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.TableLinkViewUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.TopHeaderModel;

@Service
public class UnitsConfigurationServiceImpl
implements UnitsConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(UnitsConfigurationServiceImpl.class);
    @Autowired
    private UnitsConfigurationRepository unitsConfigurationRepository;
    @Autowired
    private UnitService unitService;
    @Autowired
    private TableLinkBaseDataService tableLinkBaseDataService;
    @Autowired
    private EditXbrlService editXbrlService;
    @Autowired
    private XbrlValueCrudService xbrlValueCrudService;
    @Autowired
    private XbrlReportService xbrlReportService;
    @Autowired
    private XbrlPackageService xbrlPackageService;

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public UnitsConfiguration findByRoleOrReport(XbrlReport xbrlReport, XbrlReportRole xbrlReportRole) {
        UnitsConfiguration unitsConfiguration = null;
        if (xbrlReportRole != null) {
            unitsConfiguration = this.findByXbrlReportRole(xbrlReportRole);
        }
        if (unitsConfiguration == null) {
            unitsConfiguration = this.findByXbrlReport(xbrlReport);
        }
        return unitsConfiguration;
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public UnitsConfiguration findByXbrlReport(XbrlReport xbrlReport) {
        UnitsConfiguration unitsConfiguration = this.unitsConfigurationRepository.findByXbrlReport(xbrlReport);
        if (unitsConfiguration != null) {
            return unitsConfiguration;
        }
        unitsConfiguration = new UnitsConfiguration();
        unitsConfiguration.setCurrency("RUB");
        unitsConfiguration.setCurrencyDecimals(Integer.valueOf(-3));
        unitsConfiguration.setCurrencyPrecision(null);
        unitsConfiguration.setSharesDecimals(Integer.valueOf(-3));
        unitsConfiguration.setSharesPrecision(null);
        unitsConfiguration.setIntegerDecimals(Integer.valueOf(-3));
        unitsConfiguration.setIntegerPrecision(null);
        unitsConfiguration.setDecimalDecimals(Integer.valueOf(-3));
        unitsConfiguration.setDecimalPrecision(null);
        return unitsConfiguration;
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public UnitsConfiguration findByXbrlReportRole(XbrlReportRole xbrlReportRole) {
        for (UnitsConfiguration unitsConfiguration : this.unitsConfigurationRepository.findAll()) {
            if (!xbrlReportRole.getSystemId().equals(unitsConfiguration.getXbrlReportRoleSystemId())) continue;
            return unitsConfiguration;
        }
        return null;
    }

    @Transactional(value="cacheTransactionManager")
    public void updateUnitsConfigurationForReport(XbrlReport xbrlReport, UnitsConfiguration unitsConfiguration, Boolean updateFacts) throws UnitsConfigRoleChangesException {
        try {
            this.save(xbrlReport, null, unitsConfiguration, updateFacts);
        }
        catch (UnitsConfigRoleChangesException ex) {
            throw ex;
        }
        catch (Exception e) {
            log.error("FAILED TO UPDATE UNITS CONFIGURATION FOR REPORT", (Throwable)e);
        }
    }

    @Transactional(value="cacheTransactionManager")
    public void updateUnitsConfigurationForReportRole(XbrlReportRole xbrlReportRole, UnitsConfiguration unitsConfiguration, Boolean updateFacts) throws UnitsConfigRoleChangesException {
        try {
            this.save(null, xbrlReportRole, unitsConfiguration, updateFacts);
        }
        catch (UnitsConfigRoleChangesException ex) {
            throw ex;
        }
        catch (Exception e) {
            log.error("FAILED TO UPDATE UNITS CONFIGURATION FOR ROLE", (Throwable)e);
        }
    }

    public void clearRoleConnection() {
    }

    public void restoreRoleConnection() {
    }

    private void save(XbrlReport report, XbrlReportRole role, UnitsConfiguration unitsConfiguration, Boolean updateFacts) throws UnitsConfigRoleChangesException {
        UnitsConfiguration currentConfig;
        boolean roleSpecified;
        boolean reportSpecified = report != null && report.getId() != null;
        boolean bl = roleSpecified = role != null && role.getId() != null;
        if (!reportSpecified && !roleSpecified) {
            throw new IllegalArgumentException("report or role must be specified");
        }
        if (roleSpecified) {
            unitsConfiguration.setXbrlReportRoleSystemId(role.getSystemId());
        }
        UnitsConfiguration unitsConfiguration2 = currentConfig = reportSpecified ? this.findByXbrlReport(report) : this.findByXbrlReportRole(role);
        if (currentConfig == null || currentConfig.getId() == null) {
            currentConfig = new UnitsConfiguration();
            if (reportSpecified) {
                currentConfig.setXbrlReport(report);
            } else {
                currentConfig.setXbrlReportRoleSystemId(role.getSystemId());
            }
        }
        this.copyLocalDataFields(unitsConfiguration, currentConfig);
        if (role == null) {
            this.checkAndUpdateReportUnits(report, unitsConfiguration, updateFacts, currentConfig);
        } else {
            this.checkAndUpdateRoleUnits(report, role, updateFacts, currentConfig);
        }
        this.unitService.clearUnusedXbrlUnits();
    }

    private void checkAndUpdateRoleUnits(XbrlReport report, XbrlReportRole role, Boolean updateFacts, UnitsConfiguration currentConfig) throws UnitsConfigRoleChangesException {
        ArrayList xbrlValues = new ArrayList();
        this.updateAllFactsByRole(report, role, currentConfig, updateFacts, xbrlValues);
        if (CollectionUtils.isNotEmpty(xbrlValues)) {
            throw new UnitsConfigRoleChangesException(role.getTitle());
        }
        this.unitsConfigurationRepository.save((Object)currentConfig);
    }

    private void checkAndUpdateReportUnits(XbrlReport report, UnitsConfiguration unitsConfiguration, Boolean updateFacts, UnitsConfiguration currentConfig) throws UnitsConfigRoleChangesException {
        String roleDifferent = this.checkFactsAndRoles(report, unitsConfiguration, updateFacts, currentConfig);
        if (StringUtils.isNotBlank((CharSequence)roleDifferent) && !updateFacts.booleanValue()) {
            throw new UnitsConfigRoleChangesException(roleDifferent);
        }
        this.unitsConfigurationRepository.save((Object)currentConfig);
        this.unitService.updateAllFacts(report.getId(), currentConfig);
    }

    private String checkFactsAndRoles(XbrlReport report, UnitsConfiguration unitsConfiguration, Boolean updateFacts, UnitsConfiguration currentConfig) {
        StringBuilder roleDifferent = new StringBuilder();
        System.out.println("checkFactsAndRoles:start");
        List roles = report.getXbrlReportRoles();
        for (XbrlReportRole r : roles) {
            System.out.println("checkFactsAndRoles:" + r.getTitle());
            ArrayList xbrlValues = new ArrayList();
            this.updateAllFactsByRole(report, r, currentConfig, updateFacts, xbrlValues);
            if (CollectionUtils.isNotEmpty(xbrlValues)) {
                roleDifferent.append(r.getTitle()).append("<br/>");
                continue;
            }
            this.checkRoles(unitsConfiguration, updateFacts, roleDifferent, r);
        }
        System.out.println("checkFactsAndRoles:end");
        return roleDifferent.toString();
    }

    private void checkRoles(UnitsConfiguration unitsConfiguration, Boolean updateFacts, StringBuilder roleDifferent, XbrlReportRole r) {
        UnitsConfiguration roleConfig = null;
        for (UnitsConfiguration unitsConfiguration1 : this.unitsConfigurationRepository.findAll()) {
            if (!r.getSystemId().equals(unitsConfiguration1.getXbrlReportRoleSystemId())) continue;
            roleConfig = unitsConfiguration1;
        }
        if (roleConfig != null) {
            if (!roleConfig.getCurrency().equals(unitsConfiguration.getCurrency()) || roleConfig.getCurrencyPrecision() != unitsConfiguration.getCurrencyPrecision() || roleConfig.getCurrencyDecimals() != unitsConfiguration.getCurrencyDecimals() || roleConfig.getDecimalPrecision() != unitsConfiguration.getCurrencyPrecision() || roleConfig.getIntegerDecimals() != unitsConfiguration.getIntegerDecimals() || roleConfig.getIntegerPrecision() != unitsConfiguration.getIntegerPrecision() || roleConfig.getSharesDecimals() != unitsConfiguration.getSharesDecimals() || roleConfig.getSharesPrecision() != unitsConfiguration.getSharesPrecision()) {
                roleDifferent.append(r.getTitle()).append("; ");
                if (updateFacts.booleanValue()) {
                    this.copyAndSafeConfigRole(unitsConfiguration, roleConfig);
                }
            }
        } else if (updateFacts.booleanValue()) {
            roleConfig = new UnitsConfiguration();
            roleConfig.setXbrlReportRoleSystemId(r.getSystemId());
            this.copyAndSafeConfigRole(unitsConfiguration, roleConfig);
        }
    }

    private void copyAndSafeConfigRole(UnitsConfiguration unitsConfiguration, UnitsConfiguration roleConfig) {
        this.copyLocalDataFields(unitsConfiguration, roleConfig);
        this.unitsConfigurationRepository.save((Object)roleConfig);
    }

    private void updateAllFactsByRole(XbrlReport report, XbrlReportRole role, UnitsConfiguration currentConfig, Boolean updateFacts, List<XbrlValue> xbrlValues) {
        try {
            XbrlReportRole xbrlReportRole = this.xbrlReportService.findReportRole(role.getId());
            XbrlReport xbrlReport = xbrlReportRole.getXbrlReport();
            this.iterateTablelinkbaseValues(xbrlReport, xbrlReportRole, xbrlValue -> {
                if (!updateFacts.booleanValue()) {
                    if (!this.checkFact(xbrlValue, currentConfig)) {
                        xbrlValues.add((XbrlValue)xbrlValue);
                    }
                } else {
                    this.unitService.fillValue(xbrlReport.getId(), xbrlValue, currentConfig);
                    this.xbrlValueCrudService.update(xbrlValue);
                }
            });
        }
        catch (NotFoundException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private boolean checkFact(XbrlValue xbrlValue, UnitsConfiguration currentConfig) {
        switch (1.$SwitchMap$ru$cbr$xbrl$converter$model$DataType[xbrlValue.getDataType().ordinal()]) {
            case 1: {
                return xbrlValue.getPrecision() == currentConfig.getCurrencyPrecision() && xbrlValue.getDecimals() == currentConfig.getCurrencyDecimals() && xbrlValue.getXbrlUnit().equals(currentConfig.getCurrency());
            }
            case 2: {
                return xbrlValue.getPrecision() == currentConfig.getSharesPrecision() && xbrlValue.getDecimals() == currentConfig.getSharesDecimals();
            }
            case 3: {
                return xbrlValue.getPrecision() == currentConfig.getDecimalPrecision() && xbrlValue.getDecimals() == currentConfig.getDecimalDecimals();
            }
            case 4: {
                return xbrlValue.getPrecision() == currentConfig.getIntegerPrecision() && xbrlValue.getDecimals() == currentConfig.getIntegerDecimals();
            }
        }
        return true;
    }

    private void iterateTablelinkbaseValues(XbrlReport report, XbrlReportRole role, Consumer<XbrlValue> xbrlValueConsumer) {
        try {
            TLBUiModel tlbUiModel = this.tableLinkBaseDataService.getTableLinkBaseUIFrom(role);
            Map dimensionsDefault = tlbUiModel.getDimensionsDefault();
            this.iterateTableLinkbaseFacts(tlbUiModel, aspectCellData -> {
                XbrlValueId xbrlValueId;
                XbrlValue xbrlValue;
                AspectData concept;
                aspectCellData.setRoleId(role.getId());
                aspectCellData.setRoleLabel(role.getTitle());
                String contextId = this.editXbrlService.findContext(report, aspectCellData, dimensionsDefault, new LruCache(5000), false);
                if (contextId != null && (concept = aspectCellData.getConcept()) != null && (xbrlValue = this.xbrlValueCrudService.find(xbrlValueId = new XbrlValueId(concept.getAspectValue(), report.getId(), contextId))) != null) {
                    xbrlValueConsumer.accept(xbrlValue);
                }
            });
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new UnitsConfigException();
        }
    }

    private void iterateTableLinkbaseFacts(TLBUiModel tlbUiModel, Consumer<AspectCellData> aspectCellDataConsumer) {
        List columnLeaves = TopHeaderModel.getLeaves((List)tlbUiModel.getColumnList(), (boolean)true);
        TopHeaderModel.buildColumnAspectsMap((List)tlbUiModel.getColumnList(), null);
        tlbUiModel.getPeriodLevelList().forEach(periodLevel -> periodLevel.getZLevelList().forEach(zLevel -> {
            List yLevelsUnwinded = TableLinkViewUtils.unwindYlevels((List)zLevel.getYLevelList());
            YLevel.collectFullAspectListForEachYLevel((List)zLevel.getYLevelList(), null);
            IntStream.range(0, yLevelsUnwinded.size()).forEach(yIndex -> {
                YLevel yLevel = (YLevel)yLevelsUnwinded.get(yIndex);
                IntStream.range(0, columnLeaves.size()).forEach(xIndex -> {
                    ColumnHeader columnHeader = (ColumnHeader)columnLeaves.get(xIndex);
                    String dataField = columnHeader.getDataField();
                    Map factMap = yLevel.getFactMap();
                    if (factMap.containsKey(dataField)) {
                        AspectCellData aspectCellData = new AspectCellData();
                        aspectCellData.setAspectDataList(new ArrayList());
                        aspectCellData.setCellValue(((Fact)factMap.get(dataField)).getValue());
                        aspectCellData.getAspectDataList().addAll(periodLevel.getAspectDataList());
                        aspectCellData.getAspectDataList().addAll(zLevel.getAspectDataList());
                        aspectCellData.getAspectDataList().addAll(yLevel.getFullAspectDataList());
                        aspectCellData.getAspectDataList().addAll(columnHeader.getFullAspectDataList());
                        aspectCellDataConsumer.accept(aspectCellData);
                    }
                });
            });
        }));
    }

    private void copyLocalDataFields(UnitsConfiguration source, UnitsConfiguration dest) {
        dest.setCurrency(source.getCurrency());
        dest.setCurrencyPrecision(source.getCurrencyPrecision());
        dest.setCurrencyDecimals(source.getCurrencyDecimals());
        dest.setSharesPrecision(source.getSharesPrecision());
        dest.setSharesDecimals(source.getSharesDecimals());
        dest.setDecimalPrecision(source.getDecimalPrecision());
        dest.setDecimalDecimals(source.getDecimalDecimals());
        dest.setIntegerPrecision(source.getIntegerPrecision());
        dest.setIntegerDecimals(source.getIntegerDecimals());
    }
}

