/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.model.tableLinkBase.NodeType;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.PeriodLevel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.TLBUiModel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.XYLevel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.YLevel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.YLevelEmpty;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.YLevelRC;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.YLevelRollup;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.ZLevel;
import ru.cbr.xbrl.converter.model.web.rest.ColumnHeader;
import ru.cbr.xbrl.converter.service.TableLinkBaseConverterService;
import ru.cbr.xbrl.converter.service.XYContext;

@Service
public class TableLinkBaseConverterServiceImpl
implements TableLinkBaseConverterService {
    private static final Logger log = LoggerFactory.getLogger(TableLinkBaseConverterServiceImpl.class);

    public void createXYLevels(TLBUiModel tab) {
        for (PeriodLevel p : tab.getPeriodLevelList()) {
            for (ZLevel z : p.getZLevelList()) {
                XYContext ctx = new XYContext();
                for (YLevel y : z.getYLevelList()) {
                    List list = ctx.processLevel(y);
                }
                z.getXyLevelList().addAll(ctx.getRes());
                for (int i = 0; i < z.getXyLevelList().size(); ++i) {
                    XYLevel l = (XYLevel)z.getXyLevelList().get(i);
                    XYLevel prevL = null;
                    if (i > 0) {
                        prevL = (XYLevel)z.getXyLevelList().get(i - 1);
                    }
                    boolean foundNotEmpty = false;
                    int yHeaderDepth = ctx.getMaxDepth();
                    if (ctx.hasRcCode()) {
                        ++yHeaderDepth;
                    }
                    for (int j = 0; j < yHeaderDepth; ++j) {
                        YLevel jl = l.getLevel(j);
                        YLevel prevJl = null;
                        if (j > 0) {
                            prevJl = l.getLevel(j - 1);
                        }
                        boolean bl = foundNotEmpty = foundNotEmpty || jl != null;
                        if (!foundNotEmpty) {
                            if (prevL == null) continue;
                            l.setLevel(j, prevL.getLevel(j));
                            continue;
                        }
                        if (ctx.hasRcCode() && j == yHeaderDepth - 1) {
                            YLevelRC rc = new YLevelRC();
                            rc.setRcCode(l.getRcCode());
                            l.setLevel(j, (YLevel)rc);
                            continue;
                        }
                        if (jl != null || prevJl == null) continue;
                        if (prevJl instanceof YLevelRollup) {
                            l.setLevel(j, (YLevel)new YLevelRollup());
                            continue;
                        }
                        if (prevJl instanceof YLevelEmpty) {
                            l.setLevel(j, (YLevel)new YLevelEmpty());
                            continue;
                        }
                        if (!(prevJl instanceof YLevel)) continue;
                        if (prevJl.getNodeType() == NodeType.ASPECT) {
                            l.setLevel(j, (YLevel)new YLevelEmpty());
                            continue;
                        }
                        l.setLevel(j, (YLevel)new YLevelRollup());
                    }
                }
                ArrayList<ColumnHeader> xyColumns = new ArrayList<ColumnHeader>();
                int yHeaderDepth = ctx.getMaxDepth();
                if (ctx.hasRcCode()) {
                    ++yHeaderDepth;
                }
                for (int i = 0; i < yHeaderDepth; ++i) {
                    ColumnHeader ch = new ColumnHeader();
                    if (ctx.hasRcCode() && i == yHeaderDepth - 1) {
                        ch.setDataField("rcCode");
                        ch.setHash("rcCode");
                        ch.setCaption("");
                    } else {
                        ch.setDataField("title");
                        ch.setHash("title_" + Integer.toString(i));
                        ch.setCaption((String)ctx.getHeaderCaptions().get(i));
                    }
                    xyColumns.add(ch);
                }
                if (xyColumns.size() == 0) {
                    ColumnHeader ch = new ColumnHeader();
                    ch.setDataField("title");
                    ch.setHash("title_0");
                    ch.setCaption("");
                    xyColumns.add(ch);
                }
                for (ColumnHeader c : tab.getColumnList()) {
                    if ("title".equals(c.getDataField()) || "rcCode".equals(c.getDataField())) continue;
                    xyColumns.add(c);
                }
                z.setXyColumnList(xyColumns);
                tab.setXyColumnList(xyColumns);
            }
        }
        for (PeriodLevel p : tab.getPeriodLevelList()) {
            for (ZLevel z : p.getZLevelList()) {
                z.setYLevelList(new ArrayList());
            }
        }
    }
}

