/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import java.util.Collections;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.simp.stomp.StompFrameHandler;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandler;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.client.standard.StandardWebSocketClient;
import org.springframework.web.socket.messaging.WebSocketStompClient;
import org.springframework.web.socket.sockjs.client.SockJsClient;
import org.springframework.web.socket.sockjs.client.WebSocketTransport;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.service.SystemService;
import ru.cbr.xbrl.converter.service.SystemServiceImpl;
import ru.cbr.xbrl.converter.utils.LogsAcrhive;

@Service
public class SystemServiceImpl
implements SystemService {
    private static final Logger log = LoggerFactory.getLogger(SystemServiceImpl.class);
    @Value(value="${server.port}")
    private int port;
    public static final String LOGS_ZIP = "logs.zip";
    @Autowired
    private ConfigProperties configProperties;
    BlockingQueue<String> blockingQueue;
    WebSocketStompClient stompClient;

    public void archiveLogs(String localFilePath) {
        String zipFileName = FilenameUtils.concat((String)localFilePath, (String)LOGS_ZIP);
        String electronLogFile = this.configProperties.getElectronappLogFileName();
        LogsAcrhive.createArchive((String)electronLogFile, (String)zipFileName);
    }

    @Async(value="startChecking")
    public void checkStartedWebSocket() {
        String WEBSOCKET_URI = "ws://127.0.0.1:" + this.port + "/ws";
        String WEBSOCKET_TOPIC = "/topic";
        boolean result = false;
        for (int counter = 0; !result && counter < 7; ++counter) {
            this.blockingQueue = new LinkedBlockingDeque();
            this.stompClient = new WebSocketStompClient((WebSocketClient)new SockJsClient(Collections.singletonList(new WebSocketTransport((WebSocketClient)new StandardWebSocketClient()))));
            try {
                TimeUnit.SECONDS.sleep(3L);
                StompSession session = (StompSession)this.stompClient.connect(WEBSOCKET_URI, (StompSessionHandler)new /* Unavailable Anonymous Inner Class!! */, new Object[0]).get(1L, TimeUnit.SECONDS);
                session.subscribe("/topic", (StompFrameHandler)new DefaultStompFrameHandler(this));
                String message = "MESSAGE TEST";
                session.send("/topic", (Object)message.getBytes());
                if (!message.equals(this.blockingQueue.poll(1L, TimeUnit.SECONDS))) continue;
                log.info("\u041c\u043e\u0434\u0443\u043b\u044c \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432 \u0437\u0430\u043f\u0443\u0449\u0435\u043d.");
                result = true;
                continue;
            }
            catch (Exception e) {
                log.info("\u0418\u0442\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u043c\u043e\u0434\u0443\u043b\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432.");
            }
        }
    }
}

