/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.service.KeyValueStoreService;
import ru.cbr.xbrl.converter.service.NamespacesService;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class NamespacesService {
    private static final Logger log = LoggerFactory.getLogger(NamespacesService.class);
    public static final String NAMESPACES_STORE_KEY = "namespaces";
    @Autowired
    private ConfigProperties configProperties;
    @Autowired
    private KeyValueStoreService keyValueStoreService;
    private List<XbrlXmlNamespace> namespaces = new ArrayList();
    private Map<String, String> defaultPrefixes = new HashMap();

    @PostConstruct
    public void onCreate() {
        try {
            log.info("Load namespaces from store");
            this.readNamespaces();
            log.info("Load namespaces from store complete. Loaded namespaces: {}", (Object)this.namespaces.size());
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void parse(String namespaceXml) {
        log.info("Load namespaces from file");
        this.namespaces = this.mergeUsedNamespaces(NamespacesService.parseNamespaceFile((String)namespaceXml));
        log.info("Load namespaces from fule complete. Loaded namespaces: {}", (Object)this.namespaces.size());
        this.defaultPrefixes = this.namespaces.stream().collect(Collectors.toMap(XbrlXmlNamespace::getValue, XbrlXmlNamespace::getPrefix));
        try {
            this.writeNamespaces();
        }
        catch (JsonProcessingException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private List<XbrlXmlNamespace> mergeUsedNamespaces(List<XbrlXmlNamespace> xbrlXmlNamespaces) {
        Map<String, Boolean> usedNamespaces = this.namespaces.stream().collect(Collectors.toMap(XbrlXmlNamespace::getValue, XbrlXmlNamespace::isUsed));
        if (CollectionUtils.isEmpty(xbrlXmlNamespaces)) {
            return Collections.emptyList();
        }
        for (XbrlXmlNamespace xbrlXmlNamespace : xbrlXmlNamespaces) {
            Boolean isUsed;
            String uri = xbrlXmlNamespace.getValue();
            if (StringUtils.isBlank((CharSequence)uri) || (isUsed = usedNamespaces.get(uri)) == null) continue;
            xbrlXmlNamespace.setUsed(isUsed.booleanValue());
        }
        return xbrlXmlNamespaces;
    }

    public String getDefaultPrefixForNamespace(String namespaceUri) {
        return (String)this.defaultPrefixes.get(namespaceUri);
    }

    public Map<String, String> getDefaultPrefixes() {
        return this.defaultPrefixes;
    }

    public static List<XbrlXmlNamespace> parseNamespaceFile(String fileFullName) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{XbrlXmlNamespaces.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            File file = new File(fileFullName);
            if (file.length() == 0L) {
                log.info("Empty parametersFile");
                return new ArrayList<XbrlXmlNamespace>();
            }
            XbrlXmlNamespaces parsedNamespaces = (XbrlXmlNamespaces)unmarshaller.unmarshal(file);
            return parsedNamespaces.getNamespaces();
        }
        catch (JAXBException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public static List<XbrlXmlNamespace> parseNamespaceXml(String xml) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{XbrlXmlNamespaces.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            StringReader reader = new StringReader(xml);
            XbrlXmlNamespaces parsedNamespaces = (XbrlXmlNamespaces)unmarshaller.unmarshal((Reader)reader);
            return parsedNamespaces.getNamespaces();
        }
        catch (JAXBException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public void save(List<XbrlXmlNamespace> namespaces) {
        this.namespaces = namespaces;
        this.defaultPrefixes = namespaces.stream().collect(Collectors.toMap(XbrlXmlNamespace::getValue, XbrlXmlNamespace::getPrefix));
        try {
            this.writeNamespaces();
        }
        catch (JsonProcessingException e) {
            log.error("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e\u0431 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u043d\u044b\u0445 namespaces. \u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f.");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public List<XbrlXmlNamespace> getUsedNamespaceList() {
        List namespaces = this.getNamespaces();
        if (CollectionUtils.isEmpty((Collection)namespaces)) {
            return Collections.emptyList();
        }
        return namespaces.stream().filter(XbrlXmlNamespace::isUsed).collect(Collectors.toList());
    }

    public List<XbrlXmlNamespace> getNamespacesListFromDefaultPrefixes(Set<String> memberPrefixSet) {
        if (CollectionUtils.isEmpty(memberPrefixSet)) {
            return Collections.emptyList();
        }
        List namespaces = this.getNamespaces();
        memberPrefixSet.remove(null);
        memberPrefixSet.remove("");
        return namespaces.stream().filter(xbrlXmlNamespace -> memberPrefixSet.contains(xbrlXmlNamespace.getPrefix())).collect(Collectors.toList());
    }

    private void writeNamespaces() throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        String json = objectMapper.writeValueAsString((Object)this.namespaces);
        this.keyValueStoreService.putString("namespaces", json);
    }

    private void readNamespaces() throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        1 typeReference = new /* Unavailable Anonymous Inner Class!! */;
        String json = this.keyValueStoreService.getString("namespaces");
        if (StringUtils.isNotBlank((CharSequence)json)) {
            this.namespaces = (List)objectMapper.readValue(json, (TypeReference)typeReference);
            this.defaultPrefixes = this.namespaces.stream().collect(Collectors.toMap(XbrlXmlNamespace::getValue, XbrlXmlNamespace::getPrefix));
        }
    }

    public List<XbrlXmlNamespace> getNamespaces() {
        try {
            this.readNamespaces();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.namespaces;
    }
}

