/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.utils.GzipUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DimensionsDefaultService {
    private static final Logger log = LoggerFactory.getLogger(DimensionsDefaultService.class);
    private Map<String, String> dimensionsDefault;

    public void loadFromReport(XbrlReport xbrlReport) {
        this.dimensionsDefault = DimensionsDefaultService.decompressDimensionsDefault((byte[])xbrlReport.getDimensionsDefaultJsonGzipped());
        log.info("DimensionsDefault reloaded, size = " + this.dimensionsDefault.size());
    }

    public Map<String, String> getDimensionsDefault() {
        return this.dimensionsDefault;
    }

    public static byte[] compressDimensionsDefault(List<TableLinkBaseStructure> tableLinkBaseStructures) {
        Optional<TableLinkBaseStructure> dd = tableLinkBaseStructures.stream().filter(t -> t.getDimensionsDefault() != null && t.getDimensionsDefault().size() > 0).findFirst();
        if (!dd.isPresent()) {
            return null;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String json = objectMapper.writeValueAsString((Object)dd.get().getDimensionsDefault());
            byte[] gzipped = GzipUtils.compressString((String)json);
            return gzipped;
        }
        catch (JsonProcessingException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public static Map<String, String> decompressDimensionsDefault(byte[] gzipped) {
        if (gzipped == null) {
            return new HashMap<String, String>();
        }
        try {
            String json = GzipUtils.decompressString((byte[])gzipped);
            ObjectMapper objectMapper = new ObjectMapper();
            Map dimensionsDefault = (Map)objectMapper.readValue(json, HashMap.class);
            return dimensionsDefault;
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return new HashMap<String, String>();
        }
    }

    public void setDimensionsDefault(Map<String, String> dimensionsDefault) {
        this.dimensionsDefault = dimensionsDefault;
    }

    public void removeDimensionsDefault(AspectCellData aspectCellData) {
        if (this.dimensionsDefault == null) {
            return;
        }
        Iterator dimIterator = aspectCellData.getAspectDataList().iterator();
        while (dimIterator.hasNext()) {
            AspectData aspect = (AspectData)dimIterator.next();
            if (aspect.getType() != AspectType.DIMENSION || !aspect.getDimensionType().equals((Object)DimensionType.EXPLICIT_MEMBER)) continue;
            String dimension = aspect.getAspect();
            String member = aspect.getAspectValue();
            if (!this.dimensionsDefault.containsKey(dimension) || !((String)this.dimensionsDefault.get(dimension)).equals(member)) continue;
            dimIterator.remove();
        }
    }
}

