/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.model.DataType;
import ru.cbr.xbrl.converter.model.reference_linkbase.ReferenceLinkbase;
import ru.cbr.xbrl.converter.model.xbrl_content.PeriodType;
import ru.cbr.xbrl.converter.service.ConceptDocumentationService;
import ru.cbr.xbrl.converter.service.ConceptInMemoryService;
import ru.cbr.xbrl.converter.service.ConceptService;
import ru.cbr.xbrl.converter.service.KeyValueStoreService;
import ru.cbr.xbrl.converter.utils.DataTypeUtils;

@Service
public class ConceptInMemoryService
implements ConceptService,
ConceptDocumentationService {
    private static final Logger log = LoggerFactory.getLogger(ConceptInMemoryService.class);
    public static final String CONCEPT_PERIOD_TYPES_MAP = "concept_period_types_map";
    public static final String CONCEPT_XSD_TYPES_MAP = "concept_xsd_types_map";
    public static final String CONCEPT_PATTERNS_MAP = "concept_patterns_map";
    public static final String DIMENSION_DOMAINS = "dimension_domains";
    public static final String CONCEPT_DATA_TYPES_MAP = "concept_data_types_map";
    public static final String CONCEPT_DOCS_MAP = "concept_docs_map";
    @Autowired
    private KeyValueStoreService keyValueStoreService;
    private Map<String, String> cachedConcepts = new HashMap();
    private Map<String, String> cachedConceptXsdTypes = new HashMap();
    private Map<String, String> cachedConceptPatterns = new HashMap();
    private Map<String, PeriodType> cachedConceptPeriodTypes = new HashMap();
    private Map<String, String> cachedDomains = new HashMap();
    private Map<String, String> cachedDocs = new HashMap();
    private Map<String, Set<String>> contextRoleMap = new ConcurrentHashMap();
    private Set<String> explicitAspectNodeSet = new HashSet();

    public DataType findTypeByConcept(String element) {
        return DataTypeUtils.getType((String)((String)this.cachedConcepts.get(element)));
    }

    public String findXsdTypeByConcept(String element) {
        return (String)this.cachedConceptXsdTypes.get(element);
    }

    public String findPatternByConcept(String element) {
        return (String)this.cachedConceptPatterns.get(element);
    }

    public PeriodType findPeriodTypeByConcept(String element) {
        return (PeriodType)this.cachedConceptPeriodTypes.get(element);
    }

    public String findDomainByDimension(String element) {
        return (String)this.cachedDomains.get(element);
    }

    public Boolean exists(String element) {
        return this.cachedConcepts.keySet().contains(element);
    }

    public void save(String element, String type) {
        this.cachedConcepts.put(element, type);
    }

    public void saveXsdType(String element, String xsdType) {
        if (StringUtils.isNotBlank((CharSequence)xsdType)) {
            this.cachedConceptXsdTypes.put(element, xsdType);
        }
    }

    public void saveDomain(String element, String domain) {
        if (StringUtils.isNotBlank((CharSequence)domain)) {
            this.cachedDomains.put(element, domain);
        }
    }

    public void savePattern(String element, String pattern) {
        if (StringUtils.isNotBlank((CharSequence)pattern)) {
            this.cachedConceptPatterns.put(element, pattern);
        }
    }

    public void saveConceptPeriodType(String element, PeriodType periodType) {
        if (periodType != null) {
            this.cachedConceptPeriodTypes.put(element, periodType);
        }
    }

    public void store() {
        try {
            this.writePeriodTypes();
            this.writeXsdTypes();
            this.writePatterns();
            this.writeDomains();
            this.writeDataTypes();
            this.writeDocs();
        }
        catch (JsonProcessingException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private void writePeriodTypes() throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        String json = objectMapper.writeValueAsString((Object)this.cachedConceptPeriodTypes);
        this.keyValueStoreService.putString(CONCEPT_PERIOD_TYPES_MAP, json);
    }

    private void writeXsdTypes() throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        String json = objectMapper.writeValueAsString((Object)this.cachedConceptXsdTypes);
        this.keyValueStoreService.putString(CONCEPT_XSD_TYPES_MAP, json);
    }

    private void writePatterns() throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        String json = objectMapper.writeValueAsString((Object)this.cachedConceptPatterns);
        this.keyValueStoreService.putString(CONCEPT_PATTERNS_MAP, json);
    }

    private void writeDomains() throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        String json = objectMapper.writeValueAsString((Object)this.cachedDomains);
        this.keyValueStoreService.putString(DIMENSION_DOMAINS, json);
    }

    private void writeDataTypes() throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        String json = objectMapper.writeValueAsString((Object)this.cachedConcepts);
        this.keyValueStoreService.putString(CONCEPT_DATA_TYPES_MAP, json);
    }

    private void writeDocs() throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        String json = objectMapper.writeValueAsString((Object)this.cachedDocs);
        this.keyValueStoreService.putString(CONCEPT_DOCS_MAP, json);
    }

    @PostConstruct
    public void restore() throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        this.readPeriodTypes(objectMapper);
        this.readXsdTypes(objectMapper);
        this.readPatterns(objectMapper);
        this.readDomains(objectMapper);
        this.readDataTypes(objectMapper);
        this.readDocs(objectMapper);
    }

    private void readXsdTypes(ObjectMapper objectMapper) throws IOException {
        1 typeReference = new /* Unavailable Anonymous Inner Class!! */;
        String xsdJson = this.keyValueStoreService.getString(CONCEPT_XSD_TYPES_MAP);
        if (StringUtils.isNotBlank((CharSequence)xsdJson)) {
            Map conceptXsdTypesMap = (Map)objectMapper.readValue(xsdJson, (TypeReference)typeReference);
            this.cachedConceptXsdTypes.clear();
            this.cachedConceptXsdTypes.putAll(conceptXsdTypesMap);
        }
    }

    private void readPeriodTypes(ObjectMapper objectMapper) throws IOException {
        2 typeReference = new /* Unavailable Anonymous Inner Class!! */;
        String json = this.keyValueStoreService.getString(CONCEPT_PERIOD_TYPES_MAP);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            Map conceptPeriodTypesMap = (Map)objectMapper.readValue(json, (TypeReference)typeReference);
            this.cachedConceptPeriodTypes.clear();
            this.cachedConceptPeriodTypes.putAll(conceptPeriodTypesMap);
        }
    }

    private void readPatterns(ObjectMapper objectMapper) throws IOException {
        3 typeReference = new /* Unavailable Anonymous Inner Class!! */;
        String json = this.keyValueStoreService.getString(CONCEPT_PATTERNS_MAP);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            Map conceptPatternsMap = (Map)objectMapper.readValue(json, (TypeReference)typeReference);
            this.cachedConceptPatterns.clear();
            this.cachedConceptPatterns.putAll(conceptPatternsMap);
        }
    }

    private void readDomains(ObjectMapper objectMapper) throws IOException {
        4 typeReference = new /* Unavailable Anonymous Inner Class!! */;
        String json = this.keyValueStoreService.getString(DIMENSION_DOMAINS);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            Map conceptPatternsMap = (Map)objectMapper.readValue(json, (TypeReference)typeReference);
            this.cachedDomains.clear();
            this.cachedDomains.putAll(conceptPatternsMap);
        }
    }

    private void readDataTypes(ObjectMapper objectMapper) throws IOException {
        5 typeReference = new /* Unavailable Anonymous Inner Class!! */;
        String json = this.keyValueStoreService.getString(CONCEPT_DATA_TYPES_MAP);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            Map conceptPatternsMap = (Map)objectMapper.readValue(json, (TypeReference)typeReference);
            this.cachedConcepts.clear();
            this.cachedConcepts.putAll(conceptPatternsMap);
        }
    }

    private void readDocs(ObjectMapper objectMapper) throws IOException {
        6 typeReference = new /* Unavailable Anonymous Inner Class!! */;
        String json = this.keyValueStoreService.getString(CONCEPT_DOCS_MAP);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            Map conceptDocsMap = (Map)objectMapper.readValue(json, (TypeReference)typeReference);
            this.cachedDocs.clear();
            this.cachedDocs.putAll(conceptDocsMap);
        }
    }

    public void addContextRoleMap(String roleId, String value) {
        Set set = this.contextRoleMap.computeIfAbsent(roleId, k -> ConcurrentHashMap.newKeySet());
        set.add(value);
    }

    public Set<String> getContextRole(String roleId) {
        Set set = (Set)this.contextRoleMap.get(roleId);
        if (CollectionUtils.isEmpty((Collection)set)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    public void clearContextRoleMap() {
        if (this.contextRoleMap == null) {
            this.contextRoleMap = new HashMap();
            return;
        }
        this.contextRoleMap.clear();
    }

    public Set<String> getExplicitAspectNodeSet() {
        if (this.explicitAspectNodeSet == null) {
            this.explicitAspectNodeSet = new HashSet();
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.explicitAspectNodeSet);
    }

    public void addExplicitAspectNode(String value) {
        this.explicitAspectNodeSet.add(value);
    }

    public void addAllExplicitAspectNode(Set<String> value) {
        this.explicitAspectNodeSet.addAll(value);
    }

    public void clearExplicitAspectNodeSet() {
        if (this.explicitAspectNodeSet == null) {
            this.explicitAspectNodeSet = new HashSet();
            return;
        }
        this.explicitAspectNodeSet.clear();
    }

    public void saveDocs(String element, String doc) {
        if (StringUtils.isNotBlank((CharSequence)doc)) {
            this.cachedDocs.put(element, doc);
        }
    }

    public List<ReferenceLinkbase> getConceptDocumentation(List<String> elements) {
        HashSet<String> elementsSet = new HashSet<String>();
        elementsSet.addAll(elements);
        ArrayList<ReferenceLinkbase> result = new ArrayList<ReferenceLinkbase>();
        for (String element : elementsSet) {
            if (this.cachedDocs.get(element) == null) continue;
            ReferenceLinkbase r = new ReferenceLinkbase();
            r.setText((String)this.cachedDocs.get(element));
            r.setName(element);
            result.add(r);
        }
        return result;
    }
}

