/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXB;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.exception.AccessDeniedDirectoryException;
import ru.cbr.xbrl.converter.exception.CancelledException;
import ru.cbr.xbrl.converter.exception.IncompatibleSchemaRefException;
import ru.cbr.xbrl.converter.exception.MoveFileException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.RefreshInternalXbrlException;
import ru.cbr.xbrl.converter.exception.RemoveFileException;
import ru.cbr.xbrl.converter.exception.SavePackageException;
import ru.cbr.xbrl.converter.exception.TaxonomyNotFoundException;
import ru.cbr.xbrl.converter.exception.UploadException;
import ru.cbr.xbrl.converter.exception.XbrlExportException;
import ru.cbr.xbrl.converter.exception.XbrlImportException;
import ru.cbr.xbrl.converter.exception.ZipExtractFileException;
import ru.cbr.xbrl.converter.model.Attachment;
import ru.cbr.xbrl.converter.model.event.NotificationEvent;
import ru.cbr.xbrl.converter.model.log.EventLog;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.pkg.report.ReportingPackage;
import ru.cbr.xbrl.converter.service.AttachmentService;
import ru.cbr.xbrl.converter.service.CompressedXbrlPackageService;
import ru.cbr.xbrl.converter.service.DimensionsDefaultService;
import ru.cbr.xbrl.converter.service.EnumerationsService;
import ru.cbr.xbrl.converter.service.XbrlPackageService;
import ru.cbr.xbrl.converter.service.XbrlReportService;
import ru.cbr.xbrl.converter.service.event.NotificationEventService;
import ru.cbr.xbrl.converter.service.event.NotificationEventServiceImpl;
import ru.cbr.xbrl.converter.service.import_export.ExportXbrlService;
import ru.cbr.xbrl.converter.service.import_export.ImportXbrlService;
import ru.cbr.xbrl.converter.service.presentation_definition.InactiveMembersService;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionService;
import ru.cbr.xbrl.converter.service.tablelinkbase.AxisService;
import ru.cbr.xbrl.converter.utils.FileUtils;
import ru.cbr.xbrl.converter.utils.ZipUtils;

@Service
public class CompressedXbrlPackageServiceImpl
implements CompressedXbrlPackageService {
    private static final Logger log = LoggerFactory.getLogger(CompressedXbrlPackageServiceImpl.class);
    private static final String COMPRESSED_PACKAGE_EXTENSION = ".ank";
    private static final String COMPRESSED_REPORTING_PACKAGE_EXTENSION = "zip";
    private static final String PACKAGE_XML_EXTENSION = ".xml";
    public static final String DEFAULT_PACKAGE_XML_FILE_NAME = "anketa.xml";
    private static final String REPORTING_PACKAGE_XML_EXTENSION = ".xml";
    @Autowired
    private XbrlPackageService xbrlPackageService;
    @Autowired
    private XbrlReportService xbrlReportService;
    @Autowired
    private ConfigProperties configProperties;
    @Autowired
    private ExportXbrlService exportXbrlService;
    @Autowired
    private ImportXbrlService importXbrlService;
    @Autowired
    private NotificationEventService notificationEventService;
    @Autowired
    private PresentationDefinitionService presentationDefinitionService;
    @Autowired
    private DimensionsDefaultService dimensionsDefaultService;
    @Autowired
    private EnumerationsService enumerationsService;
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private InactiveMembersService inactiveMembersService;
    @Autowired
    private AxisService axisService;

    @Transactional(value="cacheTransactionManager")
    public XbrlPackage load(String localPath) throws RemoveFileException, UploadException, TaxonomyNotFoundException, CancelledException, NotFoundException, MoveFileException, ZipExtractFileException, XbrlExportException, IOException, XbrlImportException, IncompatibleSchemaRefException {
        Date startLoading = new Date();
        log.info("Loading xbrl package " + localPath + "....");
        log.info("[Loading xbrl package] Process package description...");
        Date startProcessPackageDescription = new Date();
        String zipFileName = FilenameUtils.getName((String)localPath);
        String packageXmlFileName = DEFAULT_PACKAGE_XML_FILE_NAME;
        if (ZipUtils.findEntry((String)localPath, (String)packageXmlFileName) == null) {
            packageXmlFileName = zipFileName.replaceFirst(".ank$", ".xml");
        }
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.OPEN, new NotificationEvent("\u0427\u0442\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u0430\u043a\u0435\u0442\u0430"));
        String packageXmlContent = ZipUtils.extractTextFileContent((String)localPath, (String)packageXmlFileName);
        XbrlPackage xbrlPackage = (XbrlPackage)JAXB.unmarshal((Reader)new StringReader(packageXmlContent), XbrlPackage.class);
        List unitsConfigurations = xbrlPackage.getUnitsConfiguration();
        xbrlPackage.getXbrlPackagePeriodList().stream().forEach(p -> p.setXbrlPackage(xbrlPackage));
        xbrlPackage.getContextPeriod().setXbrlPackage(xbrlPackage);
        xbrlPackage.getXbrlParameters().forEach(p -> p.setXbrlPackage(xbrlPackage));
        String filePath = localPath.substring(0, localPath.lastIndexOf(File.separator));
        xbrlPackage.setPathForPackage(filePath);
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.OPEN, new NotificationEvent("\u041e\u0442\u043a\u0440\u044b\u0442\u0438\u0435 \u043f\u0430\u043a\u0435\u0442\u0430"));
        if (xbrlPackage.getXbrlReport() == null) {
            return this.xbrlPackageService.create(xbrlPackage);
        }
        log.info("[Loading xbrl package] Process package description completed in " + (new Date().getTime() - startProcessPackageDescription.getTime()) + " msec");
        log.info("[Loading xbrl package] Extracting xbrl file from archive...");
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.OPEN, new NotificationEvent("\u0418\u0437\u0432\u043b\u0435\u0447\u0435\u043d\u0438\u0435 \u043e\u0442\u0447\u0435\u0442\u0430"));
        Date startExtractingXbrlFile = new Date();
        String xbrlStorePath = FileUtils.relativePathToAbsolute((String)this.configProperties.getXbrlStorePath());
        String xbrlFilePath = xbrlPackage.getXbrlReport().getFilePath();
        if (ZipUtils.findEntry((String)localPath, (String)xbrlFilePath) == null) {
            xbrlFilePath = xbrlPackage.generateXbrlName();
        }
        String filePathInternal = FilenameUtils.concat((String)xbrlStorePath, (String)xbrlFilePath);
        ZipUtils.extractFile((String)localPath, (String)xbrlFilePath, (String)filePathInternal);
        this.attachmentService.loadAttachments(localPath, xbrlPackage);
        xbrlPackage.getXbrlReport().setFilePath(filePathInternal);
        xbrlPackage.getXbrlReport().setXbrlPackage(xbrlPackage);
        XbrlPackage createdPackage = this.xbrlPackageService.create(xbrlPackage);
        this.dimensionsDefaultService.loadFromReport(createdPackage.getXbrlReport());
        this.enumerationsService.loadFromReport(createdPackage.getXbrlReport());
        log.info("[Loading xbrl package] Extracting xbrl file from archive completed in " + (new Date().getTime() - startExtractingXbrlFile.getTime()) + " msec");
        log.info("[Loading xbrl package] Prepare view with arelle file...");
        Date startPrepareView = new Date();
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.OPEN, new NotificationEvent("\u041f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u0435 Table Linkbase"));
        this.xbrlReportService.processXbrlFile(xbrlPackage);
        log.info("[Loading xbrl package] Prepare view with arelle  complete in " + (new Date().getTime() - startPrepareView.getTime()) + " msec");
        log.info("[Loading xbrl package] Import xbrl file to internal representation...");
        Date startImportXbrlToInternalRepresentation = new Date();
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.OPEN, new NotificationEvent("\u0427\u0442\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u043e\u0442\u0447\u0435\u0442\u0430"));
        Boolean isRepairTagSelectors = Boolean.FALSE;
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(filePathInternal));){
            this.importXbrlService.importXml(xbrlPackage.getXbrlReport().getId(), (InputStream)inputStream, Boolean.TRUE, Boolean.TRUE, isRepairTagSelectors, EventLog.EventLogType.IMPORT_XML, filePathInternal);
            this.axisService.processAllContexts();
        }
        log.info("[Loading xbrl package] Import xbrl file to internal representation completed in " + (new Date().getTime() - startImportXbrlToInternalRepresentation.getTime()) + " msec");
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.OPEN, new NotificationEvent("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0444\u0438\u043b\u044c\u0442\u0440\u043e\u0432"));
        this.inactiveMembersService.restoreInactiveMembers(xbrlPackage);
        this.xbrlPackageService.processPeriodEnabled(createdPackage.getXbrlReport());
        createdPackage.setUnitsConfiguration(unitsConfigurations);
        log.info("Loading xbrl package " + localPath + " completed in " + (new Date().getTime() - startLoading.getTime()) + " msec");
        return createdPackage;
    }

    public void savePackageFiles(XbrlPackage xbrlPackage) throws MoveFileException, SavePackageException, AccessDeniedDirectoryException {
        String zipFileName = FilenameUtils.concat((String)xbrlPackage.getPathForPackage(), (String)(xbrlPackage.getName() + COMPRESSED_PACKAGE_EXTENSION));
        File zipFile = new File(zipFileName);
        this.inactiveMembersService.saveInactiveMembers(xbrlPackage);
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(zipFile));){
            this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.SAVE, new NotificationEvent("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u043e\u0442\u0447\u0435\u0442\u0430"));
            try {
                this.addXbrlReportToZip(xbrlPackage, zipOutputStream, false);
            }
            catch (SavePackageException e) {
                throw new SavePackageException();
            }
            this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.SAVE, new NotificationEvent("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u0430\u043a\u0435\u0442\u0430"));
            this.marshalPackageObjectToZipOutputStream(zipOutputStream, xbrlPackage);
        }
        catch (FileNotFoundException e) {
            if (e.getMessage().contains("\u041e\u0442\u043a\u0430\u0437\u0430\u043d\u043e \u0432 \u0434\u043e\u0441\u0442\u0443\u043f\u0435")) {
                throw new AccessDeniedDirectoryException();
            }
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (XbrlExportException e) {
            e.printStackTrace();
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
    }

    private void addAttachmentsToZip(XbrlPackage xbrlPackage, ZipOutputStream zipOutputStream, boolean isCbReport) throws IOException {
        if (xbrlPackage == null || CollectionUtils.isEmpty((Collection)xbrlPackage.getAttachments())) {
            return;
        }
        String attachmentsStorePath = FileUtils.relativePathToAbsolute((String)this.configProperties.getAttachmentsStorePath());
        for (Attachment attachment : xbrlPackage.getAttachments()) {
            String attachmentsPath = isCbReport ? "" : "attachments";
            ZipEntry e = new ZipEntry(FilenameUtils.concat((String)attachmentsPath, (String)attachment.getName()));
            zipOutputStream.putNextEntry(e);
            String attachmentFilePath = FilenameUtils.concat((String)attachmentsStorePath, (String)attachment.getName());
            FileInputStream is = new FileInputStream(attachmentFilePath);
            Throwable throwable = null;
            try {
                log.info("Add attachment '{}' to zip archive", (Object)attachment.getName());
                IOUtils.copyLarge((InputStream)is, (OutputStream)zipOutputStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
    }

    public void saveReportingPackageFiles(XbrlPackage xbrlPackage, Date packageDate) throws MoveFileException, SavePackageException, AccessDeniedDirectoryException {
        Date refPeriodEnd = packageDate;
        if ("SD".equals(xbrlPackage.getNfoType())) {
            refPeriodEnd = xbrlPackage.getRefPeriodEndValue(xbrlPackage.getXbrlParameters()).getValue();
        }
        String zipFileName = FilenameUtils.concat((String)xbrlPackage.getPathForPackage(), (String)xbrlPackage.generateXbrlZipName("arch", COMPRESSED_REPORTING_PACKAGE_EXTENSION, refPeriodEnd));
        File zipFile = new File(zipFileName);
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(zipFile));){
            this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.SAVE, new NotificationEvent("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u043e\u0442\u0447\u0435\u0442\u0430"));
            try {
                this.addXbrlReportToZip(xbrlPackage, zipOutputStream, true);
            }
            catch (SavePackageException e) {
                throw new SavePackageException();
            }
            ReportingPackage reportingPackage = new ReportingPackage(xbrlPackage, packageDate);
            this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.SAVE, new NotificationEvent("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u0430\u043a\u0435\u0442\u0430"));
            this.marshalReportingPackageObjectToZipOutputStream(zipOutputStream, reportingPackage);
        }
        catch (FileNotFoundException e) {
            if (e.getMessage().contains("\u041e\u0442\u043a\u0430\u0437\u0430\u043d\u043e \u0432 \u0434\u043e\u0441\u0442\u0443\u043f\u0435")) {
                throw new AccessDeniedDirectoryException();
            }
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (XbrlExportException e) {
            e.printStackTrace();
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
    }

    private void addXbrlReportToZip(XbrlPackage xbrlPackage, ZipOutputStream zipOutputStream, boolean isCbReport) throws IOException, XbrlExportException, NotFoundException, SavePackageException {
        if (xbrlPackage.getXbrlReport() != null) {
            xbrlPackage.getXbrlReport().setXbrlPackage(null);
            if (xbrlPackage.getFiles() != null) {
                this.addAttachmentsToZip(xbrlPackage, zipOutputStream, isCbReport);
            }
            try {
                this.importXbrlService.refreshInternalXbrlXml(xbrlPackage.getXbrlReport());
            }
            catch (RefreshInternalXbrlException e) {
                throw new SavePackageException();
            }
            ZipEntry e = new ZipEntry(FilenameUtils.getName((String)(isCbReport ? xbrlPackage.generateXbrlZipName("XBRL", "xml", null) : xbrlPackage.generateXbrlName())));
            zipOutputStream.putNextEntry(e);
            String xbrlFilePath = xbrlPackage.getXbrlReport().getFilePath();
            try (FileInputStream is = new FileInputStream(xbrlFilePath);){
                String fileName = e.getName();
                log.info(String.format("Add %s to zip archive as %s", xbrlFilePath, fileName));
                IOUtils.copyLarge((InputStream)is, (OutputStream)zipOutputStream);
                xbrlPackage.getXbrlReport().setFilePath(fileName);
                xbrlPackage.getXbrlReport().setFileName(fileName);
            }
        }
    }

    private void marshalPackageObjectToZipOutputStream(ZipOutputStream zipOutputStream, XbrlPackage xbrlPackage) throws IOException {
        ZipEntry e = new ZipEntry(DEFAULT_PACKAGE_XML_FILE_NAME);
        zipOutputStream.putNextEntry(e);
        JAXB.marshal((Object)xbrlPackage, (OutputStream)zipOutputStream);
    }

    private void marshalReportingPackageObjectToZipOutputStream(ZipOutputStream zipOutputStream, ReportingPackage reportingPackage) throws IOException {
        ZipEntry e = new ZipEntry(reportingPackage.getName());
        zipOutputStream.putNextEntry(e);
        JAXB.marshal((Object)reportingPackage, (OutputStream)zipOutputStream);
    }

    public void addTextFileToZipOutputStream(ZipOutputStream zipOutputStream, String fileName) throws IOException {
        ZipEntry e = new ZipEntry(FilenameUtils.getName((String)fileName));
        zipOutputStream.putNextEntry(e);
        try (FileInputStream is = new FileInputStream(fileName);){
            IOUtils.copyLarge((InputStream)is, (OutputStream)zipOutputStream);
        }
    }
}

