/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.arelle.parse.HypercubeService;
import ru.cbr.xbrl.converter.model.tableLinkBase.AxisMemberHierarchy;
import ru.cbr.xbrl.converter.model.xbrl_content.PeriodType;
import ru.cbr.xbrl.converter.model.xbrl_content.RoleCell;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.service.DimensionsDefaultService;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionService;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;

@Service
public final class CellEditableCheckerService {
    private static final Logger log = LoggerFactory.getLogger(CellEditableCheckerService.class);
    @Autowired
    private PresentationDefinitionService presentationDefinitionService;
    @Autowired
    private DimensionsDefaultService dimensionsDefaultService;
    private List<RoleCell> roleCells;
    @Autowired
    private HypercubeService hypercubeService;

    public Boolean checkNotEditable(String dimensionHash, List<XbrlContextDimension> xbrlContextDimensions, String conceptName) {
        return !this.presentationDefinitionService.isEditable(conceptName, xbrlContextDimensions, dimensionHash);
    }

    public boolean isEditable(AxisMemberHierarchy zItem, AxisMemberHierarchy yItem, AxisMemberHierarchy xItem) {
        return this.isEditable(zItem, yItem, xItem, this.dimensionsDefaultService.getDimensionsDefault());
    }

    private boolean isEditable(AxisMemberHierarchy zItem, AxisMemberHierarchy yItem, AxisMemberHierarchy xItem, Map<String, String> dimensionsDefault) {
        if (zItem.isAbstractNode() || yItem.isAbstractNode() || xItem.isAbstractNode()) {
            return false;
        }
        ArrayList aspectDataList = new ArrayList();
        aspectDataList.addAll(zItem.getAspectDataList());
        aspectDataList.addAll(yItem.getAspectDataList());
        aspectDataList.addAll(xItem.getAspectDataList());
        AspectCellData aspectCellData = new AspectCellData();
        aspectCellData.setAspectDataList(aspectDataList);
        boolean isCellNotEditable = this.isNotEditable(aspectCellData.getAspectDataList(), this.dimensionsDefaultService.getDimensionsDefault());
        return !yItem.isAbstractNode() && !isCellNotEditable;
    }

    public boolean isEditable(AspectCellData aspectCellData) {
        boolean isCellNotEditable = this.isNotEditable(aspectCellData.getAspectDataList(), this.dimensionsDefaultService.getDimensionsDefault());
        return !aspectCellData.isAbstractNode() && !isCellNotEditable;
    }

    public boolean isNotEditable(List<AspectData> aspectDataList, Map<String, String> dimensionsDefault) {
        AspectCellData aspectCellData = new AspectCellData();
        aspectCellData.setAspectDataList(aspectDataList);
        AspectData concept = aspectCellData.getConcept();
        if (concept == null) {
            return false;
        }
        List dimensions = aspectCellData.getDimensions();
        List dimensionsWithoutDefaults = XbrlContextDimension.removeDefaultDimensions((List)dimensions, dimensionsDefault);
        List xbrlContextDimensions = dimensionsWithoutDefaults.stream().map(d -> {
            if (d.getDimensionType() == DimensionType.TYPED_MEMBER) {
                return new XbrlContextDimension(d.getAspect(), d.getDomain(), d.getAspectValue());
            }
            return new XbrlContextDimension(d.getAspect(), d.getAspectValue());
        }).collect(Collectors.toList());
        String dimensionsString = XbrlContextDimension.dimensionsToString(xbrlContextDimensions);
        String dimensionsHash = XbrlContextDimension.dimensionToHash(xbrlContextDimensions);
        String dimensionHashWithClearedDomains = XbrlContextDimension.dimensionToHash((List)XbrlContextDimension.clearDomainsFromDimensions(xbrlContextDimensions));
        String dimintsString = XbrlContextDimension.dimintsToString(xbrlContextDimensions);
        Boolean isNotEditable = this.checkNotEditable(dimensionHashWithClearedDomains, xbrlContextDimensions, concept.getAspectValue());
        return concept.isAbstractNode() || isNotEditable != false;
    }

    public boolean checkNotEditable(AspectCellData aspectCellData) {
        Optional<AspectData> concept = aspectCellData.getAspectDataList().stream().filter(p -> p.getType() == AspectType.CONCEPT && !p.isAbstractNode()).findFirst();
        AspectData conceptData = null;
        AspectData periodData = null;
        if (concept.isPresent()) {
            conceptData = concept.get();
            String tagSelector = conceptData.getTagSelector();
            Optional<AspectData> period = aspectCellData.getAspectDataList().stream().filter(p -> "period type".equals(p.getAspect()) && this.isTagEquals(p.getTag(), tagSelector)).findFirst();
            if (period.isPresent()) {
                periodData = period.get();
            }
        }
        if (conceptData != null && periodData != null && (conceptData.getConceptPeriodType() == PeriodType.INSTANT && periodData.getAspectValue().equals("duration") || conceptData.getConceptPeriodType() == PeriodType.DURATION && !periodData.getAspectValue().equals("duration"))) {
            return true;
        }
        aspectCellData.setAspectDataList(XbrlContextDimension.removeDefaultDimensions((List)aspectCellData.getAspectDataList(), (Map)this.dimensionsDefaultService.getDimensionsDefault()));
        return !this.hypercubeService.isHypercubeExists(aspectCellData);
    }

    private boolean isTagEquals(String tag, String tagSelector) {
        if (tagSelector == null) {
            return tag == null;
        }
        return tagSelector.equals(tag);
    }

    public boolean checkNotEditableExcludeMembers(AspectCellData aspectCellData) {
        aspectCellData.setAspectDataList(XbrlContextDimension.removeDefaultDimensions((List)aspectCellData.getAspectDataList(), (Map)this.dimensionsDefaultService.getDimensionsDefault()));
        return !this.hypercubeService.isHypercubeExcludeMembersExists(aspectCellData);
    }
}

