/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.service.CacheManagementService;
import ru.cbr.xbrl.converter.service.NamespacesService;
import ru.cbr.xbrl.converter.utils.FileUtils;

@Service
public class CacheManagementServiceImpl
implements CacheManagementService {
    private static final Logger log = LoggerFactory.getLogger(CacheManagementServiceImpl.class);
    @PersistenceContext(unitName="cachePU")
    private EntityManager entityManager;
    @Autowired
    private ConfigProperties configProperties;
    @Autowired
    private NamespacesService namespacesService;

    @Transactional(value="cacheTransactionManager")
    public void clearCache() {
        log.info("Database clear started");
        Date start = new Date();
        this.entityManager.clear();
        this.entityManager.createNativeQuery("SET REFERENTIAL_INTEGRITY FALSE").executeUpdate();
        List tables = this.entityManager.createNativeQuery("SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES  where TABLE_SCHEMA='PUBLIC' AND TABLE_NAME != 'IMPORT_PROCESS' AND TABLE_NAME != 'PROCESS_INFO' ").getResultList();
        ArrayList processedTables = new ArrayList();
        tables.stream().forEach(tableName -> {
            this.entityManager.createNativeQuery("TRUNCATE TABLE " + tableName).executeUpdate();
            processedTables.add(tableName);
        });
        log.info("Truncated tables: " + Arrays.toString(processedTables.toArray()));
        List sequences = this.entityManager.createNativeQuery("SELECT SEQUENCE_NAME FROM INFORMATION_SCHEMA.SEQUENCES WHERE SEQUENCE_SCHEMA='PUBLIC'").getResultList();
        ArrayList processedSequences = new ArrayList();
        sequences.stream().forEach(seqName -> {
            this.entityManager.createNativeQuery("ALTER SEQUENCE " + seqName + " RESTART WITH 1 ").executeUpdate();
            processedSequences.add(seqName);
        });
        log.info("Restarted sequences: " + Arrays.toString(processedSequences.toArray()));
        this.entityManager.createNativeQuery("SET REFERENTIAL_INTEGRITY TRUE").executeUpdate();
        this.namespacesService.save(new ArrayList());
        log.info("Database cleaned in " + (new Date().getTime() - start.getTime()) + " msec");
    }

    public void clearInternalXbrlStorage() {
        Date start = new Date();
        String xbrlStorePath = FileUtils.relativePathToAbsolute((String)this.configProperties.getXbrlStorePath());
        if (StringUtils.isBlank((CharSequence)xbrlStorePath) || !Files.isDirectory(Paths.get(xbrlStorePath, new String[0]), new LinkOption[0])) {
            return;
        }
        System.out.println("CLEAN " + xbrlStorePath);
        Arrays.stream(new File(xbrlStorePath).listFiles()).forEach(File::delete);
        log.info("Local xbrl storage cleaned in " + (new Date().getTime() - start.getTime()) + " msec");
    }

    @Transactional(value="cacheTransactionManager")
    public void clearXbrlRepresentationAndRoles() {
        this.entityManager.clear();
        this.entityManager.createNativeQuery("SET REFERENTIAL_INTEGRITY FALSE").executeUpdate();
        log.info("Truncate XBRL representation and roles started");
        Date start = new Date();
        this.entityManager.createNativeQuery("TRUNCATE TABLE ASPECTNODEMEMBER").executeUpdate();
        this.entityManager.createNativeQuery("TRUNCATE TABLE FILTEROPENAXISVALUE").executeUpdate();
        this.entityManager.createNativeQuery("TRUNCATE TABLE XBRLROLEDIMENSION").executeUpdate();
        this.entityManager.createNativeQuery("TRUNCATE TABLE FILTEROPENAXIS").executeUpdate();
        this.entityManager.createNativeQuery("TRUNCATE TABLE XBRLREPORTROLE").executeUpdate();
        this.entityManager.createNativeQuery("TRUNCATE TABLE XBRLCONTEXT").executeUpdate();
        this.entityManager.createNativeQuery("TRUNCATE TABLE XBRLUNIT").executeUpdate();
        this.entityManager.createNativeQuery("TRUNCATE TABLE XBRLVALUE").executeUpdate();
        this.entityManager.createNativeQuery("TRUNCATE TABLE XBRLVALUEROLE").executeUpdate();
        this.entityManager.createNativeQuery("TRUNCATE TABLE XBRLFOOTNOTE").executeUpdate();
        this.entityManager.createNativeQuery("TRUNCATE TABLE PRESENTATIONCONCEPT").executeUpdate();
        this.entityManager.createNativeQuery("TRUNCATE TABLE XBRLFORMULA").executeUpdate();
        this.entityManager.createNativeQuery("TRUNCATE TABLE OPENAXISVALIDATIONRULE").executeUpdate();
        this.entityManager.createNativeQuery("SET REFERENTIAL_INTEGRITY TRUE").executeUpdate();
        log.info("Truncate XBRL representation and roles completed in " + (new Date().getTime() - start.getTime()) + " msec");
    }

    @Transactional(value="cacheTransactionManager")
    public void clearXbrlRepresentation() {
        this.entityManager.clear();
        this.entityManager.createNativeQuery("SET REFERENTIAL_INTEGRITY FALSE").executeUpdate();
        log.info("Truncate XBRL representation started");
        Date start = new Date();
        this.entityManager.createNativeQuery("TRUNCATE TABLE XBRLCONTEXT").executeUpdate();
        this.entityManager.createNativeQuery("TRUNCATE TABLE XBRLUNIT").executeUpdate();
        this.entityManager.createNativeQuery("TRUNCATE TABLE XBRLVALUE").executeUpdate();
        this.entityManager.createNativeQuery("TRUNCATE TABLE XBRLVALUEROLE").executeUpdate();
        this.entityManager.createNativeQuery("TRUNCATE TABLE XBRLFOOTNOTE").executeUpdate();
        this.entityManager.createNativeQuery("SET REFERENTIAL_INTEGRITY TRUE").executeUpdate();
        log.info("Truncate XBRL representation completed in " + (new Date().getTime() - start.getTime()) + " msec");
    }

    @Transactional(value="cacheTransactionManager")
    public void clearRoles() {
        this.entityManager.clear();
        log.info("Truncate XBRL roles started");
        Date start = new Date();
        this.entityManager.createNativeQuery("DELETE FROM ASPECTNODEMEMBER").executeUpdate();
        this.entityManager.createNativeQuery("DELETE FROM FILTEROPENAXISVALUE").executeUpdate();
        this.entityManager.createNativeQuery("DELETE FROM XBRLROLEDIMENSION").executeUpdate();
        this.entityManager.createNativeQuery("DELETE FROM FILTEROPENAXIS").executeUpdate();
        this.entityManager.createNativeQuery("DELETE FROM XBRLPDROLEPERIOD").executeUpdate();
        this.entityManager.createNativeQuery("DELETE FROM XBRLROLEPERIOD").executeUpdate();
        this.entityManager.createNativeQuery("DELETE FROM XBRLREPORTROLE").executeUpdate();
        this.entityManager.createNativeQuery("DELETE FROM XBRLFORMULA").executeUpdate();
        log.info("Truncate XBRL representation and roles completed in " + (new Date().getTime() - start.getTime()) + " msec");
    }
}

