/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.repository;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import ru.cbr.xbrl.converter.model.tableLinkBase.XbrlValueDTO;
import ru.cbr.xbrl.converter.model.xbrl_content.PeriodType;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValue;
import ru.cbr.xbrl.converter.model.xbrl_content.presentation_definition.XbrlValueRole;
import ru.cbr.xbrl.converter.model.xbrl_content.presentation_definition.XbrlValueRoleId;

@Repository
public interface XbrlValueRoleRepository
extends PagingAndSortingRepository<XbrlValueRole, XbrlValueRoleId>,
JpaRepository<XbrlValueRole, XbrlValueRoleId> {
    public List<XbrlValueRole> findByRoleSystemId(String var1);

    public XbrlValueRole findOneByRoleSystemIdAndGuid(String var1, String var2);

    @Query(value="SELECT r.id FROM XbrlValueRole r where r.roleSystemId = ?1 and r.guid = ?2 ")
    public Long findIdByRoleSystemIdAndGuid(String var1, String var2);

    public void deleteAllByGuid(String var1);

    public void deleteAllByXbrlValue(XbrlValue var1);

    public List<XbrlValueRole> findAllByXbrlValue(XbrlValue var1);

    public List<XbrlValueRole> findAllByGuid(String var1);

    @Query(value="SELECT r.roleSystemId FROM XbrlValueRole r, XbrlValue v, XbrlContext c where r.guid = v.guid and c.xbrlContextId.contextId = v.xbrlValueId.xbrlContextId and c.dimensions like CONCAT('%', :dimension, '%') group by r.roleSystemId")
    public Set<String> findRolesByDimension(@Param(value="dimension") String var1);

    @Query(value="SELECT r.roleSystemId FROM XbrlValueRole r, XbrlValue v, XbrlContext c where r.guid = v.guid and c.xbrlContextId.contextId = v.xbrlValueId.xbrlContextId and c.periodType = ?1 and c.startDate = ?2 and c.endDate = ?3")
    public Set<String> findRolesByPeriodDuration(PeriodType var1, Date var2, Date var3);

    @Query(value="SELECT r.roleSystemId FROM XbrlValueRole r, XbrlValue v, XbrlContext c where r.guid = v.guid and c.xbrlContextId.contextId = v.xbrlValueId.xbrlContextId and c.periodType = ?1 and c.instantDate = ?2")
    public Set<String> findRolesByPeriodInstant(PeriodType var1, Date var2);

    @Query(value="SELECT new ru.cbr.xbrl.converter.model.tableLinkBase.XbrlValueDTO(r.roleSystemId, v.xbrlValueId.elementLabel, c.dimensions, c.periodType, c.instantDate, c.startDate, c.endDate, v.xbrlValueId.xbrlReportId, v.xbrlValueId.xbrlContextId, v.value, v.precision, v.decimals, v.xbrlUnit) FROM XbrlValueRole r, XbrlValue v, XbrlContext c where r.guid = v.guid and c.xbrlContextId.contextId = v.xbrlValueId.xbrlContextId and r.roleSystemId = ?1")
    public List<XbrlValueDTO> findbyPresentationDefinitionRole(String var1);
}

