/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.repository;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import ru.cbr.xbrl.converter.model.XbrlValueContextCounter;
import ru.cbr.xbrl.converter.model.tableLinkBase.XbrlFootnoteDTO;
import ru.cbr.xbrl.converter.model.tableLinkBase.XbrlValueDTO;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValue;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValueId;
import ru.cbr.xbrl.converter.service.XbrlContectValueDTO;

@Repository
public interface XbrlValueRepository
extends PagingAndSortingRepository<XbrlValue, XbrlValueId>,
JpaRepository<XbrlValue, XbrlValueId> {
    @Query(value="select v from XbrlValue v")
    public Stream<XbrlValue> streamAll();

    public XbrlValue findByGuid(String var1);

    public Long countByXbrlValueIdXbrlContextId(String var1);

    public Optional<XbrlValue> findByAspectDataJson(byte[] var1);

    public List<XbrlValue> findByContextIdHash(String var1);

    public List<XbrlValue> findByXbrlValueIdXbrlContextId(String var1);

    @Query(value="select new ru.cbr.xbrl.converter.service.XbrlContectValueDTO(v.value, c.dimensionsHash, c.dimensionsOpenHash, c.instantDate, c.startDate, c.endDate, v.decimals, v.precision, v.xbrlUnit, v.xbrlValueId.elementLabel, v.xbrlValueId.xbrlReportId, v.xbrlValueId.xbrlContextId) from XbrlValue v, XbrlContext c where v.xbrlValueId.xbrlContextId = c.xbrlContextId.contextId and v.xbrlValueId.elementLabel = :elementLabel")
    public List<XbrlContectValueDTO> findByXbrlValueIdElementLabel(@Param(value="elementLabel") String var1);

    @Query(value="select c.dimensionsHash from XbrlValue v, XbrlContext c where v.xbrlValueId.xbrlContextId = c.xbrlContextId.contextId and v.xbrlValueId.elementLabel = :elementLabel")
    public List<String> findHashByXbrlValueIdElementLabel(@Param(value="elementLabel") String var1);

    @Query(value="select new ru.cbr.xbrl.converter.model.tableLinkBase.XbrlFootnoteDTO(f.elementLabel, f.xbrlReportId, f.context, count(f.content)) from XbrlFootnote f group by f.elementLabel, f.xbrlReportId, f.context having count(f.content) > 0")
    public List<XbrlFootnoteDTO> findFootnoteCountByXbrlValueId();

    public List<XbrlValue> findByContextIdHashAndXbrlValueIdXbrlReportId(String var1, String var2);

    public List<XbrlValue> findByContextIdHashAndXbrlValueIdXbrlReportIdAndXbrlValueIdElementLabel(String var1, Long var2, String var3);

    public List<XbrlValue> findById(String var1);

    @Query(value="SELECT v FROM XbrlValue v WHERE v.elementName = ?1 AND v.elementUri = ?2 AND v.xbrlValueId.xbrlContextId = ?3 AND v.xbrlValueId.xbrlReportId = ?4")
    public List<XbrlValue> findByElementNameAndElementUriAndContextAndReportId(String var1, String var2, String var3, Long var4);

    @Modifying
    @Query(value="UPDATE XbrlValue v set v.xbrlValueId.xbrlContextId = ?1 WHERE v.xbrlValueId.elementLabel = ?2 AND v.xbrlValueId.xbrlReportId = ?3 AND v.xbrlValueId.xbrlContextId = ?4")
    public void updateContextConnection(String var1, String var2, Long var3, String var4);

    @Modifying
    @Query(value="delete from XbrlValue v where v.xbrlValueId.xbrlContextId = ?1 AND v.xbrlValueId.xbrlReportId = ?2")
    public void deleteAllByContextIdAndXbrlReportId(String var1, Long var2);

    public List<XbrlValue> findByXbrlValueIdXbrlContextIdAndXbrlValueIdElementLabelAndElementName(String var1, String var2, String var3);

    @Query(value="select new ru.cbr.xbrl.converter.model.tableLinkBase.XbrlValueDTO(v.xbrlValueId.elementLabel, c.dimensions, c.periodType, c.instantDate, c.startDate, c.endDate, v.xbrlValueId.xbrlReportId, v.xbrlValueId.xbrlContextId, v.value) from XbrlValue v, XbrlContext c where v.xbrlValueId.xbrlContextId = c.xbrlContextId.contextId and v.xbrlValueId.xbrlContextId = :xbrlContextId and v.xbrlValueId.elementLabel = :elementLabel and v.elementName = :elementName")
    public List<XbrlValueDTO> findAll(@Param(value="xbrlContextId") String var1, @Param(value="elementLabel") String var2, @Param(value="elementName") String var3);

    @Query(value="select new ru.cbr.xbrl.converter.model.tableLinkBase.XbrlValueDTO(v.xbrlValueId.elementLabel, c.dimensions, c.periodType, c.instantDate, c.startDate, c.endDate, v.xbrlValueId.xbrlReportId, v.xbrlValueId.xbrlContextId, v.value) from XbrlValue v, XbrlContext c where v.xbrlValueId.xbrlContextId = c.xbrlContextId.contextId and v.value = ?1")
    public List<XbrlValueDTO> findAllByValue(String var1);

    @Query(value="select case when exists (select 1 from xbrlvalue) then true else false end", nativeQuery=true)
    public boolean exists();

    @Query(value="select new ru.cbr.xbrl.converter.model.XbrlValueContextCounter(v.xbrlValueId.xbrlContextId, count(v.xbrlValueId.xbrlContextId)) from XbrlValue v group by v.xbrlValueId.xbrlContextId")
    public List<XbrlValueContextCounter> findValueCountGroupByXbrlContextId();
}

