/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.multitasking;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.multitasking.AbstractProcess;
import ru.cbr.xbrl.converter.multitasking.ProcessState;
import ru.cbr.xbrl.converter.multitasking.TestProcess;

@Service
public class ProcessService {
    private static List<AbstractProcess> processes = new ArrayList();
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    static synchronized void registerProcess(AbstractProcess process) {
        processes.add(process);
    }

    static synchronized void unregisterProcess(AbstractProcess process) {
        processes.remove(process);
    }

    public List<ProcessState> getProcessList() {
        return processes.stream().map(AbstractProcess::getProcessState).collect(Collectors.toList());
    }

    public void stopProcessByThreadId(Long threadId) {
        AbstractProcess found = null;
        for (AbstractProcess process : processes) {
            if (!threadId.equals(process.getProcessState().getThreadId())) continue;
            found = process;
            break;
        }
        if (found == null) {
            throw new RuntimeException("process not found by thread id " + threadId);
        }
        found.stop();
    }

    public TestProcess validateByXSD(String fileName) {
        TestProcess testProcess = new TestProcess(this.applicationEventPublisher, fileName);
        testProcess.start();
        return testProcess;
    }
}

