/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.model.xbrl_content;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;

/*
 * Exception performing whole class analysis ignored.
 */
public class XbrlContextDimension
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(XbrlContextDimension.class);
    public static final String CONST_GENERATED_OPEN_AXIS_DOMAIN_VALUE = "ru.cbr.xbrl.anketa.openAxis.domainValue";
    private String dimension;
    private String member;
    private DimensionType dimensionType;
    private String domain;
    private String domainValue;
    private String label;

    public static List<XbrlContextDimension> removeDuplicates(List<XbrlContextDimension> xbrlContextDimensions) {
        HashMap map = new HashMap();
        xbrlContextDimensions.stream().forEach(d -> map.put(d != null ? d.getDimension() : null, d));
        List<XbrlContextDimension> result = map.keySet().stream().map(k -> (XbrlContextDimension)map.get(k)).collect(Collectors.toList());
        return result;
    }

    public static Stream<XbrlContextDimension> removeDuplicatesAsStream(Stream<XbrlContextDimension> xbrlContextDimensions) {
        HashMap map = new HashMap();
        xbrlContextDimensions.forEach(d -> map.put(d != null ? d.getDimension() : null, d));
        return map.keySet().stream().map(map::get);
    }

    public XbrlContextDimension(String dimension, String member) {
        this.dimension = dimension;
        this.member = member;
        this.setDimensionType(DimensionType.EXPLICIT_MEMBER);
    }

    public XbrlContextDimension(String dimension, String domain, String domainValue) {
        this.dimension = dimension;
        this.domain = domain;
        this.domainValue = domainValue;
        this.setDimensionType(DimensionType.TYPED_MEMBER);
    }

    public static String dimensionsToString(List<XbrlContextDimension> xbrlContextDimensions) {
        Function<XbrlContextDimension, String> dimensionToString = d -> {
            if (d == null) {
                return null;
            }
            if (d.getDimensionType() == DimensionType.EXPLICIT_MEMBER) {
                return d.getDimension().trim() + " -> " + d.getMember().trim();
            }
            if (d.getDimensionType() == DimensionType.TYPED_MEMBER) {
                String domain = d.getDomain() != null ? d.getDomain().trim() : "";
                String domainValue = d.domainValue != null ? d.getDomainValue() : "";
                return d.getDimension().trim() + " -> " + domain + " -> " + domainValue;
            }
            throw new IllegalArgumentException("Unsupported dimensionType: " + d.getDimensionType());
        };
        return XbrlContextDimension.removeDuplicates(xbrlContextDimensions).stream().map(dimensionToString).filter(s -> s != null).sorted().collect(Collectors.joining("; "));
    }

    public static List<XbrlContextDimension> dimensionsFromString(String dimensionsString) {
        String[] dimPairs = dimensionsString.split(";");
        List<XbrlContextDimension> dimensions = Arrays.asList(dimPairs).stream().map(p -> {
            String[] parts = p.split("->");
            XbrlContextDimension dimAspect = new XbrlContextDimension();
            if (parts.length == 2) {
                String dimint = StringUtils.trim((String)parts[0]);
                String memint = StringUtils.trim((String)parts[1]);
                dimAspect.setDimension(dimint);
                dimAspect.setMember(memint);
                dimAspect.setDimensionType(DimensionType.EXPLICIT_MEMBER);
            } else if (parts.length == 3) {
                String dimint = StringUtils.trim((String)parts[0]);
                String domain = StringUtils.trim((String)parts[1]);
                String memint = StringUtils.trim((String)parts[2]);
                dimAspect.setDimension(dimint);
                dimAspect.setDomain(domain);
                dimAspect.setDimensionType(DimensionType.TYPED_MEMBER);
                dimAspect.setDomainValue(memint);
            }
            return dimAspect;
        }).collect(Collectors.toList());
        return dimensions;
    }

    public static String buildOpenHashString(Stream<AspectData> dimensions, Map<String, String> dimensionsDefault, Set<String> explicitAspectNodeSet) {
        Function<XbrlContextDimension, String> dimensionToString = d -> {
            if (d == null) {
                return null;
            }
            if (d.getDimensionType() == DimensionType.EXPLICIT_MEMBER) {
                if (explicitAspectNodeSet != null && explicitAspectNodeSet.contains(d.getDimension())) {
                    return d.getDimension().trim() + " -> " + "ru.cbr.xbrl.anketa.openAxis.domainValue";
                }
                return d.getDimension().trim() + " -> " + d.getMember().trim();
            }
            if (d.getDimensionType() == DimensionType.TYPED_MEMBER) {
                String domain = d.getDomain() != null ? d.getDomain().trim() : "";
                return d.getDimension().trim() + " -> " + domain + " -> " + "ru.cbr.xbrl.anketa.openAxis.domainValue";
            }
            throw new IllegalArgumentException("Unsupported dimensionType: " + d.getDimensionType());
        };
        return dimensions.filter(d -> !dimensionsDefault.containsKey(d.getAspect()) || !((String)dimensionsDefault.get(d.getAspect())).equals(d.getAspectValue())).map(d -> {
            if (d.getDimensionType() == DimensionType.TYPED_MEMBER) {
                return new XbrlContextDimension(d.getAspect(), d.getDomain(), d.getAspectValue());
            }
            return new XbrlContextDimension(d.getAspect(), d.getAspectValue());
        }).collect(Collectors.toMap(XbrlContextDimension::getDimension, Function.identity(), (a, b) -> b)).values().stream().map(dimensionToString).filter(Objects::nonNull).sorted().collect(Collectors.joining("; "));
    }

    public AspectData toAspectData() {
        AspectData aspectData = new AspectData();
        aspectData.setType(AspectType.DIMENSION);
        aspectData.setDimensionType(this.getDimensionType());
        aspectData.setAspect(this.getDimension());
        if (this.getDimensionType().equals((Object)DimensionType.EXPLICIT_MEMBER)) {
            aspectData.setAspectValue(this.getMember());
        } else if (this.getDimensionType().equals((Object)DimensionType.TYPED_MEMBER)) {
            aspectData.setDomain(this.getDomain());
            aspectData.setAspectValue(this.getDomainValue());
        }
        return aspectData;
    }

    public static String dimensionToHash(List<XbrlContextDimension> xbrlContextDimensions) {
        return DigestUtils.md5Hex((String)XbrlContextDimension.dimensionsToString(xbrlContextDimensions));
    }

    public static String dimintsToString(List<XbrlContextDimension> xbrlContextDimensions) {
        return xbrlContextDimensions.stream().map(d -> d.getDimension()).sorted().collect(Collectors.joining(";"));
    }

    public static List<AspectData> removeDefaultDimensionsFromStream(Stream<AspectData> dimensions, Map<String, String> dimensionsDefault) {
        return dimensions.filter(d -> !dimensionsDefault.containsKey(d.getAspect()) || !((String)dimensionsDefault.get(d.getAspect())).equals(d.getAspectValue())).collect(Collectors.toList());
    }

    public static List<AspectData> removeDefaultDimensions(List<AspectData> dimensions, Map<String, String> dimensionsDefault) {
        return XbrlContextDimension.removeDefaultDimensionsByStream(dimensions.stream(), dimensionsDefault).collect(Collectors.toList());
    }

    public static Stream<AspectData> removeDefaultDimensionsByStream(Stream<AspectData> dimensions, Map<String, String> dimensionsDefault) {
        return dimensions.filter(d -> !dimensionsDefault.containsKey(d.getAspect()) || !((String)dimensionsDefault.get(d.getAspect())).equals(d.getAspectValue()));
    }

    public static List<AspectData> removeNonDefaultDimensions(List<AspectData> dimensions, Map<String, String> dimensionsDefault) {
        return dimensions.stream().filter(d -> !d.getType().equals((Object)AspectType.DIMENSION) || dimensionsDefault.containsKey(d.getAspect()) && ((String)dimensionsDefault.get(d.getAspect())).equals(d.getAspectValue())).collect(Collectors.toList());
    }

    public static List<XbrlContextDimension> buildFromAspectDataList(List<AspectData> dimensions) {
        return XbrlContextDimension.buildFromAspectDataListAsStream(dimensions).collect(Collectors.toList());
    }

    public static Stream<XbrlContextDimension> buildFromAspectDataListAsStream(List<AspectData> dimensions) {
        return dimensions.stream().map(d -> {
            if (d.getDimensionType() == DimensionType.TYPED_MEMBER) {
                return new XbrlContextDimension(d.getAspect(), d.getDomain(), d.getAspectValue());
            }
            return new XbrlContextDimension(d.getAspect(), d.getAspectValue());
        });
    }

    public static List<XbrlContextDimension> clearDomainsFromDimensions(List<XbrlContextDimension> xbrlContextDimensions) {
        return xbrlContextDimensions.stream().map(d -> {
            if (d.getDimensionType().equals((Object)DimensionType.EXPLICIT_MEMBER)) {
                return d;
            }
            XbrlContextDimension clone = (XbrlContextDimension)SerializationUtils.clone((Serializable)d);
            clone.setDomain(null);
            clone.setDomainValue(null);
            return clone;
        }).collect(Collectors.toList());
    }

    public static String dimensionsOpenString(Stream<XbrlContextDimension> xbrlContextDimensions, Set<String> explicitAspectNodeSet) {
        Function<XbrlContextDimension, String> dimensionToString = d -> {
            if (d == null) {
                return null;
            }
            if (d.getDimensionType() == DimensionType.EXPLICIT_MEMBER) {
                if (explicitAspectNodeSet != null && explicitAspectNodeSet.contains(d.getDimension())) {
                    return d.getDimension().trim() + " -> " + "ru.cbr.xbrl.anketa.openAxis.domainValue";
                }
                return d.getDimension().trim() + " -> " + d.getMember().trim();
            }
            if (d.getDimensionType() == DimensionType.TYPED_MEMBER) {
                String domain = d.getDomain() != null ? d.getDomain().trim() : "";
                return d.getDimension().trim() + " -> " + domain + " -> " + "ru.cbr.xbrl.anketa.openAxis.domainValue";
            }
            throw new IllegalArgumentException("Unsupported dimensionType: " + d.getDimensionType());
        };
        return XbrlContextDimension.removeDuplicatesAsStream(xbrlContextDimensions).map(dimensionToString).filter(s -> s != null).sorted().collect(Collectors.joining("; "));
    }

    public static String dimensionsOpenToHash(List<XbrlContextDimension> xbrlContextDimensions, Set<String> explicitAspectNodeSet) {
        return XbrlContextDimension.dimensionsOpenToHashByStream(xbrlContextDimensions.stream(), explicitAspectNodeSet);
    }

    public static String dimensionsOpenToHashByStream(Stream<XbrlContextDimension> xbrlContextDimensions, Set<String> explicitAspectNodeSet) {
        return DigestUtils.md5Hex((String)XbrlContextDimension.dimensionsOpenString(xbrlContextDimensions, explicitAspectNodeSet));
    }

    public boolean equalsWithAspectData(AspectData aspectData) {
        if (this.getDimensionType() == DimensionType.TYPED_MEMBER) {
            return this.getDimension().equals(aspectData.getAspect()) && this.getDomainValue().equals(aspectData.getAspectValue());
        }
        return this.getDimension().equals(aspectData.getAspect()) && this.getMember().equals(aspectData.getAspectValue());
    }

    public static String buildScenario(List<XbrlContextDimension> xbrlContextDimensions) {
        Function<XbrlContextDimension, String> buildScenarioFunction = dim -> {
            if (dim.getDimensionType() == DimensionType.EXPLICIT_MEMBER) {
                String template = "<xbrldi:explicitMember dimension=\"%s\">%s</xbrldi:explicitMember>";
                return String.format(template, dim.getDimension(), dim.getMember());
            }
            if (dim.getDimensionType() == DimensionType.TYPED_MEMBER) {
                String template = "<xbrldi:typedMember dimension=\"%s\"><%s>%s</%2$s></xbrldi:typedMember>";
                return String.format(template, dim.getDimension(), dim.getDomain(), StringEscapeUtils.escapeXml11((String)dim.getDomainValue()));
            }
            throw new IllegalArgumentException("Unsupported dimensionType");
        };
        return xbrlContextDimensions.stream().map(buildScenarioFunction).collect(Collectors.joining());
    }

    public String getDimension() {
        return this.dimension;
    }

    public String getMember() {
        return this.member;
    }

    public DimensionType getDimensionType() {
        return this.dimensionType;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getDomainValue() {
        return this.domainValue;
    }

    public String getLabel() {
        return this.label;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public void setMember(String member) {
        this.member = member;
    }

    public void setDimensionType(DimensionType dimensionType) {
        this.dimensionType = dimensionType;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setDomainValue(String domainValue) {
        this.domainValue = domainValue;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XbrlContextDimension)) {
            return false;
        }
        XbrlContextDimension other = (XbrlContextDimension)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$dimension = this.getDimension();
        String other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) {
            return false;
        }
        String this$member = this.getMember();
        String other$member = other.getMember();
        if (this$member == null ? other$member != null : !this$member.equals(other$member)) {
            return false;
        }
        DimensionType this$dimensionType = this.getDimensionType();
        DimensionType other$dimensionType = other.getDimensionType();
        if (this$dimensionType == null ? other$dimensionType != null : !this$dimensionType.equals(other$dimensionType)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        String this$domainValue = this.getDomainValue();
        String other$domainValue = other.getDomainValue();
        if (this$domainValue == null ? other$domainValue != null : !this$domainValue.equals(other$domainValue)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        return !(this$label == null ? other$label != null : !this$label.equals(other$label));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XbrlContextDimension;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : $dimension.hashCode());
        String $member = this.getMember();
        result = result * 59 + ($member == null ? 43 : $member.hashCode());
        DimensionType $dimensionType = this.getDimensionType();
        result = result * 59 + ($dimensionType == null ? 43 : $dimensionType.hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        String $domainValue = this.getDomainValue();
        result = result * 59 + ($domainValue == null ? 43 : $domainValue.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        return result;
    }

    public String toString() {
        return "XbrlContextDimension(dimension=" + this.getDimension() + ", member=" + this.getMember() + ", dimensionType=" + this.getDimensionType() + ", domain=" + this.getDomain() + ", domainValue=" + this.getDomainValue() + ", label=" + this.getLabel() + ")";
    }

    @ConstructorProperties(value={"dimension", "member", "dimensionType", "domain", "domainValue", "label"})
    public XbrlContextDimension(String dimension, String member, DimensionType dimensionType, String domain, String domainValue, String label) {
        this.dimension = dimension;
        this.member = member;
        this.dimensionType = dimensionType;
        this.domain = domain;
        this.domainValue = domainValue;
        this.label = label;
    }

    public XbrlContextDimension() {
    }
}

