/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.model.xbrl_content;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.exception.XbrlImportException;
import ru.cbr.xbrl.converter.model.xbrl_content.PeriodType;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextId;
import ru.cbr.xbrl.converter.service.import_export.PeriodDates;
import ru.cbr.xbrl.converter.utils.GzipUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;

@Entity
@Table(indexes={@Index(name="idx_dimensions_hash", columnList="dimensionsHash"), @Index(name="idx_dimensions_hash_instant", columnList="dimensionsHash,instantDate"), @Index(name="idx_dimensions_hash_duration", columnList="dimensionsHash,startDate,endDate"), @Index(name="idx_periodtype_dimensionshash_instant", columnList="periodType,dimensionsHash,instantDate"), @Index(name="idx_periodtype_dimensionshash_duration", columnList="periodType,dimensionsHash,startDate,endDate"), @Index(name="idx_periodtype_instant", columnList="periodType,instantDate"), @Index(name="idx_periodtype_duration", columnList="periodType,startDate,endDate"), @Index(name="idx_xbrlcontext_contextid", columnList="contextId")})
public class XbrlContext {
    private static final Logger log = LoggerFactory.getLogger(XbrlContext.class);
    private static final int ROW_LENGTH = 6;
    private static DateTimeFormatter periodDateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    @EmbeddedId
    private XbrlContextId xbrlContextId = new XbrlContextId();
    @Enumerated(value=EnumType.STRING)
    private PeriodType periodType;
    private Date instantDate;
    private Date startDate;
    private Date endDate;
    private String identifier;
    private String scheme;
    @Lob
    private String segment;
    @Lob
    private String scenario;
    @XmlTransient
    @Transient
    private List<XbrlContextDimension> xbrlContextDimensions = new ArrayList();
    @Lob
    private String dimensions;
    private String dimensionsHash;
    private String dimensionsOpenHash;
    @Lob
    @JsonIgnore
    @XmlTransient
    private byte[] aspectDataJson;
    @Transient
    private List<AspectData> aspectDataList;

    public XbrlContext(XbrlContext that) {
        this.xbrlContextId = new XbrlContextId("a" + UUID.randomUUID().toString(), that.getXbrlContextId().getXbrlReportId());
        this.periodType = that.periodType;
        this.instantDate = that.instantDate;
        this.startDate = that.startDate;
        this.endDate = that.endDate;
        this.identifier = that.identifier;
        this.scheme = that.scheme;
        this.segment = that.segment;
        this.scenario = that.scenario;
        this.dimensions = that.dimensions;
        this.dimensionsHash = that.dimensionsHash;
        this.dimensionsOpenHash = that.dimensionsOpenHash;
        this.aspectDataJson = that.aspectDataJson;
    }

    public XbrlContext(XbrlContext that, PeriodDates newPeriodDates) {
        this(that);
        this.setPeriod(newPeriodDates);
    }

    public void unpackAspectDataList() {
        try {
            String json = GzipUtils.decompressString((byte[])this.aspectDataJson);
            ObjectMapper objectMapper = new ObjectMapper();
            List aspectDataList = (List)objectMapper.readValue((Reader)new StringReader(json), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            this.setAspectDataList(aspectDataList);
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new RuntimeException("Unpack value aspectData error");
        }
    }

    public void packAspectDataList() {
        ObjectMapper objectMapper = new ObjectMapper();
        String aspectDataList = null;
        try {
            aspectDataList = objectMapper.writeValueAsString((Object)this.getAspectDataList());
            this.setAspectDataJson(GzipUtils.compressString((String)aspectDataList));
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new RuntimeException("Unpack value aspectData error");
        }
    }

    public void rebuildDimensions(Set<String> explicitAspectNodeSet) {
        this.dimensions = XbrlContextDimension.dimensionsToString((List)this.xbrlContextDimensions);
        this.dimensionsHash = XbrlContextDimension.dimensionToHash((List)this.xbrlContextDimensions);
        this.dimensionsOpenHash = XbrlContextDimension.dimensionsOpenToHash((List)this.xbrlContextDimensions, explicitAspectNodeSet);
    }

    @Transient
    public String getPeriod() {
        if (this.periodType == null) {
            return null;
        }
        if (this.periodType.equals((Object)PeriodType.INSTANT)) {
            return periodDateFormatter.print(this.instantDate.getTime());
        }
        return periodDateFormatter.print(this.startDate.getTime()) + ", " + periodDateFormatter.print(this.endDate.getTime());
    }

    @Transient
    public void setPeriod(String periodStr) throws XbrlImportException {
        if (!StringUtils.isBlank((CharSequence)periodStr)) {
            if (periodStr.contains(",")) {
                String[] splitted = periodStr.split("\\s*,\\s*");
                this.startDate = this.parseDate(splitted[0]);
                this.endDate = this.parseDate(splitted[1]);
                this.periodType = PeriodType.DURATION;
            } else {
                this.instantDate = this.parseDate(periodStr);
                this.periodType = PeriodType.INSTANT;
            }
        }
    }

    public Date parseDate(String stringDate) throws XbrlImportException {
        if (StringUtils.isBlank((CharSequence)stringDate)) {
            return null;
        }
        DateTime dt = periodDateFormatter.parseDateTime(stringDate);
        return dt.toDate();
    }

    @Transient
    public PeriodDates getPeriodDates() {
        if (this.periodType.equals((Object)PeriodType.INSTANT)) {
            return PeriodDates.buildInstant((Date)this.instantDate);
        }
        if (this.periodType.equals((Object)PeriodType.DURATION)) {
            return PeriodDates.buildDuration((Date)this.startDate, (Date)this.endDate);
        }
        throw new IllegalArgumentException("Unsupported periodType: " + this.periodType);
    }

    public void buildAspectData() {
        AspectData periodAspect = new AspectData();
        periodAspect.setAspect("period");
        periodAspect.setAspectValue(this.getPeriodDates().formatDate());
        periodAspect.setType(AspectType.PERIOD);
        periodAspect.setConceptPeriodType(this.getPeriodType());
        this.aspectDataList = new ArrayList();
        this.aspectDataList.add(periodAspect);
        this.xbrlContextDimensions.forEach(xbrlContextDimension -> {
            AspectData dimAspect = new AspectData();
            dimAspect.setAspect(xbrlContextDimension.getDimension());
            DimensionType dimensionType = xbrlContextDimension.getDimensionType();
            if (dimensionType.equals((Object)DimensionType.TYPED_MEMBER)) {
                dimAspect.setAspectValue(xbrlContextDimension.getDomainValue());
            } else if (dimensionType.equals((Object)DimensionType.EXPLICIT_MEMBER)) {
                dimAspect.setAspectValue(xbrlContextDimension.getMember());
            }
            dimAspect.setType(AspectType.DIMENSION);
            dimAspect.setDomain(xbrlContextDimension.getDomain());
            dimAspect.setDimensionType(dimensionType);
            dimAspect.setLabel(xbrlContextDimension.getLabel());
            this.aspectDataList.add(dimAspect);
        });
        this.packAspectDataList();
    }

    public boolean hasEmptyDomainMember() {
        return this.xbrlContextDimensions.stream().filter(d -> d.getDimensionType().equals((Object)DimensionType.TYPED_MEMBER)).anyMatch(d -> StringUtils.isBlank((CharSequence)d.getDomainValue()));
    }

    public void setPeriod(PeriodDates periodDates) {
        if (periodDates.getPeriodType() == PeriodType.DURATION) {
            this.setStartDate(periodDates.getStartDate());
            this.setEndDate(periodDates.getEndDate());
        } else if (periodDates.getPeriodType() == PeriodType.INSTANT) {
            this.setInstantDate(periodDates.getInstantDate());
        }
    }

    @JsonIgnore
    public Set<String> getDimensionsSet() {
        return XbrlContextDimension.dimensionsFromString((String)this.getDimensions()).stream().map(XbrlContextDimension::getDimension).collect(Collectors.toSet());
    }

    @JsonIgnore
    public String buildPeriodAndDimensionsHash() {
        return this.getPeriodDates().formatDate() + ";" + this.dimensionsHash;
    }

    @JsonIgnore
    public String getXbrlContextIdContextId() {
        return this.xbrlContextId != null ? this.xbrlContextId.getContextId() : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XbrlContext that = (XbrlContext)o;
        if (!this.xbrlContextId.equals((Object)that.xbrlContextId)) {
            return false;
        }
        if (this.dimensionsHash != null ? !this.dimensionsHash.equals(that.dimensionsHash) : that.dimensionsHash != null) {
            return false;
        }
        return this.dimensionsOpenHash != null ? this.dimensionsOpenHash.equals(that.dimensionsOpenHash) : that.dimensionsOpenHash == null;
    }

    public int hashCode() {
        int result = this.xbrlContextId.hashCode();
        result = 31 * result + (this.dimensionsHash != null ? this.dimensionsHash.hashCode() : 0);
        result = 31 * result + (this.dimensionsOpenHash != null ? this.dimensionsOpenHash.hashCode() : 0);
        return result;
    }

    public XbrlContextId getXbrlContextId() {
        return this.xbrlContextId;
    }

    public PeriodType getPeriodType() {
        return this.periodType;
    }

    public Date getInstantDate() {
        return this.instantDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getSegment() {
        return this.segment;
    }

    public String getScenario() {
        return this.scenario;
    }

    public List<XbrlContextDimension> getXbrlContextDimensions() {
        return this.xbrlContextDimensions;
    }

    public String getDimensions() {
        return this.dimensions;
    }

    public String getDimensionsHash() {
        return this.dimensionsHash;
    }

    public String getDimensionsOpenHash() {
        return this.dimensionsOpenHash;
    }

    public byte[] getAspectDataJson() {
        return this.aspectDataJson;
    }

    public List<AspectData> getAspectDataList() {
        return this.aspectDataList;
    }

    public void setXbrlContextId(XbrlContextId xbrlContextId) {
        this.xbrlContextId = xbrlContextId;
    }

    public void setPeriodType(PeriodType periodType) {
        this.periodType = periodType;
    }

    public void setInstantDate(Date instantDate) {
        this.instantDate = instantDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setSegment(String segment) {
        this.segment = segment;
    }

    public void setScenario(String scenario) {
        this.scenario = scenario;
    }

    public void setXbrlContextDimensions(List<XbrlContextDimension> xbrlContextDimensions) {
        this.xbrlContextDimensions = xbrlContextDimensions;
    }

    public void setDimensions(String dimensions) {
        this.dimensions = dimensions;
    }

    public void setDimensionsHash(String dimensionsHash) {
        this.dimensionsHash = dimensionsHash;
    }

    public void setDimensionsOpenHash(String dimensionsOpenHash) {
        this.dimensionsOpenHash = dimensionsOpenHash;
    }

    public void setAspectDataJson(byte[] aspectDataJson) {
        this.aspectDataJson = aspectDataJson;
    }

    public void setAspectDataList(List<AspectData> aspectDataList) {
        this.aspectDataList = aspectDataList;
    }

    public String toString() {
        return "XbrlContext(xbrlContextId=" + this.getXbrlContextId() + ", periodType=" + this.getPeriodType() + ", instantDate=" + this.getInstantDate() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", identifier=" + this.getIdentifier() + ", scheme=" + this.getScheme() + ", segment=" + this.getSegment() + ", scenario=" + this.getScenario() + ", xbrlContextDimensions=" + this.getXbrlContextDimensions() + ", dimensions=" + this.getDimensions() + ", dimensionsHash=" + this.getDimensionsHash() + ", dimensionsOpenHash=" + this.getDimensionsOpenHash() + ", aspectDataJson=" + Arrays.toString(this.getAspectDataJson()) + ", aspectDataList=" + this.getAspectDataList() + ")";
    }

    public XbrlContext() {
    }
}

