/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.model.tableLinkBase;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ru.cbr.xbrl.converter.model.enums.AxisType;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterAxis;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxisValue;
import ru.cbr.xbrl.converter.model.tableLinkBase.XbrlRoleDimension;

@Entity
@Table(indexes={@Index(name="idx_filter_open_axis_system_id", columnList="systemId")})
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class FilterOpenAxis
implements FilterAxis {
    @Id
    @GeneratedValue
    private Long id;
    private String systemId;
    private String domain;
    private String title;
    @JsonIgnore
    @OneToMany(fetch=FetchType.LAZY, mappedBy="filterOpenAxis", cascade={CascadeType.ALL})
    private List<XbrlRoleDimension> xbrlRoleDimensionList = new ArrayList();
    @JsonManagedReference
    @OneToMany(fetch=FetchType.LAZY, mappedBy="filterOpenAxis", cascade={CascadeType.ALL})
    private List<FilterOpenAxisValue> axisMemberList = new LinkedList();
    @Transient
    private final AxisType axisType = AxisType.OPEN;

    public Optional<FilterOpenAxisValue> findValue(String value) {
        return this.axisMemberList.stream().filter(it -> it.getValue().equals(value)).findFirst();
    }

    public int compareTo(Object o) {
        if (o instanceof FilterAxis) {
            return this.title.compareTo(((FilterAxis)o).getTitle());
        }
        return -1;
    }

    public Long getId() {
        return this.id;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getTitle() {
        return this.title;
    }

    public List<XbrlRoleDimension> getXbrlRoleDimensionList() {
        return this.xbrlRoleDimensionList;
    }

    public List<FilterOpenAxisValue> getAxisMemberList() {
        return this.axisMemberList;
    }

    public AxisType getAxisType() {
        return this.axisType;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setXbrlRoleDimensionList(List<XbrlRoleDimension> xbrlRoleDimensionList) {
        this.xbrlRoleDimensionList = xbrlRoleDimensionList;
    }

    public void setAxisMemberList(List<FilterOpenAxisValue> axisMemberList) {
        this.axisMemberList = axisMemberList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilterOpenAxis)) {
            return false;
        }
        FilterOpenAxis other = (FilterOpenAxis)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$systemId = this.getSystemId();
        String other$systemId = other.getSystemId();
        if (this$systemId == null ? other$systemId != null : !this$systemId.equals(other$systemId)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        List this$xbrlRoleDimensionList = this.getXbrlRoleDimensionList();
        List other$xbrlRoleDimensionList = other.getXbrlRoleDimensionList();
        if (this$xbrlRoleDimensionList == null ? other$xbrlRoleDimensionList != null : !((Object)this$xbrlRoleDimensionList).equals(other$xbrlRoleDimensionList)) {
            return false;
        }
        List this$axisMemberList = this.getAxisMemberList();
        List other$axisMemberList = other.getAxisMemberList();
        if (this$axisMemberList == null ? other$axisMemberList != null : !((Object)this$axisMemberList).equals(other$axisMemberList)) {
            return false;
        }
        AxisType this$axisType = this.getAxisType();
        AxisType other$axisType = other.getAxisType();
        return !(this$axisType == null ? other$axisType != null : !this$axisType.equals(other$axisType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FilterOpenAxis;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $systemId = this.getSystemId();
        result = result * 59 + ($systemId == null ? 43 : $systemId.hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        List $xbrlRoleDimensionList = this.getXbrlRoleDimensionList();
        result = result * 59 + ($xbrlRoleDimensionList == null ? 43 : ((Object)$xbrlRoleDimensionList).hashCode());
        List $axisMemberList = this.getAxisMemberList();
        result = result * 59 + ($axisMemberList == null ? 43 : ((Object)$axisMemberList).hashCode());
        AxisType $axisType = this.getAxisType();
        result = result * 59 + ($axisType == null ? 43 : $axisType.hashCode());
        return result;
    }

    public String toString() {
        return "FilterOpenAxis(id=" + this.getId() + ", systemId=" + this.getSystemId() + ", domain=" + this.getDomain() + ", title=" + this.getTitle() + ", xbrlRoleDimensionList=" + this.getXbrlRoleDimensionList() + ", axisMemberList=" + this.getAxisMemberList() + ", axisType=" + this.getAxisType() + ")";
    }
}

