/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.model.log;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.model.log.EventLog;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;

@Entity
@Table(indexes={@Index(name="idx_event_log_type", columnList="eventLogType")})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class EventLog {
    private static final Logger log = LoggerFactory.getLogger(EventLog.class);
    @Id
    @GeneratedValue
    private Long id;
    private Date created;
    @Enumerated(value=EnumType.STRING)
    private EventLogType eventLogType;
    @Column(length=8092)
    private String message;
    @Column(length=1024)
    private String role;
    @Column(length=1024)
    private String address;
    private String period;
    @Column(length=4096)
    private String concept;
    @Transient
    private String conceptLabel;
    @Lob
    private String dimensions;
    @Transient
    private String dimensionsLabel;
    @Lob
    @JsonIgnore
    @XmlTransient
    private byte[] aspectDataJson;
    @Transient
    private List<AspectData> aspectDataList;
    @Column(length=4096)
    private String currentValue;
    @Column(length=4096)
    private String compareValue;
    private Long xbrlReportId;
    @Transient
    private Set<String> tableRoles;
    @Transient
    private Set<String> presentationDefinitionRoles;
    @Enumerated(value=EnumType.STRING)
    private EventLogCsvFileType EventLogCsvFileType;

    public void buildAspectData() {
        this.aspectDataList = new ArrayList();
        AspectData periodAspect = new AspectData();
        periodAspect.setAspect("period");
        periodAspect.setAspectValue(this.period);
        periodAspect.setType(AspectType.PERIOD);
        this.aspectDataList.add(periodAspect);
        if (StringUtils.isNotBlank((CharSequence)this.dimensions)) {
            List xbrlContextDimensions = XbrlContextDimension.dimensionsFromString((String)this.dimensions);
            List dimensionsAspects = xbrlContextDimensions.stream().map(d -> d.toAspectData()).collect(Collectors.toList());
            this.aspectDataList.addAll(dimensionsAspects);
        }
        AspectData conceptAspect = new AspectData();
        conceptAspect.setAspect("concept");
        conceptAspect.setAspectValue(this.concept);
        conceptAspect.setType(AspectType.CONCEPT);
        this.aspectDataList.add(conceptAspect);
    }

    public Long getId() {
        return this.id;
    }

    public Date getCreated() {
        return this.created;
    }

    public EventLogType getEventLogType() {
        return this.eventLogType;
    }

    public String getMessage() {
        return this.message;
    }

    public String getRole() {
        return this.role;
    }

    public String getAddress() {
        return this.address;
    }

    public String getPeriod() {
        return this.period;
    }

    public String getConcept() {
        return this.concept;
    }

    public String getConceptLabel() {
        return this.conceptLabel;
    }

    public String getDimensions() {
        return this.dimensions;
    }

    public String getDimensionsLabel() {
        return this.dimensionsLabel;
    }

    public byte[] getAspectDataJson() {
        return this.aspectDataJson;
    }

    public List<AspectData> getAspectDataList() {
        return this.aspectDataList;
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public String getCompareValue() {
        return this.compareValue;
    }

    public Long getXbrlReportId() {
        return this.xbrlReportId;
    }

    public Set<String> getTableRoles() {
        return this.tableRoles;
    }

    public Set<String> getPresentationDefinitionRoles() {
        return this.presentationDefinitionRoles;
    }

    public EventLogCsvFileType getEventLogCsvFileType() {
        return this.EventLogCsvFileType;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setEventLogType(EventLogType eventLogType) {
        this.eventLogType = eventLogType;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public void setConcept(String concept) {
        this.concept = concept;
    }

    public void setConceptLabel(String conceptLabel) {
        this.conceptLabel = conceptLabel;
    }

    public void setDimensions(String dimensions) {
        this.dimensions = dimensions;
    }

    public void setDimensionsLabel(String dimensionsLabel) {
        this.dimensionsLabel = dimensionsLabel;
    }

    public void setAspectDataJson(byte[] aspectDataJson) {
        this.aspectDataJson = aspectDataJson;
    }

    public void setAspectDataList(List<AspectData> aspectDataList) {
        this.aspectDataList = aspectDataList;
    }

    public void setCurrentValue(String currentValue) {
        this.currentValue = currentValue;
    }

    public void setCompareValue(String compareValue) {
        this.compareValue = compareValue;
    }

    public void setXbrlReportId(Long xbrlReportId) {
        this.xbrlReportId = xbrlReportId;
    }

    public void setTableRoles(Set<String> tableRoles) {
        this.tableRoles = tableRoles;
    }

    public void setPresentationDefinitionRoles(Set<String> presentationDefinitionRoles) {
        this.presentationDefinitionRoles = presentationDefinitionRoles;
    }

    public void setEventLogCsvFileType(EventLogCsvFileType EventLogCsvFileType2) {
        this.EventLogCsvFileType = EventLogCsvFileType2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventLog)) {
            return false;
        }
        EventLog other = (EventLog)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Date this$created = this.getCreated();
        Date other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        EventLogType this$eventLogType = this.getEventLogType();
        EventLogType other$eventLogType = other.getEventLogType();
        if (this$eventLogType == null ? other$eventLogType != null : !this$eventLogType.equals(other$eventLogType)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$period = this.getPeriod();
        String other$period = other.getPeriod();
        if (this$period == null ? other$period != null : !this$period.equals(other$period)) {
            return false;
        }
        String this$concept = this.getConcept();
        String other$concept = other.getConcept();
        if (this$concept == null ? other$concept != null : !this$concept.equals(other$concept)) {
            return false;
        }
        String this$conceptLabel = this.getConceptLabel();
        String other$conceptLabel = other.getConceptLabel();
        if (this$conceptLabel == null ? other$conceptLabel != null : !this$conceptLabel.equals(other$conceptLabel)) {
            return false;
        }
        String this$dimensions = this.getDimensions();
        String other$dimensions = other.getDimensions();
        if (this$dimensions == null ? other$dimensions != null : !this$dimensions.equals(other$dimensions)) {
            return false;
        }
        String this$dimensionsLabel = this.getDimensionsLabel();
        String other$dimensionsLabel = other.getDimensionsLabel();
        if (this$dimensionsLabel == null ? other$dimensionsLabel != null : !this$dimensionsLabel.equals(other$dimensionsLabel)) {
            return false;
        }
        if (!Arrays.equals(this.getAspectDataJson(), other.getAspectDataJson())) {
            return false;
        }
        List this$aspectDataList = this.getAspectDataList();
        List other$aspectDataList = other.getAspectDataList();
        if (this$aspectDataList == null ? other$aspectDataList != null : !((Object)this$aspectDataList).equals(other$aspectDataList)) {
            return false;
        }
        String this$currentValue = this.getCurrentValue();
        String other$currentValue = other.getCurrentValue();
        if (this$currentValue == null ? other$currentValue != null : !this$currentValue.equals(other$currentValue)) {
            return false;
        }
        String this$compareValue = this.getCompareValue();
        String other$compareValue = other.getCompareValue();
        if (this$compareValue == null ? other$compareValue != null : !this$compareValue.equals(other$compareValue)) {
            return false;
        }
        Long this$xbrlReportId = this.getXbrlReportId();
        Long other$xbrlReportId = other.getXbrlReportId();
        if (this$xbrlReportId == null ? other$xbrlReportId != null : !((Object)this$xbrlReportId).equals(other$xbrlReportId)) {
            return false;
        }
        Set this$tableRoles = this.getTableRoles();
        Set other$tableRoles = other.getTableRoles();
        if (this$tableRoles == null ? other$tableRoles != null : !((Object)this$tableRoles).equals(other$tableRoles)) {
            return false;
        }
        Set this$presentationDefinitionRoles = this.getPresentationDefinitionRoles();
        Set other$presentationDefinitionRoles = other.getPresentationDefinitionRoles();
        if (this$presentationDefinitionRoles == null ? other$presentationDefinitionRoles != null : !((Object)this$presentationDefinitionRoles).equals(other$presentationDefinitionRoles)) {
            return false;
        }
        EventLogCsvFileType this$EventLogCsvFileType = this.getEventLogCsvFileType();
        EventLogCsvFileType other$EventLogCsvFileType = other.getEventLogCsvFileType();
        return !(this$EventLogCsvFileType == null ? other$EventLogCsvFileType != null : !this$EventLogCsvFileType.equals(other$EventLogCsvFileType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventLog;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Date $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        EventLogType $eventLogType = this.getEventLogType();
        result = result * 59 + ($eventLogType == null ? 43 : $eventLogType.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $period = this.getPeriod();
        result = result * 59 + ($period == null ? 43 : $period.hashCode());
        String $concept = this.getConcept();
        result = result * 59 + ($concept == null ? 43 : $concept.hashCode());
        String $conceptLabel = this.getConceptLabel();
        result = result * 59 + ($conceptLabel == null ? 43 : $conceptLabel.hashCode());
        String $dimensions = this.getDimensions();
        result = result * 59 + ($dimensions == null ? 43 : $dimensions.hashCode());
        String $dimensionsLabel = this.getDimensionsLabel();
        result = result * 59 + ($dimensionsLabel == null ? 43 : $dimensionsLabel.hashCode());
        result = result * 59 + Arrays.hashCode(this.getAspectDataJson());
        List $aspectDataList = this.getAspectDataList();
        result = result * 59 + ($aspectDataList == null ? 43 : ((Object)$aspectDataList).hashCode());
        String $currentValue = this.getCurrentValue();
        result = result * 59 + ($currentValue == null ? 43 : $currentValue.hashCode());
        String $compareValue = this.getCompareValue();
        result = result * 59 + ($compareValue == null ? 43 : $compareValue.hashCode());
        Long $xbrlReportId = this.getXbrlReportId();
        result = result * 59 + ($xbrlReportId == null ? 43 : ((Object)$xbrlReportId).hashCode());
        Set $tableRoles = this.getTableRoles();
        result = result * 59 + ($tableRoles == null ? 43 : ((Object)$tableRoles).hashCode());
        Set $presentationDefinitionRoles = this.getPresentationDefinitionRoles();
        result = result * 59 + ($presentationDefinitionRoles == null ? 43 : ((Object)$presentationDefinitionRoles).hashCode());
        EventLogCsvFileType $EventLogCsvFileType = this.getEventLogCsvFileType();
        result = result * 59 + ($EventLogCsvFileType == null ? 43 : $EventLogCsvFileType.hashCode());
        return result;
    }

    public String toString() {
        return "EventLog(id=" + this.getId() + ", created=" + this.getCreated() + ", eventLogType=" + this.getEventLogType() + ", message=" + this.getMessage() + ", role=" + this.getRole() + ", address=" + this.getAddress() + ", period=" + this.getPeriod() + ", concept=" + this.getConcept() + ", conceptLabel=" + this.getConceptLabel() + ", dimensions=" + this.getDimensions() + ", dimensionsLabel=" + this.getDimensionsLabel() + ", aspectDataJson=" + Arrays.toString(this.getAspectDataJson()) + ", aspectDataList=" + this.getAspectDataList() + ", currentValue=" + this.getCurrentValue() + ", compareValue=" + this.getCompareValue() + ", xbrlReportId=" + this.getXbrlReportId() + ", tableRoles=" + this.getTableRoles() + ", presentationDefinitionRoles=" + this.getPresentationDefinitionRoles() + ", EventLogCsvFileType=" + this.getEventLogCsvFileType() + ")";
    }
}

