/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.model.event;

import java.util.Date;
import javax.persistence.Column;

public class NotificationEvent {
    private Date time = new Date();
    private String title;
    @Column(length=8092)
    private String message;
    private Float progress;
    private Integer currentStage;
    private Integer totalNumberOfStages;

    public NotificationEvent() {
    }

    public NotificationEvent(String title) {
        this.title = title;
    }

    public NotificationEvent(Number title) {
        this.title = title.toString();
    }

    public NotificationEvent(String title, int currentStage, int totalNumberOfStages) {
        this.title = title;
        this.currentStage = currentStage;
        this.totalNumberOfStages = totalNumberOfStages;
        this.progress = Float.valueOf((float)currentStage / (float)totalNumberOfStages);
    }

    public Date getTime() {
        return this.time;
    }

    public String getTitle() {
        return this.title;
    }

    public String getMessage() {
        return this.message;
    }

    public Float getProgress() {
        return this.progress;
    }

    public Integer getCurrentStage() {
        return this.currentStage;
    }

    public Integer getTotalNumberOfStages() {
        return this.totalNumberOfStages;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setProgress(Float progress) {
        this.progress = progress;
    }

    public void setCurrentStage(Integer currentStage) {
        this.currentStage = currentStage;
    }

    public void setTotalNumberOfStages(Integer totalNumberOfStages) {
        this.totalNumberOfStages = totalNumberOfStages;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotificationEvent)) {
            return false;
        }
        NotificationEvent other = (NotificationEvent)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Date this$time = this.getTime();
        Date other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Float this$progress = this.getProgress();
        Float other$progress = other.getProgress();
        if (this$progress == null ? other$progress != null : !((Object)this$progress).equals(other$progress)) {
            return false;
        }
        Integer this$currentStage = this.getCurrentStage();
        Integer other$currentStage = other.getCurrentStage();
        if (this$currentStage == null ? other$currentStage != null : !((Object)this$currentStage).equals(other$currentStage)) {
            return false;
        }
        Integer this$totalNumberOfStages = this.getTotalNumberOfStages();
        Integer other$totalNumberOfStages = other.getTotalNumberOfStages();
        return !(this$totalNumberOfStages == null ? other$totalNumberOfStages != null : !((Object)this$totalNumberOfStages).equals(other$totalNumberOfStages));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NotificationEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Date $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Float $progress = this.getProgress();
        result = result * 59 + ($progress == null ? 43 : ((Object)$progress).hashCode());
        Integer $currentStage = this.getCurrentStage();
        result = result * 59 + ($currentStage == null ? 43 : ((Object)$currentStage).hashCode());
        Integer $totalNumberOfStages = this.getTotalNumberOfStages();
        result = result * 59 + ($totalNumberOfStages == null ? 43 : ((Object)$totalNumberOfStages).hashCode());
        return result;
    }

    public String toString() {
        return "NotificationEvent(time=" + this.getTime() + ", title=" + this.getTitle() + ", message=" + this.getMessage() + ", progress=" + this.getProgress() + ", currentStage=" + this.getCurrentStage() + ", totalNumberOfStages=" + this.getTotalNumberOfStages() + ")";
    }
}

