/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.xml.namespace.QName;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmValue;
import org.apache.commons.lang3.StringUtils;

public class XbrlTaxonomyParameter {
    private final QName name;
    private final String select;
    private final boolean required;
    private final QName as;
    private String value;

    public QName getName() {
        return this.name;
    }

    public String getSelect() {
        return this.select;
    }

    public boolean isRequired() {
        return this.required;
    }

    public QName getAs() {
        return this.as;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isDate() {
        return "date".equals(this.as.getLocalPart());
    }

    @JsonIgnore
    public XdmValue getXdmValue() throws SaxonApiException {
        if (this.getValue() == null) {
            return null;
        }
        if (this.isDate()) {
            try {
                return new XdmAtomicValue(this.getValue(), ItemType.DATE);
            }
            catch (SaxonApiException e) {
                if (e.getMessage().startsWith("Invalid date") && e.getMessage().endsWith("must be two digits)")) {
                    String dt = this.value;
                    String[] dtParts = dt.split("-");
                    return new XdmAtomicValue(String.format("%s-%s-%s", dtParts[0], StringUtils.leftPad((String)dtParts[1], (int)2, (char)'0'), StringUtils.leftPad((String)dtParts[2], (int)2, (char)'0')), ItemType.DATE);
                }
                throw e;
            }
        }
        return new XdmAtomicValue(this.getValue(), ItemType.STRING);
    }

    public XbrlTaxonomyParameter(@JsonProperty(value="name") QName name, @JsonProperty(value="select") String select, @JsonProperty(value="required") Boolean required, @JsonProperty(value="as") QName as) {
        this.name = name;
        this.select = select;
        this.required = required == null ? false : required;
        this.as = as;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XbrlTaxonomyParameter that = (XbrlTaxonomyParameter)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

