/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.model;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.StringUtils;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.validation.ValidationEvent;

@Entity
@Table(indexes={@Index(name="idx_report_validation_event_type_severity", columnList="xbrlReport_id, type, severity"), @Index(name="idx_report_validation_event_type", columnList="xbrlReport_id, type")})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class XbrlReportValidationEvent {
    @Id
    @GeneratedValue
    @XmlTransient
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(foreignKey=@ForeignKey(name="FK_XBRL_REPORT_VALIDATION_EVENT"))
    @JsonBackReference
    @XmlTransient
    private XbrlReport xbrlReport;
    private String type;
    private String severity;
    @Lob
    private String json;
    static ObjectMapper mapper = new ObjectMapper();

    public XbrlReportValidationEvent(ValidationEvent validationEvent) throws JsonProcessingException {
        if (validationEvent != null) {
            String severity = validationEvent.getSeverity();
            this.severity = StringUtils.isBlank((CharSequence)severity) ? "ERROR" : severity;
            this.type = validationEvent.getType();
        }
        this.json = mapper.writeValueAsString((Object)validationEvent);
    }

    public Long getId() {
        return this.id;
    }

    public XbrlReport getXbrlReport() {
        return this.xbrlReport;
    }

    public String getType() {
        return this.type;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getJson() {
        return this.json;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setXbrlReport(XbrlReport xbrlReport) {
        this.xbrlReport = xbrlReport;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XbrlReportValidationEvent)) {
            return false;
        }
        XbrlReportValidationEvent other = (XbrlReportValidationEvent)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        XbrlReport this$xbrlReport = this.getXbrlReport();
        XbrlReport other$xbrlReport = other.getXbrlReport();
        if (this$xbrlReport == null ? other$xbrlReport != null : !this$xbrlReport.equals(other$xbrlReport)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$severity = this.getSeverity();
        String other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !this$severity.equals(other$severity)) {
            return false;
        }
        String this$json = this.getJson();
        String other$json = other.getJson();
        return !(this$json == null ? other$json != null : !this$json.equals(other$json));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XbrlReportValidationEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        XbrlReport $xbrlReport = this.getXbrlReport();
        result = result * 59 + ($xbrlReport == null ? 43 : $xbrlReport.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : $severity.hashCode());
        String $json = this.getJson();
        result = result * 59 + ($json == null ? 43 : $json.hashCode());
        return result;
    }

    public String toString() {
        return "XbrlReportValidationEvent(id=" + this.getId() + ", xbrlReport=" + this.getXbrlReport() + ", type=" + this.getType() + ", severity=" + this.getSeverity() + ", json=" + this.getJson() + ")";
    }

    public XbrlReportValidationEvent() {
    }
}

