/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.model;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.XbrlRolePeriod;
import ru.cbr.xbrl.converter.model.tableLinkBase.AspectNodeMember;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterAxis;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.model.tableLinkBase.XbrlRoleDimension;

@Entity
@Table(indexes={@Index(name="idx_systemid", columnList="systemId")})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class XbrlReportRole {
    @Id
    @GeneratedValue
    private Long id;
    @Column(length=4096)
    private String title;
    @Column(length=4096)
    private String documentation;
    private String systemId;
    private String roleId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(foreignKey=@ForeignKey(name="FK_XBRL_REPORT_ROLE"))
    @JsonBackReference
    @XmlTransient
    private XbrlReport xbrlReport;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="xbrlReportRole")
    private List<XbrlRolePeriod> periodList = new ArrayList();
    @JsonIgnore
    @OneToMany(fetch=FetchType.LAZY, mappedBy="xbrlReportRole", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<XbrlRoleDimension> xbrlRoleDimensionList = new ArrayList();
    @JsonIgnore
    @OneToMany(fetch=FetchType.LAZY, mappedBy="xbrlReportRole", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AspectNodeMember> aspectNodeMembers = new ArrayList();
    @Lob
    private String json;
    @Lob
    private String staticStructureJson;
    @Lob
    private String roleCellsJson;
    @JsonProperty(value="filterAxisList")
    @Transient
    public List<FilterAxis> filterAxisList = new ArrayList();
    @XmlTransient
    @Transient
    public Map<String, List<AspectNodeMember>> aspectNodeMemberHashMap = new HashMap();

    public XbrlReportRole() {
    }

    public XbrlReportRole(Long id) {
        this.id = id;
    }

    public String getCompareString() {
        return this.getTitle() + " " + this.getSystemId();
    }

    public TableLinkBaseStructure unpackTableLinkBaseStructure() {
        ObjectMapper mapper = new ObjectMapper();
        TableLinkBaseStructure tableLinkBaseStructure = null;
        try {
            tableLinkBaseStructure = (TableLinkBaseStructure)mapper.readValue(this.getStaticStructureJson(), TableLinkBaseStructure.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tableLinkBaseStructure;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XbrlReportRole that = (XbrlReportRole)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.systemId != null ? !this.systemId.equals(that.systemId) : that.systemId != null) {
            return false;
        }
        if (this.xbrlReport != null && that.xbrlReport != null) {
            return this.xbrlReport.getId() != null ? this.xbrlReport.getId().equals(that.xbrlReport.getId()) : that.xbrlReport.getId() == null;
        }
        return this.xbrlReport == null && that.xbrlReport == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.systemId != null ? this.systemId.hashCode() : 0);
        result = 31 * result + (this.xbrlReport != null && this.xbrlReport.getId() != null ? this.xbrlReport.getId().hashCode() : 0);
        return result;
    }

    public Long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public XbrlReport getXbrlReport() {
        return this.xbrlReport;
    }

    public List<XbrlRolePeriod> getPeriodList() {
        return this.periodList;
    }

    public List<XbrlRoleDimension> getXbrlRoleDimensionList() {
        return this.xbrlRoleDimensionList;
    }

    public List<AspectNodeMember> getAspectNodeMembers() {
        return this.aspectNodeMembers;
    }

    public String getJson() {
        return this.json;
    }

    public String getStaticStructureJson() {
        return this.staticStructureJson;
    }

    public String getRoleCellsJson() {
        return this.roleCellsJson;
    }

    public List<FilterAxis> getFilterAxisList() {
        return this.filterAxisList;
    }

    public Map<String, List<AspectNodeMember>> getAspectNodeMemberHashMap() {
        return this.aspectNodeMemberHashMap;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public void setXbrlReport(XbrlReport xbrlReport) {
        this.xbrlReport = xbrlReport;
    }

    public void setPeriodList(List<XbrlRolePeriod> periodList) {
        this.periodList = periodList;
    }

    public void setXbrlRoleDimensionList(List<XbrlRoleDimension> xbrlRoleDimensionList) {
        this.xbrlRoleDimensionList = xbrlRoleDimensionList;
    }

    public void setAspectNodeMembers(List<AspectNodeMember> aspectNodeMembers) {
        this.aspectNodeMembers = aspectNodeMembers;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public void setStaticStructureJson(String staticStructureJson) {
        this.staticStructureJson = staticStructureJson;
    }

    public void setRoleCellsJson(String roleCellsJson) {
        this.roleCellsJson = roleCellsJson;
    }

    public void setFilterAxisList(List<FilterAxis> filterAxisList) {
        this.filterAxisList = filterAxisList;
    }

    public void setAspectNodeMemberHashMap(Map<String, List<AspectNodeMember>> aspectNodeMemberHashMap) {
        this.aspectNodeMemberHashMap = aspectNodeMemberHashMap;
    }

    public String toString() {
        return "XbrlReportRole(id=" + this.getId() + ", title=" + this.getTitle() + ", documentation=" + this.getDocumentation() + ", systemId=" + this.getSystemId() + ", roleId=" + this.getRoleId() + ", periodList=" + this.getPeriodList() + ", xbrlRoleDimensionList=" + this.getXbrlRoleDimensionList() + ", aspectNodeMembers=" + this.getAspectNodeMembers() + ", json=" + this.getJson() + ", staticStructureJson=" + this.getStaticStructureJson() + ", roleCellsJson=" + this.getRoleCellsJson() + ", filterAxisList=" + this.getFilterAxisList() + ", aspectNodeMemberHashMap=" + this.getAspectNodeMemberHashMap() + ")";
    }
}

