/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.controller;

import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.model.XbrlReportValidationEvent;
import ru.cbr.xbrl.converter.service.XbrlValidateService;
import ru.cbr.xbrl.converter.service.internal.XbrlReportValidationEventCrudService;

@RestController
@RequestMapping(value={"xbrl-report-validation-event"})
public class XbrlReportValidationEventController {
    private static final Logger log = LoggerFactory.getLogger(XbrlReportValidationEventController.class);
    @Autowired
    private XbrlReportValidationEventCrudService xbrlReportValidationEventCrudService;
    @Autowired
    private XbrlValidateService xbrlValidateService;

    @GetMapping(value={"{xbrlReportId}/{tabName}/page/{pageNum}"})
    public Page<XbrlReportValidationEvent> getPage(@PathVariable(value="xbrlReportId") Long xbrlReportId, @PathVariable(value="tabName") String tabName, @PathVariable(value="pageNum") Integer pageNum) throws NotFoundException {
        return this.xbrlReportValidationEventCrudService.getPage(xbrlReportId, pageNum, tabName);
    }

    @GetMapping(value={"new-events"})
    public List<XbrlReportValidationEvent> getValidationEvent() throws NotFoundException {
        return this.xbrlValidateService.getValidationEvent();
    }

    @PostMapping(value={"export-xlsx"})
    public void exportXlsx(@RequestParam(value="xbrlReportId") Long xbrlReportId, @RequestParam(value="filePath") String filePath, @RequestParam(value="xlsxFileName") String xlsxFileName) throws NotFoundException {
        String fullName = FilenameUtils.concat((String)filePath, (String)xlsxFileName);
        this.xbrlReportValidationEventCrudService.exportValidationEventsToXlsx(xbrlReportId, fullName);
    }
}

