/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.websocket.server.PathParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.cbr.xbrl.converter.arelle.ArelleOutputParser;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.exception.BadRequestException;
import ru.cbr.xbrl.converter.exception.CancelledException;
import ru.cbr.xbrl.converter.exception.CommandExecutionException;
import ru.cbr.xbrl.converter.exception.IncompatibleSchemaRefException;
import ru.cbr.xbrl.converter.exception.IncompatibleTxtFilterFileEncodingException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.ReadFileException;
import ru.cbr.xbrl.converter.exception.TaxonomyNotFoundException;
import ru.cbr.xbrl.converter.exception.UploadException;
import ru.cbr.xbrl.converter.exception.XbrlExportException;
import ru.cbr.xbrl.converter.model.ValidationRole;
import ru.cbr.xbrl.converter.model.XbrlPeriod;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.filter.FilterViewType;
import ru.cbr.xbrl.converter.model.log.EventLog;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.tableLinkBase.EnumerateItem;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterAxis;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxis;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxisValue;
import ru.cbr.xbrl.converter.model.validation.ValidationEvent;
import ru.cbr.xbrl.converter.model.web.rest.AspectDataWrapper;
import ru.cbr.xbrl.converter.model.web.rest.FootnoteEditDTO;
import ru.cbr.xbrl.converter.model.web.rest.RoleDTO;
import ru.cbr.xbrl.converter.model.web.rest.ToggleDTO;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlFootnote;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValue;
import ru.cbr.xbrl.converter.service.EnumerationsService;
import ru.cbr.xbrl.converter.service.TableLinkBaseDataService;
import ru.cbr.xbrl.converter.service.TaxonomyService;
import ru.cbr.xbrl.converter.service.XbrlComparingService;
import ru.cbr.xbrl.converter.service.XbrlPackageService;
import ru.cbr.xbrl.converter.service.XbrlParsedDataService;
import ru.cbr.xbrl.converter.service.XbrlReportService;
import ru.cbr.xbrl.converter.service.XbrlValidateService;
import ru.cbr.xbrl.converter.service.import_export.EditXbrlService;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlFootnoteCrudService;
import ru.cbr.xbrl.converter.service.presentation_definition.InactiveMembersService;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;

@RestController
@RequestMapping(value={"xbrl-report"})
public class XbrlReportController {
    private static final Logger log = LoggerFactory.getLogger(XbrlReportController.class);
    @Autowired
    private XbrlReportService xbrlReportService;
    @Autowired
    private XbrlValidateService xbrlValidateService;
    @Autowired
    private XbrlParsedDataService xbrlParsedDataService;
    @Autowired
    private XbrlPackageService xbrlPackageService;
    @Autowired
    private TaxonomyService taxonomyService;
    @Autowired
    private TableLinkBaseDataService tableLinkBaseDataService;
    @Autowired
    private EditXbrlService editXbrlService;
    @Autowired
    private XbrlComparingService xbrlComparingService;
    @Autowired
    private XbrlFootnoteCrudService xbrlFootnoteCrudService;
    @Autowired
    private ConfigProperties configProperties;
    @Autowired
    private EnumerationsService enumerationsService;
    @Autowired
    InactiveMembersService inactiveMembersService;

    @GetMapping(value={"/"})
    public List<XbrlReport> list() {
        List items = this.xbrlReportService.list();
        items.stream().forEach(item -> item.prepareForJson());
        return items;
    }

    @GetMapping(value={"/{id}"})
    public XbrlReport find(@PathVariable(value="id") Long id) throws NotFoundException {
        XbrlReport xbrlReport = this.xbrlReportService.find(id);
        xbrlReport.prepareForJson();
        return xbrlReport;
    }

    @GetMapping(value={"/role/by-systemid"})
    public XbrlReportRole findRoleBySystemId(@PathParam(value="systemId") String systemId) throws NotFoundException {
        XbrlReportRole reportRole = this.xbrlReportService.findReportRoleBySystemId(systemId);
        this.tableLinkBaseDataService.updateTableLinkBaseUI(reportRole, false);
        return reportRole;
    }

    @GetMapping(value={"/role/{id}"})
    public XbrlReportRole findRole(@PathVariable(value="id") Long id, @PathParam(value="isTree") Boolean isTree) throws NotFoundException {
        XbrlReportRole reportRole = this.xbrlReportService.findReportRole(id);
        this.tableLinkBaseDataService.updateTableLinkBaseUI(reportRole, isTree.booleanValue());
        return reportRole;
    }

    @GetMapping(value={"/role/{id}/periods"})
    public List<XbrlPeriod> findPeriods(@PathVariable(value="id") Long id) throws NotFoundException {
        return this.xbrlReportService.findReportRolePeriodList(id);
    }

    @PostMapping(value={"/rolepd/periods"})
    public List<XbrlPeriod> findPdPeriods(@RequestParam(value="roleSystemId", required=false) String pdRoleSystemIdGuid) {
        return this.xbrlReportService.findPdReportRolePeriodList(pdRoleSystemIdGuid);
    }

    @PutMapping(value={"/role/{id}/period/{periodId}/toggle"})
    public List<XbrlPeriod> toggleRolePeriod(@PathVariable(value="id") Long id, @PathVariable(value="periodId") Long periodId) throws NotFoundException {
        return this.xbrlReportService.toggleRolePeriod(id, periodId);
    }

    @PostMapping(value={"/rolepd/toggle-period"})
    public List<XbrlPeriod> togglePdRolePeriod(@RequestParam(value="roleSystemId") String roleSystemId, @RequestParam(value="periodId") Long periodId) throws NotFoundException {
        return this.xbrlReportService.togglePDRolePeriod(roleSystemId, periodId);
    }

    @PutMapping(value={"/role/{id}/period/{periodId}"})
    public List<XbrlPeriod> updatePeriod(@PathVariable(value="id") Long id, @PathVariable(value="periodId") Long periodId, @RequestBody XbrlPeriod xbrlPeriod) throws NotFoundException {
        return this.xbrlReportService.updateReportRolePeriod(id, periodId, xbrlPeriod);
    }

    @PostMapping(value={"/topackage"})
    public XbrlReport uploadToPackage(@RequestParam(value="xbrlPackageId") Long xbrlPackageId, @RequestParam(value="localPath") String localPath) throws UploadException, TaxonomyNotFoundException, CancelledException, NotFoundException, IOException {
        XbrlPackage xbrlPackage = this.xbrlPackageService.find(xbrlPackageId);
        XbrlReport xbrlReport = this.xbrlPackageService.addXbrlReportToPackage(xbrlPackage, localPath);
        if (xbrlPackage.getXbrlReport() != null) {
            xbrlPackage.getXbrlReport().getXbrlReportRoles().stream().forEach(r -> r.setJson(null));
        }
        return xbrlReport;
    }

    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable(value="id") Long id) throws NotFoundException, IOException {
        this.xbrlReportService.deleteWithFile(id);
    }

    @GetMapping(value={"/{id}/validate"})
    public List<ValidationEvent> validate(@PathVariable(value="id") Long xbrlReportId) throws NotFoundException, CommandExecutionException, TaxonomyNotFoundException, CancelledException, XbrlExportException {
        ArelleOutputParser.setIsLastActionCancelled((Boolean)false);
        this.xbrlValidateService.validate(xbrlReportId);
        return Collections.emptyList();
    }

    @PostMapping(value={"/{id}/validateFormulas"})
    public List<ValidationEvent> validateFormulas(@PathVariable(value="id") Long xbrlReportId, @RequestParam(value="formulaRunIDsList", required=true) List<String> formulaRunIDsList) throws NotFoundException, CommandExecutionException, TaxonomyNotFoundException, CancelledException, XbrlExportException {
        ArelleOutputParser.setIsLastActionCancelled((Boolean)false);
        this.xbrlValidateService.validateFormulas(xbrlReportId, formulaRunIDsList);
        return Collections.emptyList();
    }

    @GetMapping(value={"/{id}/getValidationRoles"})
    public List<ValidationRole> getValidationRoles(@PathVariable(value="id") Long xbrlReportId) throws NotFoundException {
        return this.xbrlValidateService.getValidationRoles(xbrlReportId);
    }

    @GetMapping(value={"/{id}/compare"})
    public List<EventLog> compare(@PathVariable(value="id") Long xbrlReportId) throws NotFoundException, CommandExecutionException, TaxonomyNotFoundException, CancelledException, XbrlExportException, IncompatibleSchemaRefException {
        return this.xbrlComparingService.compare(xbrlReportId);
    }

    @PostMapping(value={"/compare/cancel"})
    public void cancelCompare() {
        this.xbrlComparingService.cancelProcessing();
    }

    @PostMapping(value={"/download"})
    public void downloadToFolder(@RequestParam(value="xbrlReportId") Long xbrlReportId, @RequestParam(value="localPath") String destinationPath) throws NotFoundException {
        this.xbrlReportService.downloadToFolder(xbrlReportId, destinationPath);
    }

    @PostMapping(value={"/cancel"})
    public void cancelProcessing() {
        this.xbrlReportService.cancelProcessing();
    }

    @PostMapping(value={"/filter/{axisId}/member"})
    public void addRoleFilterMember(@PathVariable(value="axisId") Long axisId, @RequestBody FilterOpenAxisValue filterOpenAxisValue) throws NotFoundException {
        this.xbrlReportService.addRoleFilterMember(axisId, filterOpenAxisValue);
    }

    @PostMapping(value={"/filter/importmembers"})
    public void importRoleFilterMembersFromTextFile(@RequestParam(value="axisId") Long axisId, @RequestParam(value="localPath") String textFilePath) throws NotFoundException, ReadFileException, IncompatibleTxtFilterFileEncodingException {
        this.xbrlReportService.importRoleFilterMembersFromTextFile(axisId, textFilePath);
    }

    @DeleteMapping(value={"/filter/member/{memberId}"})
    public void deleteRoleFilterMember(@PathVariable(value="memberId") Long memberId) {
        this.xbrlReportService.deleteRoleFilterMember(memberId);
    }

    @DeleteMapping(value={"/filter/member"})
    public void deleteRoleFilterMemberList(@RequestBody List<Long> memberIdList) {
        this.xbrlReportService.deleteRoleFilterMember(memberIdList);
    }

    @DeleteMapping(value={"/global-filter/member"})
    public RoleDTO deleteRoleFilterMemberList(@RequestParam(name="confirm", required=false) Boolean confirm, @RequestBody List<Long> memberIdList) {
        return this.xbrlReportService.deleteRoleFilterMember(memberIdList, confirm);
    }

    @PutMapping(value={"/filter/member/{memberId}"})
    public FilterOpenAxisValue updateRoleFilterMember(@PathVariable(value="memberId") Long memberId, @RequestBody FilterOpenAxisValue filterOpenAxisValue) throws NotFoundException {
        return this.xbrlReportService.updateRoleFilterMember(memberId, filterOpenAxisValue);
    }

    @PutMapping(value={"/role/{id}/filter/member/{memberId}/{value}"})
    public FilterOpenAxis toggleRoleFilterMember(@PathVariable(value="id") Long roleId, @PathVariable(value="memberId") Long memberId, @PathVariable(value="value") Boolean state) throws NotFoundException {
        return this.xbrlReportService.toggleRoleFilterMember(roleId, memberId, state);
    }

    @PostMapping(value={"/footnote/fact"})
    public List<XbrlFootnote> getFactFootnoteList(@RequestBody AspectCellData aspectCellData) {
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        XbrlReport xbrlReport = xbrlPackage.getXbrlReport();
        XbrlValue xbrlValue = this.editXbrlService.findValue(xbrlReport, aspectCellData);
        return this.xbrlFootnoteCrudService.listByXbrlValue(xbrlValue);
    }

    @PostMapping(value={"/footnote/fact/edit"})
    public List<XbrlFootnote> editFootnoteFactLinkList(@RequestParam(value="aspectDataList") AspectCellData aspectCellData, @RequestParam(value="footnoteList") List<XbrlFootnote> xbrlFootnoteList) {
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        XbrlReport xbrlReport = xbrlPackage.getXbrlReport();
        XbrlValue xbrlValue = this.editXbrlService.findValue(xbrlReport, aspectCellData);
        return this.xbrlFootnoteCrudService.editFootnoteFactLinkList(xbrlValue, xbrlFootnoteList);
    }

    @PostMapping(value={"/footnote/fact/edit-one"})
    public XbrlFootnote editFootnoteFactLink(@RequestBody FootnoteEditDTO footnoteEditDTO) throws BadRequestException {
        if (footnoteEditDTO == null) {
            return null;
        }
        AspectCellData aspectCellData = footnoteEditDTO.getEditingCellData();
        if (aspectCellData == null) {
            return null;
        }
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        XbrlReport xbrlReport = xbrlPackage.getXbrlReport();
        XbrlValue xbrlValue = this.editXbrlService.findValue(xbrlReport, aspectCellData);
        if (xbrlValue == null) {
            ArrayList<AspectCellData> aspectCellDataList = new ArrayList<AspectCellData>();
            aspectCellDataList.add(aspectCellData);
            this.editXbrlService.saveCells(xbrlPackage, aspectCellDataList, false);
            xbrlValue = this.editXbrlService.findValue(xbrlReport, aspectCellData);
            if (xbrlValue == null) {
                log.error("\u0421\u0432\u044f\u0437\u044c \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044f \u0441 \u0444\u0430\u043a\u0442\u043e\u043c. \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0444\u0430\u043a\u0442 \u043f\u0440\u0438 \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0435.");
                throw new BadRequestException();
            }
        }
        return this.xbrlFootnoteCrudService.editFootnoteFactLink(xbrlValue, footnoteEditDTO.getFootnote(), footnoteEditDTO.isConnected());
    }

    @GetMapping(value={"/footnote"})
    public Slice<XbrlFootnote> getFootnoteList(@RequestParam(value="page") Integer page) {
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        return this.xbrlFootnoteCrudService.list((Pageable)new PageRequest(page.intValue(), 25));
    }

    @GetMapping(value={"/footnote/content"})
    public List<AspectDataWrapper> getAspectData(@RequestParam(value="footnoteContent") String footnoteContent) {
        return this.xbrlFootnoteCrudService.getAspectData(footnoteContent);
    }

    @PostMapping(value={"/footnote"})
    public XbrlFootnote createFootnote(@RequestBody String footnoteContent) {
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        return this.xbrlFootnoteCrudService.createNew(footnoteContent, xbrlPackage);
    }

    @PostMapping(value={"/footnote/delete"})
    public void deleteFootnote(@RequestBody List<String> xbrlFootnoteList) {
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        this.xbrlFootnoteCrudService.delete(xbrlFootnoteList, xbrlPackage);
    }

    @PutMapping(value={"/footnote"})
    public XbrlFootnote editFootnote(@RequestBody XbrlFootnote xbrlFootnote) {
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        return this.xbrlFootnoteCrudService.edit(xbrlFootnote, xbrlPackage);
    }

    @GetMapping(value={"/enumerations"})
    public Map<String, List<EnumerateItem>> getEnumerations() {
        return this.enumerationsService.getEnumerations();
    }

    @PostMapping(value={"/filter/toggle"})
    public Set<String> toggle(ToggleDTO toggleDTO) {
        return this.inactiveMembersService.toggle(toggleDTO, FilterViewType.TABLELINKBASE);
    }

    @GetMapping(value={"/all-filter-axis"})
    public List<FilterAxis> getAllFilterAxis() {
        return this.inactiveMembersService.getAllFilterAxis();
    }
}

