/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import ru.cbr.xbrl.converter.exception.AccessDeniedDirectoryException;
import ru.cbr.xbrl.converter.exception.MoveFileException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.SavePackageException;
import ru.cbr.xbrl.converter.exception.UnitsConfigRoleChangesException;
import ru.cbr.xbrl.converter.model.UnitsConfiguration;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.service.UnitsConfigurationService;
import ru.cbr.xbrl.converter.service.XbrlPackageService;
import ru.cbr.xbrl.converter.service.XbrlReportService;

@RestController
@RequestMapping(value={"units-config"})
public class UnitsConfigurationController {
    private static final Logger log = LoggerFactory.getLogger(UnitsConfigurationController.class);
    private UnitsConfigurationService unitsConfigurationService;
    private XbrlReportService xbrlReportService;
    private XbrlPackageService xbrlPackageService;

    public UnitsConfigurationController(UnitsConfigurationService unitsConfigurationService, XbrlReportService xbrlReportService, XbrlPackageService xbrlPackageService) {
        this.unitsConfigurationService = unitsConfigurationService;
        this.xbrlReportService = xbrlReportService;
        this.xbrlPackageService = xbrlPackageService;
    }

    @GetMapping(value={"report/{id}"})
    public UnitsConfiguration getForReport(@PathVariable(value="id") Long reportId) {
        UnitsConfiguration res = this.unitsConfigurationService.findByXbrlReport(new XbrlReport(reportId));
        log.info("GET UNITS FOR REPORT " + reportId + " " + res);
        return res;
    }

    @GetMapping(value={"report-role/{id}"})
    public UnitsConfiguration getForReportRole(@PathVariable(value="id") Long reportRoleId) throws NotFoundException {
        XbrlReportRole role = this.xbrlReportService.findReportRole(reportRoleId);
        UnitsConfiguration res = this.unitsConfigurationService.findByXbrlReportRole(role);
        if (res != null) {
            return res;
        }
        res = new UnitsConfiguration();
        res.setCurrency("RUB");
        res.setCurrencyDecimals(Integer.valueOf(-3));
        res.setCurrencyPrecision(null);
        res.setSharesDecimals(Integer.valueOf(-3));
        res.setSharesPrecision(null);
        res.setIntegerDecimals(Integer.valueOf(-3));
        res.setIntegerPrecision(null);
        res.setDecimalDecimals(Integer.valueOf(-3));
        res.setDecimalPrecision(null);
        log.trace("GET UNITS FOR ROLE " + reportRoleId + " " + res);
        return res;
    }

    @PutMapping(value={"report/{id}/{updateFacts}"})
    public UnitsConfiguration updateForReport(@PathVariable(value="id") Long reportId, @PathVariable(value="updateFacts") Boolean updateFacts, @RequestBody UnitsConfiguration unitsConfiguration) throws NotFoundException, UnitsConfigRoleChangesException, MoveFileException, SavePackageException, AccessDeniedDirectoryException {
        log.info("PUT UNITS FOR REPORT " + reportId + " " + unitsConfiguration);
        XbrlReport xbrlReport = this.xbrlReportService.find(reportId);
        this.unitsConfigurationService.updateUnitsConfigurationForReport(xbrlReport, unitsConfiguration, updateFacts);
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        this.xbrlPackageService.save(xbrlPackage.getId());
        return this.unitsConfigurationService.findByXbrlReport(new XbrlReport(reportId));
    }

    @PutMapping(value={"report-role/{id}/{updateFacts}"})
    public UnitsConfiguration updateForReportRole(@PathVariable(value="id") Long reportRoleId, @PathVariable(value="updateFacts") Boolean updateFacts, @RequestBody UnitsConfiguration unitsConfiguration) throws NotFoundException, UnitsConfigRoleChangesException, MoveFileException, SavePackageException, AccessDeniedDirectoryException {
        log.info("PUT UNITS FOR ROLE " + reportRoleId + " " + unitsConfiguration);
        XbrlReportRole role = this.xbrlReportService.findReportRole(reportRoleId);
        this.unitsConfigurationService.updateUnitsConfigurationForReportRole(role, unitsConfiguration, updateFacts);
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        this.xbrlPackageService.save(xbrlPackage.getId());
        return this.unitsConfigurationService.findByXbrlReportRole(role);
    }
}

