/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.controller;

import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import ru.cbr.xbrl.converter.exception.StructuredViewSizeTooMuchException;
import ru.cbr.xbrl.converter.model.presentation_definition.StructuredViewRequest;
import ru.cbr.xbrl.converter.model.presentation_definition.StructuredViewUIModel;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionRole;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionService;

@RestController
@RequestMapping(value={"presentation-definition/structured-view"})
public class StructuredViewController {
    private static final Logger log = LoggerFactory.getLogger(StructuredViewController.class);
    private final PresentationDefinitionService presentationDefinitionService;

    @PostMapping(value={"role"})
    public StructuredViewUIModel getRole(@RequestBody StructuredViewRequest request) throws StructuredViewSizeTooMuchException {
        PresentationDefinitionRole definitionRole = this.presentationDefinitionService.getPresentationDefinitionRole(request.getCode());
        this.presentationDefinitionService.checkMaxStructuredViewSize(definitionRole, request.getDirection(), request.isDontCheckSize());
        return this.presentationDefinitionService.getStructuredViewUIModel(definitionRole, request.getDirection());
    }

    @GetMapping(value={"max-size"})
    public int getMaxStructuredViewSize() {
        return this.presentationDefinitionService.getMaxStructuredViewSize();
    }

    @PostMapping(value={"save-max-size"})
    public void saveMaxStructuredViewSize(@RequestBody String maxStructuredViewSize) {
        this.presentationDefinitionService.saveMaxStructuredViewSize(maxStructuredViewSize);
    }

    @ConstructorProperties(value={"presentationDefinitionService"})
    public StructuredViewController(PresentationDefinitionService presentationDefinitionService) {
        this.presentationDefinitionService = presentationDefinitionService;
    }
}

