/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.controller;

import java.beans.ConstructorProperties;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.cbr.xbrl.converter.model.web.rest.AspectDataWrapper;
import ru.cbr.xbrl.converter.model.web.rest.SearchResult;
import ru.cbr.xbrl.converter.service.SearchService;
import ru.cbr.xbrl.converter.service.XbrlPackageService;

@RestController
@RequestMapping(value={"search"})
public class SearchController {
    private final SearchService searchService;
    private final XbrlPackageService xbrlPackageService;

    @GetMapping(value={"value"})
    public List<AspectDataWrapper> searchByValue(@RequestParam String query) {
        return this.searchService.searchByValue(query);
    }

    @GetMapping(value={"label"})
    public SearchResult searchByLabel(@RequestParam String query) {
        SearchResult searchResult = this.searchService.searchByLabel(query, false);
        SearchResult searchResultPresDef = this.searchService.searchByLabelPresDef(query);
        searchResult.setTotalPreDef(searchResultPresDef.getTotalPreDef());
        searchResult.setPreDefRoles(searchResultPresDef.getPreDefRoles());
        return searchResult;
    }

    @GetMapping(value={"xlabel"})
    public SearchResult searchByXLabel(@RequestParam String query) {
        SearchResult searchResult = this.searchService.searchByLabel(query, true);
        SearchResult searchResultPresDef = this.searchService.searchByLabelPresDef(query);
        searchResult.setTotalPreDef(searchResultPresDef.getTotalPreDef());
        searchResult.setPreDefRoles(searchResultPresDef.getPreDefRoles());
        return searchResult;
    }

    @ConstructorProperties(value={"searchService", "xbrlPackageService"})
    public SearchController(SearchService searchService, XbrlPackageService xbrlPackageService) {
        this.searchService = searchService;
        this.xbrlPackageService = xbrlPackageService;
    }
}

