/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.controller;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import ru.cbr.xbrl.converter.arelle.parse.HypercubeService;
import ru.cbr.xbrl.converter.arelle.parse.definition_hypercube.dto.DefinitionHypercube;
import ru.cbr.xbrl.converter.model.filter.FilterViewType;
import ru.cbr.xbrl.converter.model.web.rest.ToggleDTO;
import ru.cbr.xbrl.converter.service.presentation_definition.InactiveMembersService;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionRole;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionService;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;

@RestController
@RequestMapping(value={"presentation-definition"})
public class PresentationDefinitionController {
    private static final Logger log = LoggerFactory.getLogger(PresentationDefinitionController.class);
    private final PresentationDefinitionService presentationDefinitionService;
    private final InactiveMembersService inactiveMembersService;
    @Autowired
    private HypercubeService hypercubeService;

    @GetMapping(value={"roles"})
    public List<PresentationDefinitionRole> getRoles() {
        List presentationDefinitionRoles = this.presentationDefinitionService.getPresentationDefinitionRoles();
        ArrayList<PresentationDefinitionRole> newRoles = new ArrayList<PresentationDefinitionRole>();
        presentationDefinitionRoles.forEach(r -> {
            PresentationDefinitionRole newRole = new PresentationDefinitionRole();
            newRole.setCode(r.getCode());
            newRole.setTitle(r.getTitle());
            newRole.setSystemId(r.getSystemId());
            newRole.setRoledefinition(r.getRoledefinition());
            newRoles.add(newRole);
        });
        return newRoles;
    }

    @GetMapping(value={"roles/{code}"})
    public PresentationDefinitionRole getRole(@PathVariable(value="code") String code) {
        return this.presentationDefinitionService.getPresentationDefinitionRoleForUi(code);
    }

    @GetMapping(value={"/role-values/{code}"})
    public List<AspectCellData> getRoleValues(@PathVariable(value="code") String roleCode) {
        return this.presentationDefinitionService.getRoleListItems(roleCode);
    }

    @GetMapping(value={"/concept-labels"})
    public Map<String, String> getConceptLabels() {
        return this.presentationDefinitionService.getConceptLabels();
    }

    @PostMapping(value={"/toggle"})
    public Set<String> toggle(ToggleDTO toggleDTO) {
        return this.inactiveMembersService.toggle(toggleDTO, FilterViewType.PRESENTATION_DEFINITION);
    }

    @GetMapping(value={"/hypercubes/{code}"})
    public Map<String, List<DefinitionHypercube>> getHypercubes(@PathVariable(value="code") String code) {
        PresentationDefinitionRole presentationDefinitionRole = (PresentationDefinitionRole)this.presentationDefinitionService.getPresentationDefinitionData().getRoleMap().get(code);
        return this.hypercubeService.getHypercubesByRole(presentationDefinitionRole.getSystemId());
    }

    @ConstructorProperties(value={"presentationDefinitionService", "inactiveMembersService"})
    public PresentationDefinitionController(PresentationDefinitionService presentationDefinitionService, InactiveMembersService inactiveMembersService) {
        this.presentationDefinitionService = presentationDefinitionService;
        this.inactiveMembersService = inactiveMembersService;
    }
}

