/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.cbr.xbrl.converter.controller.import_export.PerformanceCheckStruct;
import ru.cbr.xbrl.converter.service.PerformanceCheckService;

@RestController
@RequestMapping(value={"performance-check"})
public class PerformanceCheckController {
    private static final Logger log = LoggerFactory.getLogger(PerformanceCheckController.class);
    @Autowired
    private PerformanceCheckService performanceCheckService;

    @PostMapping(value={"/packageValidation"})
    public void packageValidation(@RequestBody PerformanceCheckStruct performanceCheckStruct) throws Exception {
        this.performanceCheckService.processData(performanceCheckStruct, true);
    }

    @PostMapping(value={"/fullPerformanceCheck"})
    public void fullPerformanceCheck(@RequestBody PerformanceCheckStruct performanceCheckStruct) throws Exception {
        this.performanceCheckService.processData(performanceCheckStruct, false);
    }

    @GetMapping(value={"/formDifferenceProtocol"})
    public void formDifferenceProtocol(@RequestParam String xWandPath, @RequestParam String arellePath, @RequestParam boolean isAllowOverwriteFile) throws Exception {
        this.performanceCheckService.formDifferenceProtocol(xWandPath, arellePath, isAllowOverwriteFile);
    }

    @PostMapping(value={"/cancel"})
    public void cancel() {
        this.performanceCheckService.setLastActionCanceled(true);
    }
}

