/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.cbr.xbrl.converter.exception.IncompatibleCsvFilterFileEncodingException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.ReadFileException;
import ru.cbr.xbrl.converter.exception.WrongFilepathException;
import ru.cbr.xbrl.converter.model.tableLinkBase.DimensionDTO;
import ru.cbr.xbrl.converter.service.AspectNodeService;

@RestController
@RequestMapping(value={"aspect-node"})
public class AspectNodeController {
    private static final Logger log = LoggerFactory.getLogger(AspectNodeController.class);
    @Autowired
    private AspectNodeService aspectNodeService;

    @GetMapping(value={"members-for-dimension"})
    public DimensionDTO getMembersForDimension(@RequestParam(value="dim") String dim, @RequestParam(value="reportRoleId") Long reportRoleId, @RequestParam(value="hash") String hash) throws NotFoundException {
        return this.aspectNodeService.getMembersForNodeDimension(dim, reportRoleId, hash);
    }

    @PostMapping(value={"save-member"})
    public void save(@RequestParam(value="reportRoleId") Long reportRoleId, @RequestParam(value="dimension") String dimension, @RequestParam(value="member") String member, @RequestParam(value="hash") String hash) throws NotFoundException {
        this.aspectNodeService.saveMember(reportRoleId, dimension, member, hash, null);
    }

    @PostMapping(value={"import-members"})
    public void importMembers(@RequestParam(value="reportRoleId") Long reportRoleId, @RequestParam(value="dimension") String dimension, @RequestParam(value="filePath") String filePath, @RequestParam(value="hash") String hash, @RequestParam(value="rootAxisType") String rootAxisType) throws ReadFileException, IncompatibleCsvFilterFileEncodingException, WrongFilepathException {
        this.aspectNodeService.importMembers(reportRoleId, dimension, hash, filePath, rootAxisType);
    }

    @PostMapping(value={"delete-member"})
    public void delete(@RequestParam(value="reportRoleId") Long reportRoleId, @RequestParam(value="hash") String hash, @RequestParam(value="deleteChildren") Boolean deleteChildren) throws NotFoundException {
        this.aspectNodeService.deleteMember(reportRoleId, hash, deleteChildren);
    }
}

