/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.config.database;

import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableJpaRepositories(basePackages={"ru.cbr.xbrl.converter.repository_main"}, entityManagerFactoryRef="mainEntityManager", transactionManagerRef="mainTransactionManager")
public class MainDatabaseConfig {
    @Autowired
    private Environment env;
    @Value(value="${converter.datasource.main.properties.hibernate.dialect}")
    private String hibernateDialect;
    @Value(value="${converter.datasource.main.properties.hibernate.show_sql}")
    private String hibernateShowSql;
    @Value(value="${converter.datasource.main.properties.hibernate.hbm2ddl.auto}")
    private String hibernateHbm2ddlAuto;

    @Bean
    @Primary
    @ConfigurationProperties(prefix="converter.datasource.main")
    public DataSourceProperties mainDataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean
    @Primary
    @ConfigurationProperties(prefix="converter.datasource.main")
    public HikariDataSource mainDataSource() {
        return (HikariDataSource)this.mainDataSourceProperties().initializeDataSourceBuilder().type(HikariDataSource.class).build();
    }

    @Bean
    @Primary
    public LocalContainerEntityManagerFactoryBean mainEntityManager() {
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        em.setDataSource((DataSource)this.mainDataSource());
        em.setPackagesToScan(new String[]{"ru.cbr.xbrl.converter.model_main"});
        em.setPersistenceUnitName("mainPU");
        HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
        em.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("hibernate.hbm2ddl.auto", this.hibernateHbm2ddlAuto);
        properties.put("hibernate.dialect", this.hibernateDialect);
        properties.put("hibernate.show_sql", this.hibernateShowSql);
        em.setJpaPropertyMap(properties);
        return em;
    }

    @Primary
    @Bean
    public PlatformTransactionManager mainTransactionManager() {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        transactionManager.setEntityManagerFactory(this.mainEntityManager().getObject());
        return transactionManager;
    }
}

