/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.socket.config.annotation.AbstractWebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import ru.cbr.xbrl.converter.service.SystemServiceImpl;

@Configuration
@EnableWebSocketMessageBroker
@EnableScheduling
public class WebsocketConfig
extends AbstractWebSocketMessageBrokerConfigurer {
    private final SystemServiceImpl systemService;

    @Autowired
    public WebsocketConfig(SystemServiceImpl systemService) {
        this.systemService = systemService;
    }

    public void configureMessageBroker(MessageBrokerRegistry config) {
        config.enableSimpleBroker(new String[]{"/topic"});
        config.setApplicationDestinationPrefixes(new String[]{"/app"});
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{"/ws"}).setAllowedOrigins(new String[]{"*"}).withSockJS();
        this.systemService.checkStartedWebSocket();
    }
}

