/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.arelle.parse.definition_hypercube;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.function.Consumer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.arelle.parse.DimConcept;
import ru.cbr.xbrl.converter.arelle.parse.definition_hypercube.DimParserV2;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;

/*
 * Exception performing whole class analysis ignored.
 */
public class DimParserV2 {
    private static final Logger log = LoggerFactory.getLogger(DimParserV2.class);

    public static void parseFile(String fullFileName, Consumer<DimRoleData> consumer) {
        try (FileInputStream fileInputStream = new FileInputStream(fullFileName);){
            DimParserV2.parse(consumer, (InputStream)fileInputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public static void parseString(String xml, Consumer<DimRoleData> consumer) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8.name()));){
            DimParserV2.parse(consumer, (InputStream)inputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    private static void parse(Consumer<DimRoleData> consumer, InputStream inputStream) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        DimRoleData currentRole = null;
        LinkedList<DimConcept> conceptStack = new LinkedList<DimConcept>();
        XMLStreamReader reader = xmlInputFactory.createXMLStreamReader(new BufferedInputStream(inputStream));
        Integer level = null;
        DimConcept lastConcept = null;
        block6: while (reader.hasNext()) {
            int eventType = reader.next();
            switch (eventType) {
                case 7: {
                    break;
                }
                case 1: {
                    String currentStartElement = reader.getName().toString();
                    if (StringUtils.equalsIgnoreCase((CharSequence)"linkrole", (CharSequence)currentStartElement)) {
                        currentRole = new DimRoleData();
                        int n = reader.getAttributeCount();
                        for (int i = 0; i < n; ++i) {
                            QName attributeName = reader.getAttributeName(i);
                            String attributeValue = reader.getAttributeValue(i);
                            if (StringUtils.equalsIgnoreCase((CharSequence)"role", (CharSequence)attributeName.toString())) {
                                currentRole.setRoleSystemId(attributeValue);
                            }
                            if (!StringUtils.equalsIgnoreCase((CharSequence)"roledefinition", (CharSequence)attributeName.toString())) continue;
                            currentRole.setRoleDefinition(attributeValue);
                        }
                        continue block6;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"concept", (CharSequence)currentStartElement)) {
                        if (level == null) {
                            level = 0;
                        } else {
                            Integer i = level;
                            Integer n = level = Integer.valueOf(level + 1);
                        }
                        DimConcept concept = new DimConcept();
                        concept.setLevel(level.intValue());
                        int n = reader.getAttributeCount();
                        for (int i = 0; i < n; ++i) {
                            QName attributeName = reader.getAttributeName(i);
                            String attributeValue = reader.getAttributeValue(i);
                            if (StringUtils.equalsIgnoreCase((CharSequence)"name", (CharSequence)attributeName.toString())) {
                                concept.setName(attributeValue);
                            }
                            if (StringUtils.equalsIgnoreCase((CharSequence)"label", (CharSequence)attributeName.toString())) {
                                concept.setLabel(attributeValue);
                            }
                            if (StringUtils.equalsIgnoreCase((CharSequence)"abstract", (CharSequence)attributeName.toString())) {
                                concept.setAbstractNode(Boolean.valueOf(BooleanUtils.toBoolean((String)attributeValue)));
                            }
                            if (!StringUtils.equalsIgnoreCase((CharSequence)"dimensionType", (CharSequence)attributeName.toString())) continue;
                            if (attributeValue.equals("explicit")) {
                                concept.setDimensionType(DimensionType.EXPLICIT_MEMBER);
                                continue;
                            }
                            if (!attributeValue.equals("typed")) continue;
                            concept.setDimensionType(DimensionType.TYPED_MEMBER);
                        }
                        DimConcept parent = (DimConcept)conceptStack.peek();
                        if (parent != null) {
                            concept.getParents().addAll(conceptStack);
                            parent.getChildren().add(concept);
                        }
                        conceptStack.push(concept);
                        break;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"arcrole", (CharSequence)currentStartElement)) {
                        ((DimConcept)conceptStack.peek()).setArcrole(reader.getElementText());
                        break;
                    }
                }
                case 2: {
                    String currentEndElement = reader.getName().toString();
                    if (StringUtils.equalsIgnoreCase((CharSequence)"concept", (CharSequence)currentEndElement)) {
                        lastConcept = (DimConcept)conceptStack.pop();
                        if (level == 0) {
                            currentRole.getDimConcepts().add(lastConcept);
                        }
                        Integer n = level;
                        Integer n2 = level = Integer.valueOf(level - 1);
                        break;
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)"linkrole", (CharSequence)currentEndElement)) break;
                    consumer.accept(currentRole);
                    break;
                }
                case 8: {
                    break;
                }
            }
        }
    }
}

