/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.arelle.parse;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;

public class HypercubeDimensions {
    private static final Logger log = LoggerFactory.getLogger(HypercubeDimensions.class);
    List<List<XbrlContextDimension>> hypercubeDimensions = new ArrayList();

    public HypercubeDimensions(List<List<XbrlContextDimension>> hypercubeDimensions, Map<String, String> dimensionsDefault) {
        List hypercubeDimensionsWithowtDefault;
        this.hypercubeDimensions = hypercubeDimensionsWithowtDefault = this.removeDefaultDimensions(hypercubeDimensions, dimensionsDefault);
    }

    public boolean contains(List<XbrlContextDimension> dimensions) {
        return dimensions.stream().allMatch(d -> this.hypercubeDimensions.stream().anyMatch(hcDims -> hcDims.stream().anyMatch(hcDim -> d.getDimensionType().equals((Object)DimensionType.EXPLICIT_MEMBER) ? d.getDimension().equals(hcDim.getDimension()) && d.getMember().equals(hcDim.getMember()) : d.getDimension().equals(hcDim.getDimension()))));
    }

    private List<List<XbrlContextDimension>> removeDefaultDimensions(List<List<XbrlContextDimension>> hcDimensions, Map<String, String> dimensionsDefault) {
        if (CollectionUtils.isEmpty(dimensionsDefault)) {
            return hcDimensions;
        }
        ArrayList<List<XbrlContextDimension>> dimensionsWithoutDefault = new ArrayList<List<XbrlContextDimension>>();
        hcDimensions.forEach(xbrlContextDimensions -> {
            ArrayList dimList = new ArrayList();
            xbrlContextDimensions.forEach(xbrlContextDimension -> {
                if (!dimensionsDefault.containsKey(xbrlContextDimension.getDimension()) || !((String)dimensionsDefault.get(xbrlContextDimension.getDimension())).equals(xbrlContextDimension.getMember())) {
                    dimList.add(xbrlContextDimension);
                } else {
                    log.info("HypercubeDimensions: Removed dimensionDefault {} {} ", (Object)xbrlContextDimension.getDimension(), (Object)xbrlContextDimension.getMember());
                }
            });
            dimensionsWithoutDefault.add(dimList);
        });
        return dimensionsWithoutDefault;
    }

    public List<List<XbrlContextDimension>> getHypercubeDimensions() {
        return this.hypercubeDimensions;
    }

    public void setHypercubeDimensions(List<List<XbrlContextDimension>> hypercubeDimensions) {
        this.hypercubeDimensions = hypercubeDimensions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HypercubeDimensions)) {
            return false;
        }
        HypercubeDimensions other = (HypercubeDimensions)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$hypercubeDimensions = this.getHypercubeDimensions();
        List other$hypercubeDimensions = other.getHypercubeDimensions();
        return !(this$hypercubeDimensions == null ? other$hypercubeDimensions != null : !((Object)this$hypercubeDimensions).equals(other$hypercubeDimensions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HypercubeDimensions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $hypercubeDimensions = this.getHypercubeDimensions();
        result = result * 59 + ($hypercubeDimensions == null ? 43 : ((Object)$hypercubeDimensions).hashCode());
        return result;
    }

    public String toString() {
        return "HypercubeDimensions(hypercubeDimensions=" + this.getHypercubeDimensions() + ")";
    }

    public HypercubeDimensions() {
    }
}

