/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.arelle.parse;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import ru.cbr.xbrl.converter.arelle.parse.HypercubeType;
import ru.cbr.xbrl.converter.arelle.parse.definition_hypercube.dto.DefinitionHypercubeDimension;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;

public class DimConcept
implements Serializable {
    public static final String ARCROLE_AXIS = "Axis";
    public static final String ARCROLE_ALL = "all";
    public static final String ARCROLE_NOTALL = "notAll";
    public static final String ARCROLE_HYPERCUBE_DIMENSION = "hypercube-dimension";
    public static final String ARCROLE_DIMENSION_DEFAULT = "dimension-default";
    public static String[] HYPERCUBE_ARCROLES = new String[]{"Axis", "all", "notAll"};
    private String label;
    private String documentation;
    private String name;
    private String arcrole;
    private Boolean abstractNode;
    private Boolean usable = true;
    private String periodType;
    private List<DimConcept> children = new ArrayList();
    private List<DimConcept> parents = new ArrayList();
    private int level;
    private DimensionType dimensionType;
    private Double order = 0.0;

    public DimConcept getNearParent() {
        return this.parents.size() > 0 ? (DimConcept)this.parents.get(0) : null;
    }

    public boolean isHypercubeArcrole() {
        return Arrays.stream(HYPERCUBE_ARCROLES).anyMatch(Predicate.isEqual(this.arcrole));
    }

    public void iterateAll(BiConsumer<DimConcept, DimConcept> dimConceptConsumer) {
        this.children.forEach(dimConcept -> {
            dimConceptConsumer.accept((DimConcept)dimConcept, this);
            dimConcept.iterateAll(dimConceptConsumer);
        });
    }

    public void iterateChildren(Consumer<DimConcept> dimConceptConsumer) {
        this.children.forEach(dimConcept -> {
            dimConceptConsumer.accept((DimConcept)dimConcept);
            dimConcept.iterateChildren(dimConceptConsumer);
        });
    }

    public Set<String> getChildrenNames() {
        HashSet<String> memberSet = new HashSet<String>();
        this.iterateChildren(child -> {
            String memint = child.getName();
            memberSet.add(memint);
        });
        return memberSet;
    }

    public DefinitionHypercubeDimension buldHypercubeDimension() {
        DefinitionHypercubeDimension hypercubeDimension = new DefinitionHypercubeDimension();
        HashSet memberSet = new HashSet();
        this.iterateChildren(child -> {
            String memint = child.getName();
            memberSet.add(memint);
        });
        hypercubeDimension.setMembers(memberSet);
        hypercubeDimension.setDimensionType(this.dimensionType);
        hypercubeDimension.setDimension(this.name);
        return hypercubeDimension;
    }

    public List<DimConcept> getHypercubes() {
        return this.children.stream().filter(DimConcept::isHypercubeArcrole).collect(Collectors.toList());
    }

    public DimConcept findHypercube() {
        Optional<DimConcept> firstHypercube = this.children.stream().filter(DimConcept::isHypercubeArcrole).findFirst();
        return firstHypercube.orElse(null);
    }

    public HypercubeType getHypercubeTypeByArcrole() {
        if (this.arcrole == null) {
            return null;
        }
        if (this.arcrole.equals(ARCROLE_ALL) || this.arcrole.equals(ARCROLE_AXIS)) {
            return HypercubeType.ALL;
        }
        if (this.arcrole.equals(ARCROLE_NOTALL)) {
            return HypercubeType.NOT_ALL;
        }
        return null;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public String getName() {
        return this.name;
    }

    public String getArcrole() {
        return this.arcrole;
    }

    public Boolean getAbstractNode() {
        return this.abstractNode;
    }

    public Boolean getUsable() {
        return this.usable;
    }

    public String getPeriodType() {
        return this.periodType;
    }

    public List<DimConcept> getChildren() {
        return this.children;
    }

    public List<DimConcept> getParents() {
        return this.parents;
    }

    public int getLevel() {
        return this.level;
    }

    public DimensionType getDimensionType() {
        return this.dimensionType;
    }

    public Double getOrder() {
        return this.order;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setArcrole(String arcrole) {
        this.arcrole = arcrole;
    }

    public void setAbstractNode(Boolean abstractNode) {
        this.abstractNode = abstractNode;
    }

    public void setUsable(Boolean usable) {
        this.usable = usable;
    }

    public void setPeriodType(String periodType) {
        this.periodType = periodType;
    }

    public void setChildren(List<DimConcept> children) {
        this.children = children;
    }

    public void setParents(List<DimConcept> parents) {
        this.parents = parents;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setDimensionType(DimensionType dimensionType) {
        this.dimensionType = dimensionType;
    }

    public void setOrder(Double order) {
        this.order = order;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DimConcept)) {
            return false;
        }
        DimConcept other = (DimConcept)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$documentation = this.getDocumentation();
        String other$documentation = other.getDocumentation();
        if (this$documentation == null ? other$documentation != null : !this$documentation.equals(other$documentation)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$arcrole = this.getArcrole();
        String other$arcrole = other.getArcrole();
        if (this$arcrole == null ? other$arcrole != null : !this$arcrole.equals(other$arcrole)) {
            return false;
        }
        Boolean this$abstractNode = this.getAbstractNode();
        Boolean other$abstractNode = other.getAbstractNode();
        if (this$abstractNode == null ? other$abstractNode != null : !((Object)this$abstractNode).equals(other$abstractNode)) {
            return false;
        }
        Boolean this$usable = this.getUsable();
        Boolean other$usable = other.getUsable();
        if (this$usable == null ? other$usable != null : !((Object)this$usable).equals(other$usable)) {
            return false;
        }
        String this$periodType = this.getPeriodType();
        String other$periodType = other.getPeriodType();
        if (this$periodType == null ? other$periodType != null : !this$periodType.equals(other$periodType)) {
            return false;
        }
        List this$children = this.getChildren();
        List other$children = other.getChildren();
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        List this$parents = this.getParents();
        List other$parents = other.getParents();
        if (this$parents == null ? other$parents != null : !((Object)this$parents).equals(other$parents)) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        DimensionType this$dimensionType = this.getDimensionType();
        DimensionType other$dimensionType = other.getDimensionType();
        if (this$dimensionType == null ? other$dimensionType != null : !this$dimensionType.equals(other$dimensionType)) {
            return false;
        }
        Double this$order = this.getOrder();
        Double other$order = other.getOrder();
        return !(this$order == null ? other$order != null : !((Object)this$order).equals(other$order));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DimConcept;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $documentation = this.getDocumentation();
        result = result * 59 + ($documentation == null ? 43 : $documentation.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $arcrole = this.getArcrole();
        result = result * 59 + ($arcrole == null ? 43 : $arcrole.hashCode());
        Boolean $abstractNode = this.getAbstractNode();
        result = result * 59 + ($abstractNode == null ? 43 : ((Object)$abstractNode).hashCode());
        Boolean $usable = this.getUsable();
        result = result * 59 + ($usable == null ? 43 : ((Object)$usable).hashCode());
        String $periodType = this.getPeriodType();
        result = result * 59 + ($periodType == null ? 43 : $periodType.hashCode());
        List $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        List $parents = this.getParents();
        result = result * 59 + ($parents == null ? 43 : ((Object)$parents).hashCode());
        result = result * 59 + this.getLevel();
        DimensionType $dimensionType = this.getDimensionType();
        result = result * 59 + ($dimensionType == null ? 43 : $dimensionType.hashCode());
        Double $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
        return result;
    }

    public String toString() {
        return "DimConcept(label=" + this.getLabel() + ", documentation=" + this.getDocumentation() + ", name=" + this.getName() + ", arcrole=" + this.getArcrole() + ", abstractNode=" + this.getAbstractNode() + ", usable=" + this.getUsable() + ", periodType=" + this.getPeriodType() + ", children=" + this.getChildren() + ", parents=" + this.getParents() + ", level=" + this.getLevel() + ", dimensionType=" + this.getDimensionType() + ", order=" + this.getOrder() + ")";
    }
}

