/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.arelle.executor;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.arelle.executor.ServerLogProcessingThread;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.service.XbrlReportService;
import ru.cbr.xbrl.converter.service.XbrlValidateServiceImpl;

class ServerLogProcessingThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(ServerLogProcessingThread.class);
    private final String SEPARATOR = "^^^^^";
    private final String SOCKET_END_SEQUENCE = "###close###";
    private ServerSocket serverSocket;
    private volatile LinkedList<LogProcessingThread> clientsList = new LinkedList();
    private volatile XbrlReport xbrlReport;
    private volatile XbrlReportService xbrlReportService;
    private volatile XbrlValidateServiceImpl xbrlValidateService;
    private volatile int logEntryNumber = 1;
    private long saveTime;
    private long parseTime;

    ServerLogProcessingThread(int serverPort, XbrlReport xbrlReport, XbrlReportService xbrlReportService, XbrlValidateServiceImpl xbrlValidateService) throws IOException {
        this.xbrlReport = xbrlReport;
        this.serverSocket = new ServerSocket(serverPort);
        this.xbrlReportService = xbrlReportService;
        this.xbrlValidateService = xbrlValidateService;
        this.saveTime = 0L;
        this.parseTime = 0L;
        this.start();
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        try {
            while (true) {
                Socket socket = this.serverSocket.accept();
                this.clientsList.add(new LogProcessingThread(this, socket));
                log.info("New client socket connected: " + socket);
            }
        }
        catch (SocketException e) {
            try {
                log.info("Down service with SocketException: ", (Throwable)e);
                this.downService();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            this.xbrlValidateService.resetValidationRun();
        }
        catch (IOException e) {
            try {
                log.error("Down service with IOException: ", (Throwable)e);
                this.downService();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        catch (Exception e) {
            log.error("Down service with Exception: ", (Throwable)e);
            try {
                this.downService();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            this.xbrlValidateService.resetValidationRun();
        }
        {
            finally {
                this.xbrlValidateService.resetValidationRun();
            }
        }
    }

    private synchronized void downService() throws IOException {
        for (LogProcessingThread thread : this.clientsList) {
            thread.processBuffer();
            thread.closeReader();
            thread.closeSocket();
            if (!thread.isAlive()) continue;
            thread.interrupt();
        }
        if (this.serverSocket != null && !this.serverSocket.isClosed()) {
            this.serverSocket.close();
        }
        this.interrupt();
    }

    public String getSEPARATOR() {
        this.getClass();
        return "^^^^^";
    }

    public String getSOCKET_END_SEQUENCE() {
        this.getClass();
        return "###close###";
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public LinkedList<LogProcessingThread> getClientsList() {
        return this.clientsList;
    }

    public XbrlReport getXbrlReport() {
        return this.xbrlReport;
    }

    public XbrlReportService getXbrlReportService() {
        return this.xbrlReportService;
    }

    public XbrlValidateServiceImpl getXbrlValidateService() {
        return this.xbrlValidateService;
    }

    public int getLogEntryNumber() {
        return this.logEntryNumber;
    }

    public long getSaveTime() {
        return this.saveTime;
    }

    public long getParseTime() {
        return this.parseTime;
    }

    public void setServerSocket(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    public void setClientsList(LinkedList<LogProcessingThread> clientsList) {
        this.clientsList = clientsList;
    }

    public void setXbrlReport(XbrlReport xbrlReport) {
        this.xbrlReport = xbrlReport;
    }

    public void setXbrlReportService(XbrlReportService xbrlReportService) {
        this.xbrlReportService = xbrlReportService;
    }

    public void setXbrlValidateService(XbrlValidateServiceImpl xbrlValidateService) {
        this.xbrlValidateService = xbrlValidateService;
    }

    public void setLogEntryNumber(int logEntryNumber) {
        this.logEntryNumber = logEntryNumber;
    }

    public void setSaveTime(long saveTime) {
        this.saveTime = saveTime;
    }

    public void setParseTime(long parseTime) {
        this.parseTime = parseTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerLogProcessingThread)) {
            return false;
        }
        ServerLogProcessingThread other = (ServerLogProcessingThread)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$SEPARATOR = this.getSEPARATOR();
        String other$SEPARATOR = other.getSEPARATOR();
        if (this$SEPARATOR == null ? other$SEPARATOR != null : !this$SEPARATOR.equals(other$SEPARATOR)) {
            return false;
        }
        String this$SOCKET_END_SEQUENCE = this.getSOCKET_END_SEQUENCE();
        String other$SOCKET_END_SEQUENCE = other.getSOCKET_END_SEQUENCE();
        if (this$SOCKET_END_SEQUENCE == null ? other$SOCKET_END_SEQUENCE != null : !this$SOCKET_END_SEQUENCE.equals(other$SOCKET_END_SEQUENCE)) {
            return false;
        }
        ServerSocket this$serverSocket = this.getServerSocket();
        ServerSocket other$serverSocket = other.getServerSocket();
        if (this$serverSocket == null ? other$serverSocket != null : !this$serverSocket.equals(other$serverSocket)) {
            return false;
        }
        LinkedList this$clientsList = this.getClientsList();
        LinkedList other$clientsList = other.getClientsList();
        if (this$clientsList == null ? other$clientsList != null : !((Object)this$clientsList).equals(other$clientsList)) {
            return false;
        }
        XbrlReport this$xbrlReport = this.getXbrlReport();
        XbrlReport other$xbrlReport = other.getXbrlReport();
        if (this$xbrlReport == null ? other$xbrlReport != null : !this$xbrlReport.equals(other$xbrlReport)) {
            return false;
        }
        XbrlReportService this$xbrlReportService = this.getXbrlReportService();
        XbrlReportService other$xbrlReportService = other.getXbrlReportService();
        if (this$xbrlReportService == null ? other$xbrlReportService != null : !this$xbrlReportService.equals(other$xbrlReportService)) {
            return false;
        }
        XbrlValidateServiceImpl this$xbrlValidateService = this.getXbrlValidateService();
        XbrlValidateServiceImpl other$xbrlValidateService = other.getXbrlValidateService();
        if (this$xbrlValidateService == null ? other$xbrlValidateService != null : !this$xbrlValidateService.equals(other$xbrlValidateService)) {
            return false;
        }
        if (this.getLogEntryNumber() != other.getLogEntryNumber()) {
            return false;
        }
        if (this.getSaveTime() != other.getSaveTime()) {
            return false;
        }
        return this.getParseTime() == other.getParseTime();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerLogProcessingThread;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $SEPARATOR = this.getSEPARATOR();
        result = result * 59 + ($SEPARATOR == null ? 43 : $SEPARATOR.hashCode());
        String $SOCKET_END_SEQUENCE = this.getSOCKET_END_SEQUENCE();
        result = result * 59 + ($SOCKET_END_SEQUENCE == null ? 43 : $SOCKET_END_SEQUENCE.hashCode());
        ServerSocket $serverSocket = this.getServerSocket();
        result = result * 59 + ($serverSocket == null ? 43 : $serverSocket.hashCode());
        LinkedList $clientsList = this.getClientsList();
        result = result * 59 + ($clientsList == null ? 43 : ((Object)$clientsList).hashCode());
        XbrlReport $xbrlReport = this.getXbrlReport();
        result = result * 59 + ($xbrlReport == null ? 43 : $xbrlReport.hashCode());
        XbrlReportService $xbrlReportService = this.getXbrlReportService();
        result = result * 59 + ($xbrlReportService == null ? 43 : $xbrlReportService.hashCode());
        XbrlValidateServiceImpl $xbrlValidateService = this.getXbrlValidateService();
        result = result * 59 + ($xbrlValidateService == null ? 43 : $xbrlValidateService.hashCode());
        result = result * 59 + this.getLogEntryNumber();
        long $saveTime = this.getSaveTime();
        result = result * 59 + (int)($saveTime >>> 32 ^ $saveTime);
        long $parseTime = this.getParseTime();
        result = result * 59 + (int)($parseTime >>> 32 ^ $parseTime);
        return result;
    }

    @Override
    public String toString() {
        return "ServerLogProcessingThread(SEPARATOR=" + this.getSEPARATOR() + ", SOCKET_END_SEQUENCE=" + this.getSOCKET_END_SEQUENCE() + ", serverSocket=" + this.getServerSocket() + ", clientsList=" + this.getClientsList() + ", xbrlReport=" + this.getXbrlReport() + ", xbrlReportService=" + this.getXbrlReportService() + ", xbrlValidateService=" + this.getXbrlValidateService() + ", logEntryNumber=" + this.getLogEntryNumber() + ", saveTime=" + this.getSaveTime() + ", parseTime=" + this.getParseTime() + ")";
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ void access$100(ServerLogProcessingThread x0) throws IOException {
        x0.downService();
    }

    static /* synthetic */ XbrlReport access$200(ServerLogProcessingThread x0) {
        return x0.xbrlReport;
    }

    static /* synthetic */ long access$300(ServerLogProcessingThread x0) {
        return x0.parseTime;
    }

    static /* synthetic */ long access$302(ServerLogProcessingThread x0, long x1) {
        x0.parseTime = x1;
        return x0.parseTime;
    }

    static /* synthetic */ int access$408(ServerLogProcessingThread x0) {
        return x0.logEntryNumber++;
    }

    static /* synthetic */ XbrlReportService access$500(ServerLogProcessingThread x0) {
        return x0.xbrlReportService;
    }

    static /* synthetic */ XbrlValidateServiceImpl access$600(ServerLogProcessingThread x0) {
        return x0.xbrlValidateService;
    }

    static /* synthetic */ long access$700(ServerLogProcessingThread x0) {
        return x0.saveTime;
    }

    static /* synthetic */ long access$702(ServerLogProcessingThread x0, long x1) {
        x0.saveTime = x1;
        return x0.saveTime;
    }
}

