/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xblr.converter.updater.yaml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xblr.converter.updater.UpdaterApplication;
import ru.cbr.xblr.converter.updater.yaml.YamlUtils;
import ru.cbr.xblr.converter.updater.yaml.dto.DefaultConfig;

/*
 * Exception performing whole class analysis ignored.
 */
public class YamlUtils {
    private static Logger log = LoggerFactory.getLogger(UpdaterApplication.class);

    public static DefaultConfig findAndReadDefaultYamlConfig(Path directory) throws IOException {
        Path[] defaultConfigPath = new Path[1];
        YamlUtils.findNewConfigFile((Path)directory, (Path[])defaultConfigPath);
        if (defaultConfigPath[0] == null) {
            log.warn("Previous .yml configuration is not found");
            return null;
        }
        log.info("Previous .yml is found");
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (DefaultConfig)mapper.readValue(new File(String.valueOf(defaultConfigPath[0])), DefaultConfig.class);
    }

    public static void findAndModifyDefaultYamlConfig(Path directory, DefaultConfig previousConfiguration) throws IOException {
        Boolean isTemplateTabAvailable = YamlUtils.isTemplateTabAvailable((DefaultConfig)previousConfiguration);
        if (isTemplateTabAvailable == null) {
            log.info("Previous .yml doesn't contain isTemplateTabAvailable");
        } else {
            log.info("Previous .yml contains isTemplateTabAvailable: " + isTemplateTabAvailable);
        }
        Boolean isTechTestingTab = YamlUtils.isTechTestingTab((DefaultConfig)previousConfiguration);
        if (isTechTestingTab == null) {
            log.info("Previous .yml doesn't contain isTechTestingTab");
        } else {
            log.info("Previous .yml contains isTechTestingTab: " + isTechTestingTab);
        }
        Path[] defaultConfigPath = new Path[1];
        YamlUtils.findNewConfigFile((Path)directory, (Path[])defaultConfigPath);
        if (defaultConfigPath[0] == null) {
            return;
        }
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER));
        DefaultConfig modifiedConfig = (DefaultConfig)mapper.readValue(new File(String.valueOf(defaultConfigPath[0])), DefaultConfig.class);
        if (isTemplateTabAvailable != null) {
            modifiedConfig.getApplication().getBackend().setIsTemplateTabAvailable(isTemplateTabAvailable);
        }
        if (isTechTestingTab != null) {
            modifiedConfig.getApplication().getBackend().setIsTechTestingTab(isTechTestingTab);
        }
        DefaultSerializerProvider.Impl sp = new DefaultSerializerProvider.Impl();
        sp.setNullValueSerializer((JsonSerializer)new NullSerializer());
        mapper.setSerializerProvider((DefaultSerializerProvider)sp);
        mapper.writeValue(new File(String.valueOf(defaultConfigPath[0])), (Object)modifiedConfig);
        if (isTemplateTabAvailable != null) {
            log.info("New .yml file is modified with isTemplateTabAvailable");
        }
        if (isTechTestingTab != null) {
            log.info("New .yml file is modified with isTechTestingTab");
        }
    }

    private static Boolean isTemplateTabAvailable(DefaultConfig configuration) {
        if (configuration == null || configuration.getApplication() == null || configuration.getApplication().getBackend() == null || configuration.getApplication().getBackend().getIsTemplateTabAvailable() == null) {
            return null;
        }
        return configuration.getApplication().getBackend().getIsTemplateTabAvailable();
    }

    private static Boolean isTechTestingTab(DefaultConfig configuration) {
        if (configuration == null || configuration.getApplication() == null || configuration.getApplication().getBackend() == null || configuration.getApplication().getBackend().getIsTechTestingTab() == null) {
            return null;
        }
        return configuration.getApplication().getBackend().getIsTechTestingTab();
    }

    private static void findNewConfigFile(Path directory, Path[] defaultConfigPath) throws IOException {
        Files.walk(Paths.get(directory.toString(), new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(x -> {
            if (x.getFileName().toString().contains("config.default.yml")) {
                defaultConfigPath[0] = x;
            }
        });
    }
}

