﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;


namespace CoinsBaseTestAPP
{
    public partial class Form1 : Form
    {

        CoinsBaseTestAPP.CoinsService.CoinsBaseWS CoinsClient;
        public Form1()
        {
            InitializeComponent();
            CoinsClient = new CoinsService.CoinsBaseWS();


            Years.Items.Add(new YearSelect() { year = 0, Title = "Все года" });
            Years.ValueMember = "year";
            Years.DisplayMember = "Title";
            for (int i = 2010; i <= DateTime.Now.Year; i++)
            {
                Years.Items.Add(new YearSelect() { year = i, Title = i.ToString() });
            }
            Years.SelectedIndex = Years.Items.Count - 1;


            var nominalsDS = CoinsClient.EnumNominals();

            var new_row = nominalsDS.Tables[0].NewRow();
           
            new_row[0] = -1;
            new_row[1] = "Все";
            new_row[2] = "All";          

           
            nominalsDS.Tables[0].Rows.InsertAt(new_row, 0);

            string shame = nominalsDS.GetXmlSchema();
            File.WriteAllText("EnumNominals.xsd", shame);

            var metallsDS = CoinsClient.EnumMetals();

            var new_Metallrow = metallsDS.Tables[0].NewRow();

            new_Metallrow[0] = 0;
            new_Metallrow[1] = "Все";
            new_Metallrow[2] = "All";
            new_Metallrow[3] = "Все";
            new_Metallrow[4] = "All";

            metallsDS.Tables[0].Rows.InsertAt(new_Metallrow, 0);

            string m_shame = metallsDS.GetXmlSchema();
            File.WriteAllText("EnumMetals.xsd", m_shame);


            var s_DS = CoinsClient.EnumSeries();
            var new_Serierow = s_DS.Tables[0].NewRow();
            new_Serierow[0] = 0;
            new_Serierow[1] = "";
            new_Serierow[2] = "Все";
            new_Serierow[3] = "";
            new_Serierow[4] = "All";
            s_DS.Tables[0].Rows.InsertAt(new_Serierow, 0);

            string s_shame = s_DS.GetXmlSchema();
            File.WriteAllText("EnumSeries.xsd", s_shame);

            NominalsBox.DataSource = nominalsDS.Tables[0];
            NominalsBox.DisplayMember = "Nominal_Rus";

            MetallBox.DataSource = metallsDS.Tables[0];
            MetallBox.DisplayMember = "Metall_Rus";

            SeriesBox.DataSource = s_DS.Tables[0];
            SeriesBox.DisplayMember = "Name";
        }

        private void button1_Click(object sender, EventArgs e)
        {

            //var ds=CoinsClient.SearchMonet("*", 2020, -1, 0, 0, 0); // for example
            var ys = (YearSelect)Years.SelectedItem;

            var nom_ds = (DataTable)NominalsBox.DataSource;
            var metall_ds = (DataTable)MetallBox.DataSource;
            var seria_ds = (DataTable)SeriesBox.DataSource;

            int nominals_code=  System.Convert.ToInt32((nom_ds.Rows[NominalsBox.SelectedIndex])[0]);
            int metalls_code = System.Convert.ToInt32((metall_ds.Rows[MetallBox.SelectedIndex])[0]);
            int seria_code = System.Convert.ToInt32((seria_ds.Rows[SeriesBox.SelectedIndex])[0]);

            int forInvest = ForInvestBox.Checked ? 1 : 0;
            var ds = CoinsClient.SearchMonet(SearchBox.Text,ys.year, nominals_code, metalls_code, seria_code, forInvest);
            string shame =ds.GetXmlSchema();
            File.WriteAllText("SearchMonet.xsd", shame);

            dataGridView1.DataSource = ds.Tables[0];





        }

        private void dataGridView1_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {
            if (e.RowIndex == -1) return;
            var dt = (DataTable)dataGridView1.DataSource;
            var row=dt.Rows[e.RowIndex];
            string numbber = row[0].ToString();

            var ds = CoinsClient.GetMonetDetailInfo(numbber, false);
            string shame = ds.GetXmlSchema();
            File.WriteAllText("GetMonetDetailInfo.xsd", shame);

            DetailView dw = new DetailView();
            dw.DetailGrid.DataSource = ds.Tables[0];
            dw.ShowDialog();


        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }
    }

    class YearSelect
    {
        public int year { get; set; }
        public string Title { get; set; }
    }

}
